/************************************************************************
			Class entries
 ************************************************************************
 2009/10/23 - OBJNET - V2r14a: Create
 ************************************************************************/
#include <config.h>
#include <usercfg.h>
#include <pac.h>

#if config_MLOSREP
#include <pach.h>
#endif
#include <FILE.H>

#define verberr	1

#define ModName		"FILE_FS"

#define pGlob	((pac_EntryType *)pGlob0)
/*----------------------------------------------------------------------*
		Define "Local" Globals
 *----------------------------------------------------------------------*/
#define Version_Len 1

#if !config_MLOSREP
//Client
static pac_EntryXType(Version_Len) GlobEntry;


typedef
 err_Type file_FSFileCreateOBNType();
static
file_FSFileCreateOBNType * file_FSFileCreate0	= 0;
err_Type file_FSFileCreate(
	file_FSRef  This0
	,ulong  Mode
	,ulong  Attr
	,file_Ref * pFile
	,char * Path
	
	)
{
  
  if (file_FSFileCreate0 == 0) return(pac__EntryNoFunc);
  return((*file_FSFileCreate0)(
           This0
           ,Mode
           ,Attr
           ,pFile
           ,Path
           
           ));
}


#endif
/*----------------------------------------------------------------------*
                Get Globals from inside
 *----------------------------------------------------------------------*/
#if !config_MLOSREP
// Package client 
// Defined in upper level 
extern
err_Type file_FSEntryGet(
        pac_Type * Pac,
        unsigned Mode,		// Take, release
        char * Name, 		// Interface name
        void * pGlob0	// OUT: List of globals
        );
/*----------------------------------------------------------------------*/
#else
// Package REP
err_Type file_FSEntryGet(
        pac_Type * Pac,
        unsigned Mode,		// Take, release
        char * Name, 		// Interface name
        void * pGlob0		// OUT: List of globals
        )
{
  err_Type erno = 0;
  pac_EntryItemType * p = (pac_EntryItemType *)pGlob->ObjList;
  
  if ((pGlob->Mode & pac_EntryModeX)==0) return(pac__EntryLength);
  if (pGlob->SizeOf < pac_EntryXSizeOf(0)) return(pac__EntryLength);
  
  strcpy(pGlob->Name, "file_FS");
  
  if (Mode & pac_EntryModeRelease) {
    erno = pac_EntryUpdate(pGlob, Mode | pac_EntryModeAll, 0,0,0,0,0);
    goto fin;
  }
  do {

    erno = pac_EntryUpdate(pGlob, 
                           Mode, 
                           1,
                           file_FSFileCreate, 
                           pac_EntryItemModeFunc, // Type of method
                           0,			  // Num of method
                           "FileCreate"
                           );
    // Ignore entries that can not be updated
    if (erno == pac__EntryNotFound) erno = 0;
    if (erno) break;
  } while(0);
  fin:;
  return(erno);
}
#endif
/*----------------------------------------------------------------------*
                        Init
 *----------------------------------------------------------------------*/
#if !config_MLOSREP
// Client
static
err_Type EntryInit(
        void * pGlob0	// IN/OUT: List of globals
        )
{
  err_Type erno=0;
  pac_EntryItemType * p;
  char * Interface = "MAIN"; 
  
  pGlob->SizeOf		= pac_EntryXSizeOf(Version_Len);
  pGlob->Mode		= pac_EntryModeX;
  strcpy(pGlob->Name, Interface);
  pGlob->ObjListLen	= Version_Len;
  
  p = (pac_EntryItemType *)pGlob->ObjList;
  memset(&p[0], 0, sizeof(pac_EntryItemType));
  
  do {

    erno = pac_EntryUpdate(pGlob, 
                           pac_EntryModeInit, 
                           1,
                           0, 
                           pac_EntryItemModeFunc, 
                           0,
                           "FileCreate"
                           );
    if (erno) break;
  } while(0);
  return(erno);
}
/*----------------------------------------------------------------------*
			Set
 *----------------------------------------------------------------------*/
// Client
static
err_Type EntrySet(
        void * pGlob0,	// IN: List of globals
        unsigned Mode
        )
{
  err_Type erno = 0;
  pac_EntryItemType * p;
  ulong Idx;
  
  if (pGlob->ObjListLen < Version_Len) return(pac__EntryLength);
  if ((pGlob->Mode & pac_EntryModeX)==0) return(pac__EntryLength);
  p = (pac_EntryItemType *)pGlob->ObjList;
  
  if ((Mode & pac_EntryModeRelease)==0) {
    // Take (After Release ModeSet is off)
    // Assume all items are correctly returned and in the good order
    // A missing item raises an error
    for (Idx=1;Idx <= Version_Len;Idx++) {
      if ((p[Idx].Mode & pac_EntryItemModeSet)==0) {
        erno = pac__EntryNotFound;
        err_Printf(verberr,"-%s.EntrySet: <%s.%s> entry is missing\n", ModName, 
                            pGlob->Name,p[Idx].Name
                            );
      }
    } // for 
    if (erno) return(erno);
  }
  

  file_FSFileCreate0 = (file_FSFileCreateOBNType *)p[1].Val;
  return(erno);
}
#endif
/*----------------------------------------------------------------------*
                        Start for REP
 Init "local" globals
 MANDATORY: Do not declare in .DEF
 *----------------------------------------------------------------------*/
err_Type file_FSEntryStart(
        usercfg_Type * cfg
        )
{
  err_Type erno = 0;
  
  #if !config_MLOSREP
  // Package client
  erno = EntryInit(&GlobEntry);
  if (erno) return(erno);
  erno = file_FSEntryGet(0, 0, "file_FS", &GlobEntry);
  if (erno) return(erno);
  erno = EntrySet(&GlobEntry, 0);
  #endif
  
  return(erno);
}
/*----------------------------------------------------------------------*
                        End for REP
 Init "local" globals
 MANDATORY: Do not declare in .DEF
 *----------------------------------------------------------------------*/
err_Type file_FSEntryEnd(
        usercfg_Type * cfg
        )
{
  err_Type erno = 0;
  
  #if !config_MLOSREP
  // Client
  erno = file_FSEntryGet(0, pac_EntryModeRelease, "file_FS", &GlobEntry);
  if (erno) return(erno);
  erno = EntrySet(&GlobEntry, pac_EntryModeRelease);
  #endif
  
  return(erno);
}
