/***********************************************************************
                        Hardware INTERFACE
 			Remote access (X)
                        IO
 ***********************************************************************
 Included into applis and system
 ***********************************************************************
 01/04/2009 - Marc LEGOUX : V2r23p : Rename functions only inside system
 15/06/2005 - Marc LEGOUX : krn2r22 : Rename functions for MLOSWIN
 24/06/2003 - Marc LEGOUX : krn2r06 : Add hwi_NOOp0
 19/06/2003 - Marc LEGOUX : krn2r06 : Add hwi_NOOpGet()
 02/02/2002 - Marc LEGOUX : krn2r01 : Use hwi_NOOpCtxId
 07/01/2000 - Marc LEGOUX : krn1r05
 ***********************************************************************/
#include <hwi.h>
#include <hwiio.h>
#include <hwiiox.h>

#include <sysobj.h>
#include <util.h>
#include <syst.h>

#if config_MLOS8
sysobj_NOType hwi_NOOp = sys_HwiOps;	/* Local to a task */
#else
unsigned hwi_NOOpCtxId = 0;		/* Index in Task context */
#endif

#define hwi_NOOp0 ((sysobj_NOType)syst_TaskCtxGet(hwi_NOOpCtxId) | sys_HwiOps)
/*----------------------------------------------------------------------*
                        Get node
 *----------------------------------------------------------------------*/
sysobj_NOType hwi_NOOpGet()
{
  return((sysobj_NOType)syst_TaskCtxGet(hwi_NOOpCtxId));
}
/*---------------------------------------------------------------------*
                        HWI Init
 *---------------------------------------------------------------------*/
err_Type hwi_Init(sysobj_NodeType Node)
{
  err_Type erno;
  sysobj_NOType NO;
  
  if (hwi_NOOpCtxId == 0) {
    erno = syst_TaskCtxAlloc(&hwi_NOOpCtxId);
    if (erno) return(erno);
  }
  
  NO = Node;
  NO <<= 8;
  syst_TaskCtxSet(hwi_NOOpCtxId, (void *)NO);
  return(0);
}
/***********************************************************************
                        IOs
 ***********************************************************************/
#if config_WIN && config_MLOSREP
// Rename to avoid a conflict inside system DLL
// X symbols are used in .DEF
#define hwi_IOGet	hwi_IOGetX
#define hwi_IOPut	hwi_IOPutX
#endif
/*---------------------------------------------------------------------*
                        IO Get
 *---------------------------------------------------------------------*/
err_Type hwi_IOGet(uchar * pmask)
{
  err_Type erno;
  sysobj_LType respl;
  uchar buf[1];
  
  respl = 1;
  buf[0] = hwi_OpIOGet;
  erno = sysobj_Call(buf,1,&respl,hwi_NOOp0,std_timeout);
  *pmask = buf[0];
  return(erno);
}
/*---------------------------------------------------------------------*
                        IO Put 
 *---------------------------------------------------------------------*/
err_Type hwi_IOPut(uchar mask, uchar op)
{
  uchar buf[3];
  sysobj_LType respl;
  
  respl = 0;
  buf[0] = hwi_OpIOPut;
  buf[1] = mask;
  buf[2] = op;
  return(sysobj_Call(buf,3,&respl,hwi_NOOp0,std_timeout));
}
/*---------------------------------------------------------------------*/
