/************************************************************************
                MBUS
                Generated implementation
                Method Switch
 ************************************************************************/
#include <err.h>
#include <drv.h>

#include <MBUS.H>
#include <mbusMA.h>

#define ModName		"MBUS_MA"
#define ModVers		"MBUS_MA:V2r24b"

#define verbop	0
/*----------------------------------------------------------------------*
                        Driver type
                        (Remote)
 *----------------------------------------------------------------------*/
typedef struct {
  // ***** PUBLIC PART 
  drv_MAType	Drv;		// Inherit Driver
  
  // ***** PRIVATE PART 
  
  
  mbus_MAType MA;
  
} ObjType;

#define This  ((ObjType *)This0)		// Specific type
#define ThisH ((drv_HType *)This0)		// Driver type
#define ThisR ((drv_RType *)This0)		// Remote type
/*----------------------------------------------------------------------*
                        Driver functions
 *----------------------------------------------------------------------*/
/*
#define RetDbg(na, ex) {err_Type erno;\
  if (verbop & 1) {err_Printf(1,"%s.%s ",ModName,(na));erno = ex;err_Printf(1," Err=%u\n",erno);}\
  else erno = ex;\
  return(erno);}
*/
//#define RetDbg(na, ex) return(((verbop & 1) ? err_Printf(1,"%s.%s\n",ModName,(na)),0:  ex))
#define RetDbg(na, ex) return(ex)

/************************************************************************
                        X METHODS
 ************************************************************************/

/*----------------------------------------------------------------------*
                        Method mbus_Config
 *----------------------------------------------------------------------*/
err_Type mbus_Config(
        mbus_Type * This0
        
        
        ,unsigned  Mode 
        ,ulong  Val 
        ,ulong  pVal[5] 
        )
{
  if (This0 && This->MA.Config) {
    RetDbg("Config",(*This->MA.Config)(This0
                              
                              ,Mode 
                              ,Val 
                              ,pVal 
                              ));
  } else return(drv__NoFunc);
}

/*----------------------------------------------------------------------*
                        Method mbus_DeviceCom
 *----------------------------------------------------------------------*/
err_Type mbus_DeviceCom(
        mbus_Type * This0,
        mbus_DeviceRef Device, 	// Device
        unsigned Mode, 		// Mode
        syst_TType Timeout,
        unsigned Len, 		// Length to transfert
        unsigned * pLen, 		// null or OUT: Transfered length
        uchar * Buf		// IN: Data to write, OUT: Read data
        )
{
  if (This0 && This->MA.DeviceCom) {
    RetDbg("DeviceCom",(*This->MA.DeviceCom)(This0
                              
                              ,Device 
                              ,Mode 
                              ,Timeout 
                              ,Len 
                              ,pLen 
                              ,Buf 
                              ));
  } else return(drv__NoFunc);
}
/*----------------------------------------------------------------------*
                        Method mbus_DeviceNew
 *----------------------------------------------------------------------*/
err_Type mbus_DeviceNew(
        mbus_Type * This0,
        mbus_DeviceRef Device,  // Device
        unsigned Mode, 		// Mode
        drv_Type * Drv
        )
{
  if (This0 && This->MA.DeviceNew) {
    RetDbg("DeviceNew",(*This->MA.DeviceNew)(This0
                              
                              ,Device 
                              ,Mode 
                              ,Drv 
                              ));
  } else return(drv__NoFunc);
}

/*----------------------------------------------------------------------*
                        Method mbus_DeviceDel
 *----------------------------------------------------------------------*/
err_Type mbus_DeviceDel(
        mbus_Type * This0,
        mbus_DeviceRef Device,  // Device
        unsigned Mode, 		// Mode
        drv_Type ** pDrv	// null or OUT
        )
{
  if (This0 && This->MA.DeviceDel) {
    RetDbg("DeviceDel",(*This->MA.DeviceDel)(This0
                              
                              ,Device 
                              ,Mode 
                              ,pDrv 
                              ));
  } else return(drv__NoFunc);
}

/*----------------------------------------------------------------------*/
