/**********************************************************************
                        Object DownLoader
                        for MLOS
 ***********************************************************************
 06/04/2005 - Marc LEGOUX C6r19a: Add objdl_FileRead
 18/03/2004 - Marc LEGOUX C6r15b: Add a mode to reduce block max size (WindowsXP==shit)
 06/02/2004 - Marc LEGOUX C6r14 : Add objdl_Timeout
 14/12/2003 - Marc LEGOUX C6r12 : Add objdl_FileLoadModeExec
 04/03/1997 - Marc LEGOUX V3r00 : NT version
 ***********************************************************************/
#ifndef objdl_h
#define objdl_h

#include <sysobj.h>
#include <sysx.h>

/*--------------------------ERRORS-----------------------------------*/
extern
err_Type objdl__err;
#define aia__read	objdl__err+1
#define aia__drve_full	objdl__err+2
#define aia__adrv_full	objdl__err+3

#define objdl__Magic    objdl__err+4 /* Wrong Magic word */
#define objdl__Length   objdl__err+5 /* Wrong file length */
#define objdl__Target   objdl__err+6 /* Wrong target */
#define objdl__LoadMode objdl__err+7 /* Wrong LoadMode param */
#define objdl__File     objdl__err+8 /* Wrong File */
#define objdl__NeedName objdl__err+9 // Package name is mandatory
#define objdl__Addr	objdl__err+10 // Wrong download addr

/*-------------------------------------------------------------------*
                        LOAD file
 Install objects that are defined in the file
 *-------------------------------------------------------------------*/
// LOAD MODE = Load Command + Load Flags
// LOAD Command (0..7)
#define objdl_FileLoadModeStart		0	// Uninstall + Install [+ Start]
#define objdl_FileLoadModeEnd		1	// End [+ Uninstall]
#define objdl_FileLoadModeWrite		2	// Only Write file at load addr
#define objdl_FileLoadModeExec		3	// Start if already installed
#define objdl_FileLoadModeMask		0x07	// Command mask

// LOAD Flags (ORed)
#define objdl_FileLoadModeSBlock	0x08	// Small data blocks for XP

#define objdl_FileLoadModeShift		4	// Shift DRV modes
#define objdl_FileLoadModeNoStart	0x40	// drv_NewModeNoStart<<4
#define objdl_FileLoadModeNoDel		0x40	// drv_NewModeNoUndef<<4
#define objdl_FileLoadModeFlash		0x100	// drv_NewModeResident<<4

extern
err_Type objdl_FileLoadX(
        char *fname, 		// File path 
        unsigned LoadMode,	// LOADMode
        sysobj_NodeType	node,	// 0 or Target Node 
        uchar * Params,		// 0 or params
        unsigned ParamLen,	// Param lenght
        uchar * Name		// 0 or Unique name
        );
/*-------------------------------------------------------------------*
                                LOAD file
 Install (uninstall) objects that are defined in the file
 Obsolete function
 *-------------------------------------------------------------------*/
extern
err_Type objdl_FileLoad(
        char *fname, 		/* File path */
        unsigned unload,	/* 0: install, 1: uninstall */
        sysobj_NodeType	node	/* 0 or Target Node */
        );
/*-------------------------------------------------------------------*
                        READ file
 Read data from memory to the file
 *-------------------------------------------------------------------*/
extern
err_Type objdl_FileRead(
        char *fname,  		// File path 
        unsigned Mode,
        ulong Addr,		// Addr in memory
        ulong Size,		// Size in memory
        sysobj_NodeType	Node	// 0 or Target Node 
        );
/*-------------------------------------------------------------------*
                                WRITE file
 Write only the data from file to memory
 The suffix gives the file type
 WARNING: the address offset shift the target position of the loaded data
 inside the memory, but not the addresses inside the data (no relocation). 
 A program must be loaded at offset 0 (or moved afterwards) before being 
 executed. 
 *-------------------------------------------------------------------*/
extern
err_Type objdl_FileWrite(
        char *fname,  		/* File path */
        unsigned addr,		/* 0 or Address offset */
        sysobj_NodeType	node	/* 0 or Target Node */
        );
/*-------------------------------------------------------------------*
                        	GET file info
 *-------------------------------------------------------------------*/
typedef
  struct {
    char	TypeName[32+1];
    
    ulong	HdAddr;		// Header address
    ulong	HdLen;		// Header length (0 if no header)
    ulong	SizeD;		// Size to download
    
    // Header data for a package
    ulong sp;
    ulong Start;
    ulong Magic;
    ulong Addr;
    ulong Size;
    ulong AddrLoad;
    ulong End;
    ulong AddrStatus;
    ulong Mode;
    ulong RunAddr;
    ulong RunSize;
    ulong HeapStart;
    ulong HeapSize;
    char  Name[16+1];
    char  Vers[32+1];
    
  } objdl_FileInfoType;

extern
err_Type objdl_FileInfo(
        char *fname,  			// File path 
        objdl_FileInfoType * pInfo	// (OUT)
        );
/*----------------------------------------------------------------------*
                        Load file into flash
 File must be loadable to 0xF00000 + Offs
 *----------------------------------------------------------------------*/
#define objdl_FlashLoadModePTMask	0x0F	/* prog type */
#define objdl_FlashLoadModeAppli	0	/* appli */
#define objdl_FlashLoadModeSyst		1	/* system */
#define objdl_FlashLoadModeSystBak	3	/* system backup */
#define objdl_FlashLoadModeBoot		2	/* boot */

extern
err_Type objdl_FileLoadFlash(
        char * fname,			/* File path */
        int LoadMode,		        /* 0:install, 1:uninstall, 3:1+write */
        sysobj_NodeType	Node,		/* 0 or Target Node */
        unsigned Mode,			/* Load Mode */
        unsigned SectorNum,		/* 0 or First sector number */
        unsigned Offs			/* 0 or Load offset */
        );
/*----------------------------------------------------------------------*
                        SYSOBJ Timeout
 *----------------------------------------------------------------------*/
#define objdl_TimeoutModeSet	1	// Else get
extern
err_Type objdl_Timeout(
        sysobj_TType * pTimeout,	// IN/OUT : According to mode
        unsigned Mode
        );
/*----------------------------------------------------------------------*
                        Start
 *----------------------------------------------------------------------*/
extern
err_Type objdl_Start(void * Cfg);
/*----------------------------------------------------------------------*
                        End
 *----------------------------------------------------------------------*/
extern
err_Type objdl_End(void * Cfg);
/*-------------------------------------------------------------------*/
#endif
