/***********************************************************************
                        UTIL
                Usefull declarations
 ***********************************************************************/
#include <util.h>

/************************************************************************
                        CONVERSIONS
 ************************************************************************/
/*----------------------------------------------------------------------*
                        LENDIAN to BENDIAN
 *----------------------------------------------------------------------*/
void LEToBELong(
        ulong * p	// IN: LE, OUT: BE
        )
{
  ulong u, v;
  
  if ((v = *p)==0) return;
  u   = v;
  u <<= 8;
  u  += (uchar)(v >> 8);
  u <<= 8;
  u  += (uchar)(v >> 16);
  u <<= 8;
  u  += (uchar)(v >> 24);
  *p = u;
}
/*-------------------------------------------------------------------*/
void LEToBEShort(
        ushort * p	// IN: LE, OUT: BE
        )
{
  unsigned u, v;
  
  if ((v = (unsigned)*p)==0) return;
  u   = v;
  u <<= 8;
  u  += (uchar)(v >> 8);
  *p = (ushort)u;
}
/*-------------------------------------------------------------------*/
err_Type LEToBESizeN(
        void * p,	// IN: LE, OUT: BE
        unsigned N,	// Number of items
        unsigned Size	// Item size
        )
{
  ulong u, v;
  
  switch (Size) {
    case 0 :
    case 1 :
      return(0);
    case 2 :
      for (;N; N--, ((ushort *)p)++) {
        if ((v = *((ulong *)p))==0) continue;
        u   = v;
        u <<= 8;
        u  += (uchar)(v >> 8);
        *((ushort *)p) = (ushort)u;
      } /* for */
      break;
    case 4 : {
      for (;N; N--, ((ulong *)p)++) {
        if ((v = *((ulong *)p))==0) continue;
        u   = v;
        u <<= 8;
        u  += (uchar)(v >> 8);
        u <<= 8;
        u  += (uchar)(v >> 16);
        u <<= 8;
        u  += (uchar)(v >> 24);
        *((ulong *)p) = u;
      }
      break;
    default :
      return(3);
    }
  }
  return(0);
}
#if util_ConvWith
/*-------------------------------------------------------------------*
                Convertion string -> string de N chars (terminee par 0)
 Retourne le pointeur modifie
 *-------------------------------------------------------------------*/
err_Type conv_str_str(
        char ** pstr, 	/* (IN/OUT) */
        char * pst, 	/* (OUT) : string ended with 0 */
        char nb)
{  
  for (; nb; nb--) {
    *pst++ = *(*pstr)++;
  }
  *pst = '\0';
  return(0);
}
/*-------------------------------------------------------------------*
        Convertion chaine de nmax chars decimaux -> long
 *-------------------------------------------------------------------*/
err_Type conv_str_ulong(
	char *st, 		/* String */
	ulong *pval,		/* (OUT) : decimal value */
	char nmax) 		/* Nb char */
{  
  err_Type erno;
  ulong tot;

  tot = 0L;
  erno = 0;
  for(; nmax > 0; nmax--) {
    if ((*st <= '9') && (*st >= '0')) {       
      tot = tot * 10 + (*st++ - '0');
    } else {
      erno = 1;
      break;
    }
  } /* for */
  *pval = tot;
  return (erno);
}
/*-------------------------------------------------------------------*
        Convertion chaine de nmax bytes -> long
 *-------------------------------------------------------------------*/
err_Type conv_array_ulong(
        byte ** pp, 		/* array */
        ulong *pval,		/* (OUT) : decimal value */
        char nmax) 		/* Nb char */
{  
  ulong tot;

  tot = 0L;
  for(; nmax > 0; nmax--) tot = (tot<<8) + *(*pp)++;
  *pval = tot;
  return (0);
}
/*-------------------------------------------------------------------*
                Convertion entier -> string de N chars decimaux
 Retourne le pointeur modifie
 *-------------------------------------------------------------------*/
char * conv_ulong_str(
	ulong val, 
	char * str, 
	char nb)
{  
  char i;
  
  str += nb-1;
  for (i=0; i<nb; i++) {
    *str-- = (char)(val % 10) + '0';
    val /= 10L;
  }
  str += nb+1;
  return (str);
}
/*-------------------------------------------------------------------*
        Convertion chaine de nmax chars decimaux -> entier
 *-------------------------------------------------------------------*/
err_Type conv_str_ushort(
	char *str, 	/* String */
	ushort *pval,	/* (OUT) : decimal value */
	char nmax) 	/* Nb char */
{  
  err_Type erno;
  ushort tot;

  tot = 0;
  erno = 0;
  for(; nmax > 0; nmax--) {
    if ((*str <= '9') && (*str >= '0')) {       
      tot = tot * 10 + (*str++ - '0');
    } else {
      erno = 1;
      break;
    }
  } /* for */
  *pval = tot;
  return (erno);
}
/*-------------------------------------------------------------------*
        Convertion chaine de nmax bytes -> ushort
 *-------------------------------------------------------------------*/
err_Type conv_array_ushort(
        byte ** pp, 		/* (IN/OUT) : array */
        ushort *pval,		/* (OUT) : decimal value */
        char nmax) 		/* Nb char */
{  
  ushort tot;

  tot = 0L;
  for(; nmax > 0; nmax--) tot = (tot<<8) + *(*pp)++;
  *pval = tot;
  return (0);
}
/*-------------------------------------------------------------------*
                Convertion entier -> string de N chars decimaux
 Retourne le pointeur modifie
 *-------------------------------------------------------------------*/
char * conv_ushort_str(
	ushort val, 
	char * str, 
	char nb)
{  
  ushort dix_puiss;
  char val_tmp;
  char i;
  
  dix_puiss = 10000;
  for (i=5; i>0; i--) {
    val_tmp = val / dix_puiss;
    if (i <= nb) *str++ = val_tmp + '0';
    val %= dix_puiss;
    dix_puiss /= 10;
  }
  return (str);
}
/*-------------------------------------------------------------------*
                Convertion byte -> string de chars decimaux (minimum 2)
 Retourne le pointeur modifie
 *-------------------------------------------------------------------*/
char * conv_byte_str(
	byte val, 
        char * str, 
        char nb)
{  
  byte dix_puiss;
  byte val_tmp, i;
  
  dix_puiss = 100;
  for (i=3; i>0; i--) {
    val_tmp = val / dix_puiss;
    if (i <= nb) *str++ = val_tmp + '0';
    val %= dix_puiss;
    dix_puiss /= 10;
  }
  return (str);
}
#endif
