/***********************************************************************
                                 CONFIG
                          Configuration et Portage
 ***********************************************************************
 Copyright (c) SMARTWARE, 1999 All Rights Reserved.
 ***********************************************************************
 15/11/2002 - Marc LEGOUX - USER1R09 : For appli on Coldfire
 06/02/2002 - Marc LEGOUX - CF1R07 : For Coldfire
 20/02/2000 - Marc LEGOUX - v1r09 : Add INI files
 09/07/1999 - Marc LEGOUX - c6r01 : Update from own module
 ***********************************************************************
 Chaque symbole de la zone CONFIGURATION COURANTE doit etre 
 definit avec les valeurs decrites dans CONFIGURATIONS.
 
 PORTAGE :
   Ne jamais emputer un source pour le porter : Rajouter plutot dans
   la configuration un symbole identifiant la cible du portage et
   permettant de compiler conditionnellement le code a modifier. 
 
 ***********************************************************************/
#ifndef config_h
#define config_h
/*----------------------------CONFIGURATIONS---------------------------*/
/****** Proprietes de machines (composables par |) */
/* Byte ordering (little-endian: meme adresse pour un mot et son octet 0) */
#define LENDIAN	0	/* little-endian: VAX11/780, 80286, NS32000*/
#define BENDIAN	1	/* big-endian: IBM370, MC68000 */
#define VIRTUAL_MEM 2   /* avec memoire virtuelle */
 
/* Size of (data) registers in bits: 8, 16, 32, 48, 64 */
/* That gives the size of int of the compiler */
#define config_REGSIZE 32	/* default */

/****** Types de systeme */
#define SYSMASK	0xFFF0	/* 4 lower bits for sub-system */

#define UNIX	0x10
#define BSD	0x11	/* UNIX + bit 0 */
#define SYS5	0x12	/* UNIX + bit 1 */
#define SUN     0x15	/* UNIX-BSD + bit 2 */

#define MDOS	0x20

#define VMS	0x30

#define WINMASK	0x40
#define WIN311	0x41

#define WIN32M	0x48	/* bit 4 == 95 || NT */
#define WIN95	0x49
#define WINNT	0x4A

#define MLOS	0x50
#define MLOS8	0x51
#define MLOS32	0x52
 
/****** Types d'ecran */
#define SCREEN_CONSO	1
#define SCREEN_WIN	2

/****** Types de compilateurs */
#define MSC	1	/* Microsotf-C */
#define IAR	2	/* C IAR 8051 */
#define C51	3	/* C KYLE 8051 */
#define DIAB	4	/* C DIAB data */

/****** Proprietes de compilateurs (composables par |) */
#define KERNIGHAN	0	/* Kernighan et Richie 78 */
#define STRUCTVAL	1	/* Connait les valeurs de structures */
				/* ->assignement et passage en parame`tres*/
 
#define XOPEN		STRUCTVAL
/****** Proprietes des librairies (composables par |) */
#define TERMCAP		1	/* (bit 0) termcap est disponible */
#define EXTERM		2	/* (bit 1) terminal externe (!interne)*/
 
/************************** CONFIGURATION COURANTE **********************/
/* Max des entiers signes */
#define config_maxint 0x7fffffff

/* Max des entiers non signes */
#define config_maxuint 0x0ffffffff
 
/* Machine courante (OU des proprietes ou 0) */
#define config_MACHINE (BENDIAN)
 
#define config_REGSIZE 32

/* Systeme courant (Type du systeme) */
#define config_SYSTEM	MLOS32
 
/* Compilateur courant */
#define config_COMPILER	DIAB

/* Ecran courant (CONSO if not defined)*/
/* #define config_SCREEN	SCREEN_WIN */

/* Proprietes Compilateur courant (OU des proprietes ou 0) */
#define config_COMPILPROP STRUCTVAL

/* Librairies courantes (OU des proprietes ou 0) */
#define config_LIB 1		// Inside LIB for appli
 
/* System and Hardware config files */
#define config_SysFName	(backup_Mode & backup_ModeSysBackup ? backup_FileSName : "SYSTEM.INI")
#define config_HwiFName	(backup_Mode & backup_ModeSysBackup ? backup_FileHName : "HWI.INI")
/*--------------------------------#IF-----------------------------------*/
/* Expressions de test pour #if ... */ 
/* Operating System */
#define config_UNIX	((config_SYSTEM & SYSMASK) == UNIX)
#define config_BSD	((config_SYSTEM & BSD) == BSD)
#define config_SYS5	(config_SYSTEM == SYS5)
#define config_SUN      (config_SYSTEM == SUN)
#define config_VMS	(config_SYSTEM == VMS)
#define config_MSDOS	((config_SYSTEM & SYSMASK) == MDOS)
#define config_WIN      ((config_SYSTEM & SYSMASK) == WINMASK)
#define config_WIN32    ((config_SYSTEM & WIN32M) == WIN32M)
#define config_WIN311   (config_SYSTEM == WIN311)
#define config_WIN95    (config_SYSTEM == WIN95)
#define config_WINNT    (config_SYSTEM == WINNT)
#define config_MLOS     ((config_SYSTEM & SYSMASK) == MLOS)
#define config_MLOS8    ((config_SYSTEM & MLOS8) == MLOS8)
#define config_MLOS32   ((config_SYSTEM & MLOS32) == MLOS32)
 
/* Multitasking */
#define config_MULTITASK     (config_UNIX || config_WIN32 || config_MLOS)
#define config_MONOTASK      (!config_MULTITASK)

/* Screen */
#ifdef config_SCREEN
#define config_CONSO	(config_SCREEN == SCREEN_CONSO)
#endif

/* Compiler */
#define config_MSC	(config_COMPILER == MSC)
#define config_IAR	(config_COMPILER == IAR)
#define config_C51	(config_COMPILER == C51)

#define config_STRUVAL	(config_COMPILPROP & STRUCTVAL)
#define config_XOPEN	(config_COMPILPROP & XOPEN)
 
#define config_LENDIAN  (!(config_MACHINE & BENDIAN))
#define config_BENDIAN  (config_MACHINE & BENDIAN)
#define config_VIRTUAL_MEM  (config_MACHINE & VIRTUAL_MEM)

#define config_TERMCAP	(config_LIB & TERMCAP)
#define config_EXTERMCAP (config_LIB & EXTERM)
/*------------------------------FUNCTIONS------------------------------*/
#endif
