/***********************************************************************
                        Heap in MEMORY
 ***********************************************************************
 25/12/2004 : Marc LEGOUX C6r18 : Restore the HeapAdjust modification of C6R08
 18/12/2003 : Marc LEGOUX C6r13 : Add _HeapReAlloc
 16/12/2003 : Marc LEGOUX C6r12 : Add _HeapBlkInfo
 06/03/2001 : Marc LEGOUX C6r06 : Add fixed addr alignment
 27/03/2000 : Marc LEGOUX C6r04 : Creation from own module
 ***********************************************************************/
#ifndef memhp_h
#define memhp_h

#include <err.h>
#include <syst.h>

extern err_Type mem__err;
#define mem__HeapErr		mem__err
#define mem__HeapNoMore		(mem__HeapErr + 1)
#define mem__HeapNotFound	(mem__HeapErr + 3)
#define mem__HeapWrongRef	(mem__HeapErr + 9)

#define mem__HeapCorrupt	(mem__HeapErr + 30)	// to +45


/* Heap */
#define mem_HeapType void

/*---------------------------------------------------------------------*
                        Alloc a block with alignment
 WARNING: Id fixed addr alignment, the returned addr may be < the requested
 addr. 
 *---------------------------------------------------------------------*/
#define mem_HeapAlignFixed	0xFF

extern
err_Type mem_HeapAllocA(
        mem_HeapType * hp,	/* Heap */
        void **p, 	/* (IN): If aligned on fixed address, (OUT) : Allocated block */
        unsigned size,	/* Block size */
        unsigned align	/* Alignment: 0=byte, 1=short, 2=long, ..., fixed addr*/
        );
/*---------------------------------------------------------------------*
                        Free a block
 *---------------------------------------------------------------------*/
extern
err_Type mem_HeapFree(
        mem_HeapType * hp,	/* Heap */
        void *p, 	/* Block to free */
        unsigned size	/* 0 or block size */
        );
/*----------------------------------------------------------------------*
                        Reallocate a block
 *----------------------------------------------------------------------*/
extern
err_Type mem_HeapReAlloc(
        mem_HeapType * hp,
        void *p, 
        unsigned size, 		// New size
        unsigned mode		// 0
        );
/*----------------------------------------------------------------------*
                        Info on a block
 *----------------------------------------------------------------------*/
// Same as syst_MemBlkInfo
typedef
  struct {
    unsigned	State;		// 0: Undef, 1:Free, 2:Alloc
    ulong	Addr;
    ulong	Size;
    ulong	RFU[5];
  } mem_HeapBlkInfoType;
extern
err_Type mem_HeapBlkInfo(
        mem_HeapType * hp0,
        void *p, 
        mem_HeapBlkInfoType * pInfo	// OUT
        );
/*---------------------------------------------------------------------*
                        Init a Ram Heap
 *---------------------------------------------------------------------*/
extern
err_Type mem_HeapInit(
        mem_HeapType * hp,	/* Heap */
        unsigned Length,
        unsigned Mode		// same mode as _HeapNew()
        );
/*---------------------------------------------------------------------*
                        New
 *---------------------------------------------------------------------*/
#define mem_HeapModeFlash	0x0001	// Non volatile memory
#define mem_HeapModeAllocLow	0x0100	// Alloc lowest block

extern
err_Type mem_HeapNew(
        mem_HeapType ** php,	/* (IN/OUT) */
        unsigned Length, 
        unsigned Mode,
        unsigned Addr		/* Flash mode only */
        );
/*----------------------------------------------------------------------*
                        Trunc
 The last free block is removed
 *----------------------------------------------------------------------*/
extern
err_Type mem_HeapTrunc(
        mem_HeapType * hp0,
        unsigned Mode,
        unsigned *pLen		// OUT: New total length
        );
/*---------------------------------------------------------------------*
                        Adjust
 *---------------------------------------------------------------------*/
extern
err_Type mem_HeapAdjust(
        mem_HeapType * hp,	/* Heap */
        unsigned offs,		/* offset */
        unsigned mode		// Adjust L/B endian if !=0
        );
/*---------------------------------------------------------------------*
                        Print
 *---------------------------------------------------------------------*/
extern
err_Type mem_HeapPrint(
        mem_HeapType * hp,	/* Heap */
        int ModePrint		/* print mode */
        );
/*---------------------------------------------------------------------*
                        Check
 Return mem__HeapCorrupt
 *---------------------------------------------------------------------*/
extern
err_Type mem_HeapCheck(
        mem_HeapType * hp,	// Heap 
        int ModePrint,		// print mode 
        syst_MemInfoType * pI	// 0 or OUT : mem infos
        );
/*-----------------------------------------------------------------------*
                        Start
 *-----------------------------------------------------------------------*/
extern
err_Type mem_HeapStart(
        void * Cfg
        );
/*-----------------------------------------------------------------------*
                        End
 *-----------------------------------------------------------------------*/
extern
err_Type mem_HeapEnd(
        void * Cfg
        );
/*---------------------------------------------------------------------*/

#endif
