/***********************************************************************
                        UTIL
                Usefull declarations
 ***********************************************************************
 01/10/2003 - Marc LEGOUX - v6r11 : Add BEToSizeN() BEFromSizeN()
 01/05/1999 - Marc LEGOUX - c4r01 : Update from own module
 ***********************************************************************/
#ifndef util_h
#define util_h

#include <config.h>
#include <err.h>

/* Convert functions */
#define asc_to_hex(k) (((k) <= '9' ? (k) : (k) - 'A'+10) & 0x0F)
#define hex_to_asc(k) ((k) <= 9 ? (k)+'0' : (k) - 10 +'A')
#define bcd_to_bin(k) ((((k) >> 4) & 0x0F)*10 + ((k) & 0x0F))
#define bcd_to_pasc(k,pto) (*(pto)=(((k) >> 4) & 0x0F)+'0',*((pto)+1)=((k) & 0x0F)+'0')
#define bcd_to_ascst(k,st) (*(st)++=(((k) >> 4) & 0x0F)+'0',*(st)++=((k) & 0x0F)+'0')
#define ascst_to_bcd(st,k) ((k)=((*(st)++ -'0')<<4), (k)|=((*(st)++ -'0')& 0x0f))
#define ascst_is_bcd(st) (*(st)>='0' && *(st)<='9' && *(st+1)>='0' && *(st+1)<='9')

/* digits */
#define highd(a)	(((a)>>4) & 0x0f)
#define  lowd(a)	((a) & 0x0f)
#define  hlasc(h,l)	((((h)-'0')<<4) | (((l)-'0') & 0x0f))
#define  hl(h,l)	(((h)<<4) | ((l) & 0x0f))

/* bytes */
#define lowb(x)   ((uchar)(0x0ff & (x)))
#define highb(x)  ((uchar)(0x0ff & ((x)>>8)))
#define high2b(x) ((uchar)(0x0ff & ((x)>>16)))
#define high3b(x) ((uchar)(0x0ff & ((x)>>24)))

/* 1 byte */
#ifndef byte
typedef unsigned char byte;
#endif

/* 2 bytes */
#define set_highlow(a,h,l) (((a)=(h)),((a)<<=8),((a)+=(l)))

#ifndef highlow
#define highlow(h,l)   ((((ushort)(h))<<8)+(ushort)(l))
#endif
#define lowdb(x)   ((ushort)(0x0ffff & (x)))
#define highdb(x)  ((ushort)(0x0ffff & ((x)>>16)))

/* long */
#define hhighlow(hh,h,l) (((ulong)(hh)<<16)+((ulong)(h)<<8)+(ulong)(l))
#define hhhighlow(hhh,hh,h,l) (((ulong)(hhh)<<24)+((ulong)(hh)<<16)+((ulong)(h)<<8)+(ulong)(l))

#define mini(a,b) ((a) < (b) ? (a) : (b))
#define maxi(a,b) ((a) < (b) ? (b) : (a))

/************************************************************************
			CONVERSIONS
 ************************************************************************/
/*----------------------------------------------------------------------*
			LENDIAN <-> BENDIAN
 *----------------------------------------------------------------------*/
extern
void LEToBELong(
        ulong * p	// IN: LE, OUT: BE
        );
extern
void LEToBEShort(
        ushort * p	// IN: LE, OUT: BE
        );
extern
err_Type LEToBESizeN(
        void * p,	// IN: LE, OUT: BE
        unsigned N,	// Number of items
        unsigned Size	// Item size
        );

#define BEToLELong(p)  LEToBELong(p)
#define BEToLEShort(p) LEToBEShort(p)

// Switch BE <-> LE
#define BELERef(p)    LEToBELong((ulong *)(p))
#define BELELong(p)   LEToBELong((ulong *)(p))
#define BELEShort(p)  LEToBEShort((ushort *)(p))
/*----------------------------------------------------------------------*
		Generic conversions BE <-> current machine
 *----------------------------------------------------------------------*/
#if config_LENDIAN
#define BEToLong(p)		LEToBELong((ulong *)(p))
#define BEToShort(p)		LEToBEShort((ushort *)(p))
#define BEToRef(p)		LEToBELong((ulong *)(p))
#define BEToSizeN(p,n,s)	LEToBESizeN((void *)(p),(n),(s))
#define BEToLongN(p,n)		LEToBESizeN((void *)(p),(n),4)

#define BEFromLong(p)		LEToBELong((ulong *)(p))
#define BEFromShort(p)		LEToBEShort((ushort *)(p))
#define BEFromRef(p) 		LEToBELong((ulong *)(p))
#define BEFromSizeN(p,n,s)	LEToBESizeN((void *)(p),(n),(s))
#define BEFromLongN(p,n)	LEToBESizeN((void *)(p),(n),4)

#define LEToLong(p)    
#define LEToShort(p)   
#define LEToRef(p)     
#define LEToSizeN(p,n,s)
#define LEToLongN(p,n)

#define LEFromLong(p)  
#define LEFromShort(p) 
#define LEFromRef(p)   
#define LEFromSizeN(p,n,s)
#define LEFromLongN(p,n)

#else

#define BEToLong(p)    
#define BEToShort(p)   
#define BEToRef(p)     
#define BEToSizeN(p,n,s)
#define BEToLongN(p,n)

#define BEFromLong(p)  
#define BEFromShort(p) 
#define BEFromRef(p)   
#define BEFromSizeN(p,n,s)
#define BEFromLongN(p,n)

#define LEToLong(p)		LEToBELong((ulong *)(p))
#define LEToShort(p)		LEToBEShort((ushort *)(p))
#define LEToRef(p)		LEToBELong((ulong *)(p))
#define LEToSizeN(p,n,s)	LEToBESizeN((void *)(p),(n),(s))
#define LEToLongN(p,n)		LEToBESizeN((void *)(p),(n),4)

#define LEFromLong(p)		LEToBELong((ulong *)(p))
#define LEFromShort(p)		LEToBEShort((ushort *)(p))
#define LEFromRef(p) 		LEToBELong((ulong *)(p))
#define LEFromSizeN(p,n,s)	LEToBESizeN((void *)(p),(n),(s))
#define LEFromLongN(p,n)	LEToBESizeN((void *)(p),(n),4)

#endif
/*-------------------------------------------------------------------*
                Convertion string -> string de N chars (terminee par 0)
 Retourne le pointeur modifie
 *-------------------------------------------------------------------*/
extern
err_Type conv_str_str(
        char ** pstr, 	/* (IN/OUT) */
        char * pst, 	/* (OUT) : string ended with 0 */
        char nb);
/*-------------------------------------------------------------------*
        Convertion chaine de nmax chars decimaux -> long
 *-------------------------------------------------------------------*/
extern
err_Type conv_str_ulong(
	char *st, 		/* String */
	ulong *pval,		/* (OUT) : decimal value */
	char nmax); 		/* Nb char */
/*-------------------------------------------------------------------*
        Convertion chaine de nmax bytes -> long
 *-------------------------------------------------------------------*/
extern
err_Type conv_array_ulong(
        uchar ** pp, 		/* (IN/OUT) : array */
        ulong *pval,		/* (OUT) : decimal value */
        char nmax); 		/* Nb char */
/*-------------------------------------------------------------------*
                Convertion entier -> string de N chars decimaux
 Retourne le pointeur modifie
 *-------------------------------------------------------------------*/
extern
char * conv_ulong_str(
	ulong val, 
	char * str, 		// OUT
	char nb);
/*-------------------------------------------------------------------*
        Convertion chaine de nmax chars decimaux -> entier
 *-------------------------------------------------------------------*/
extern
err_Type conv_str_ushort(
	char *str, 	/* String */
	ushort *pval,	/* (OUT) : decimal value */
	char nmax); 	/* Nb char */

/* Convertion chaine de nmax chars decimaux -> entier */
#define conv_str_short(nmax,pbuf,presp) conv_str_ushort(pbuf,presp,nmax)
/*-------------------------------------------------------------------*
        Convertion chaine de nmax bytes -> ushort
 *-------------------------------------------------------------------*/
extern
err_Type conv_array_ushort(
        uchar ** pp, 		/* (IN/OUT) : array */
        ushort *pval,		/* (OUT) : decimal value */
        char nmax); 		/* Nb char */
/*-------------------------------------------------------------------*
                Convertion entier -> string de N chars decimaux
 Retourne le pointeur modifie
 *-------------------------------------------------------------------*/
extern
char * conv_ushort_str(
	ushort val, 
	char * str, 		// OUT
	char nb);

/* Convertion entier -> string de 5 chars decimaux */
#define conv_short_5char(v,s) conv_ushort_str((v),(s),5)
/*-------------------------------------------------------------------*
                Convertion byte -> string de chars decimaux (minimum 2)
 Retourne le pointeur modifie
 *-------------------------------------------------------------------*/
extern
char * conv_byte_str(
	uchar val, 
	char * str, 
	char nb);

#endif
