/*
 * Copyright 2022 - 2023, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * MP300 specific HAL-Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#include <ph_Status.h>
#include <phbalReg.h>
#include <ph_RefDefs.h>

#ifdef NXPBUILD__PHHAL_HW_CONTACT_TRANSPARENT

#include "phhalHwContact_Transparent.h"
#include "phhalHwContact_Transparent_Int.h"
#include <phTools.h>
#include <stdio.h>              /* PRQA S 5124 */
#include <Windows.h>

phStatus_t phhalHwContact_Transparent_Int_SetBitrateFromFD(
                                                           phhalHwContact_Transparent_DataParams_t * pDataParams,
                                                           uint8_t bfdValue
                                                           )
{
    phStatus_t statusTmp;
    uint8_t fValue = 0;
    uint8_t dValue = 0;

    fValue = (bfdValue >> 4) & 0x0F;
    dValue = bfdValue & 0x0F;

    PH_CHECK_SUCCESS_FCT(statusTmp, phbalReg_SetConfig(pDataParams->pBalDataParams, PHBAL_REG_SERIALWIN_CONFIG_FI, fValue));
    PH_CHECK_SUCCESS_FCT(statusTmp, phbalReg_SetConfig(pDataParams->pBalDataParams, PHBAL_REG_SERIALWIN_CONFIG_DI, dValue));

    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_HAL);
}

phStatus_t phhalHwContact_Transparent_Int_GetBitrateToFD(
                                                         phhalHwContact_Transparent_DataParams_t * pDataParams,
                                                         uint8_t * bfdValue
                                                         )
{
    phStatus_t statusTmp;
    uint16_t fValue;
    uint16_t dValue;

    PH_CHECK_SUCCESS_FCT(statusTmp, phbalReg_GetConfig(pDataParams->pBalDataParams, PHBAL_REG_SERIALWIN_CONFIG_FI, &fValue));
    PH_CHECK_SUCCESS_FCT(statusTmp, phbalReg_GetConfig(pDataParams->pBalDataParams, PHBAL_REG_SERIALWIN_CONFIG_DI, &dValue));

    *bfdValue = (uint8_t)((fValue << 4) + dValue);

    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_HAL);
}

phStatus_t phhalHwContact_Transparent_Int_SetParityErrorSignal(
                                                               phhalHwContact_Transparent_DataParams_t * pDataParams,
                                                               uint32_t dwParityErrorSignal
                                                               )
{
    DCB dcb;

    /* Prepare CDB structure */
    SecureZeroMemory(&dcb, sizeof(DCB) );  /* PRQA S 3200 */
    GetCommState(((phbalReg_SerialWin_DataParams_t*)pDataParams->pBalDataParams)->pComHandle, &dcb );

    if((dwParityErrorSignal != PH_ON) && (dwParityErrorSignal != PH_OFF))
    {
        return PH_ADD_COMPCODE(PH_ERR_UNSUPPORTED_PARAMETER, PH_COMP_HAL);
    }

    dcb.fParity = dwParityErrorSignal;

    /* Apply the settings */
    if (SetCommState(((phbalReg_SerialWin_DataParams_t*)pDataParams->pBalDataParams)->pComHandle, &dcb) == FALSE)
    {
        DWORD err = GetLastError();
        if ( err != ERROR_INVALID_HANDLE )
        {
            return PH_ADD_COMPCODE(PH_ERR_INTERFACE_ERROR, PH_COMP_BAL);
        }
    }

     return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_BAL);
}

#endif /* NXPBUILD__PHHAL_HW_CONTACT_TRANSPARENT */
