/*
 * Copyright 2023, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Callback ISO14443-3A Component of Reader Library.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#include <ph_RefDefs.h>
#include <phpalI14443p3a.h>

#ifdef NXPBUILD__PHPAL_I14443P3A_CALLBACK

#include <phhalHw.h>
#include "phpalI14443p3a_Callback.h"

phStatus_t phpalI14443p3a_Callback_Init(
                                        phpalI14443p3a_Callback_DataParams_t * pDataParams,
                                        uint16_t wSizeOfDataParams,
                                        cbPalI14443p3a_RequestA pRequestACb,
                                        cbPalI14443p3a_RequestS pRequestSCb,
                                        cbPalI14443p3a_WakeUpA pWakeUpACb,
                                        cbPalI14443p3a_WakeUpS pWakeUpSCb,
                                        cbPalI14443p3a_HaltA pHaltACb,
                                        cbPalI14443p3a_Anticollision pAnticollisionCb,
                                        cbPalI14443p3a_Select pSelectCb,
                                        cbPalI14443p3a_ActivateCard pActivateCardCb,
                                        cbPalI14443p3a_Exchange pExchangeCb,
                                        cbPalI14443p3a_GetSerialNo pGetSerialNoCb,
                                        cbPalI14443p3a_GetConfig pGetConfigCb,
                                        cbPalI14443p3a_SetConfig pSetConfigCb,
                                        void * pCbContext
                                    )
{
    if (sizeof(phpalI14443p3a_Callback_DataParams_t) != wSizeOfDataParams)
    {
        return PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_PAL_ISO14443P3A);
    }
    PH_ASSERT_NULL (pDataParams);

    /* Initialize private data */
    pDataParams->wId            = PH_COMP_PAL_ISO14443P3A | PHPAL_I14443P3A_CALLBACK_ID;
    pDataParams->pRequestACb = pRequestACb;
    pDataParams->pRequestSCb = pRequestSCb;
    pDataParams->pWakeUpACb = pWakeUpACb;
    pDataParams->pWakeUpSCb = pWakeUpSCb;
    pDataParams->pHaltACb = pHaltACb;
    pDataParams->pAnticollisionCb = pAnticollisionCb;
    pDataParams->pSelectCb = pSelectCb;
    pDataParams->pActivateCardCb = pActivateCardCb;
    pDataParams->pExchangeCb = pExchangeCb;
    pDataParams->pGetSerialNoCb = pGetSerialNoCb;
    pDataParams->pGetConfigCb = pGetConfigCb;
    pDataParams->pSetConfigCb = pSetConfigCb;
    pDataParams->pCbContext = pCbContext;

    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_PAL_ISO14443P3A);
}

phStatus_t phpalI14443p3a_Callback_RequestA(
                                        phpalI14443p3a_Callback_DataParams_t * pDataParams,
                                        uint8_t * pAtqa
                                        )
{
    if (pDataParams->pRequestACb)
    {
        return (*pDataParams->pRequestACb)(pAtqa, pDataParams->pCbContext);
    }
    else
    {
        return PH_ADD_COMPCODE(PH_ERR_UNSUPPORTED_COMMAND, PH_COMP_PAL_ISO14443P3A);
    }
}

phStatus_t phpalI14443p3a_Callback_RequestS(
    phpalI14443p3a_Callback_DataParams_t * pDataParams,
    uint8_t * pAtqs
)
{
    if (pDataParams->pRequestSCb)
    {
        return (*pDataParams->pRequestSCb)(pAtqs, pDataParams->pCbContext);
    }
    else
    {
        return PH_ADD_COMPCODE(PH_ERR_UNSUPPORTED_COMMAND, PH_COMP_PAL_ISO14443P3A);
    }
}

phStatus_t phpalI14443p3a_Callback_WakeUpA(
                                       phpalI14443p3a_Callback_DataParams_t * pDataParams,
                                       uint8_t * pAtqa
                                       )
{
    if (pDataParams->pWakeUpACb)
    {
        return (*pDataParams->pWakeUpACb)(pAtqa, pDataParams->pCbContext);
    }
    else
    {
        return PH_ADD_COMPCODE(PH_ERR_UNSUPPORTED_COMMAND, PH_COMP_PAL_ISO14443P3A);
    }
}

phStatus_t phpalI14443p3a_Callback_WakeUpS(
    phpalI14443p3a_Callback_DataParams_t * pDataParams,
    uint8_t * pAtqs
)
{
    if (pDataParams->pWakeUpSCb)
    {
        return (*pDataParams->pWakeUpSCb)(pAtqs, pDataParams->pCbContext);
    }
    else
    {
        return PH_ADD_COMPCODE(PH_ERR_UNSUPPORTED_COMMAND, PH_COMP_PAL_ISO14443P3A);
    }
}

phStatus_t phpalI14443p3a_Callback_HaltA(
                                     phpalI14443p3a_Callback_DataParams_t * pDataParams
                                     )
{
    if (pDataParams->pHaltACb)
    {
        return (*pDataParams->pHaltACb)(pDataParams->pCbContext);
    }
    else
    {
        return PH_ADD_COMPCODE(PH_ERR_UNSUPPORTED_COMMAND, PH_COMP_PAL_ISO14443P3A);
    }
}

phStatus_t phpalI14443p3a_Callback_Anticollision(
                                             phpalI14443p3a_Callback_DataParams_t * pDataParams,
                                             uint8_t bCascadeLevel,
                                             uint8_t * pUidIn,
                                             uint8_t bNvbUidIn,
                                             uint8_t * pUidOut,
                                             uint8_t * pNvbUidOut
                                             )
{
    if (pDataParams->pAnticollisionCb)
    {
        return (*pDataParams->pAnticollisionCb)(bCascadeLevel, pUidIn, bNvbUidIn, pUidOut, pNvbUidOut, pDataParams->pCbContext);
    }
    else
    {
        return PH_ADD_COMPCODE(PH_ERR_UNSUPPORTED_COMMAND, PH_COMP_PAL_ISO14443P3A);
    }
}

phStatus_t phpalI14443p3a_Callback_Select(
                                      phpalI14443p3a_Callback_DataParams_t * pDataParams,
                                      uint8_t bCascadeLevel,
                                      uint8_t * pUidIn,
                                      uint8_t * pSak
                                      )
{
    if (pDataParams->pSelectCb)
    {
        return (*pDataParams->pSelectCb)(bCascadeLevel, pUidIn, pSak, pDataParams->pCbContext);
    }
    else
    {
        return PH_ADD_COMPCODE(PH_ERR_UNSUPPORTED_COMMAND, PH_COMP_PAL_ISO14443P3A);
    }
}

phStatus_t phpalI14443p3a_Callback_ActivateCard(
                                            phpalI14443p3a_Callback_DataParams_t * pDataParams,
                                            uint8_t * pUidIn,
                                            uint8_t bLenUidIn,
                                            uint8_t * pUidOut,
                                            uint8_t * pLenUidOut,
                                            uint8_t * pSak,
                                            uint8_t * pMoreCardsAvailable
                                            )
{
    if (pDataParams->pActivateCardCb)
    {
        return (*pDataParams->pActivateCardCb)(pUidIn, bLenUidIn, pUidOut, pLenUidOut, pSak, pMoreCardsAvailable, pDataParams->pCbContext);
    }
    else
    {
        return PH_ADD_COMPCODE(PH_ERR_UNSUPPORTED_COMMAND, PH_COMP_PAL_ISO14443P3A);
    }
}

phStatus_t phpalI14443p3a_Callback_Exchange(
                                        phpalI14443p3a_Callback_DataParams_t * pDataParams,
                                        uint16_t wOption,
                                        uint8_t * pTxBuffer,
                                        uint16_t wTxLength,
                                        uint8_t ** ppRxBuffer,
                                        uint16_t * pRxLength
                                        )
{
    if (pDataParams->pExchangeCb)
    {
        return (*pDataParams->pExchangeCb)(wOption, pTxBuffer, wTxLength, ppRxBuffer, pRxLength, pDataParams->pCbContext);
    }
    else
    {
        return PH_ADD_COMPCODE(PH_ERR_UNSUPPORTED_COMMAND, PH_COMP_PAL_ISO14443P3A);
    }
}

phStatus_t phpalI14443p3a_Callback_GetSerialNo(
                                           phpalI14443p3a_Callback_DataParams_t * pDataParams,
                                           uint8_t * pRxBuffer,
                                           uint8_t * pRxLength
                                           )
{
    if (pDataParams->pGetSerialNoCb)
    {
        return (*pDataParams->pGetSerialNoCb)(pRxBuffer, pRxLength, pDataParams->pCbContext);
    }
    else
    {
        return PH_ADD_COMPCODE(PH_ERR_UNSUPPORTED_COMMAND, PH_COMP_PAL_ISO14443P3A);
    }
}

phStatus_t phpalI14443p3a_Callback_GetConfig(
    phpalI14443p3a_Callback_DataParams_t * pDataParams,
    uint16_t wConfig,
    uint16_t * pValue
)
{
    if (pDataParams->pGetConfigCb)
    {
        return (*pDataParams->pGetConfigCb)(wConfig, pValue, pDataParams->pCbContext);
    }
    else
    {
        return PH_ADD_COMPCODE(PH_ERR_UNSUPPORTED_COMMAND, PH_COMP_PAL_ISO14443P3A);
    }
}

phStatus_t phpalI14443p3a_Callback_SetConfig(
    phpalI14443p3a_Callback_DataParams_t * pDataParams,
    uint16_t wConfig,
    uint16_t wValue
)
{
    if (pDataParams->pSetConfigCb)
    {
        return (*pDataParams->pSetConfigCb)(wConfig, wValue, pDataParams->pCbContext);
    }
    else
    {
        return PH_ADD_COMPCODE(PH_ERR_UNSUPPORTED_COMMAND, PH_COMP_PAL_ISO14443P3A);
    }
}

#endif /* NXPBUILD__PHPAL_I14443P3A_CALLBACK */
