/*
 * Copyright 2017, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Software ISO14443-4 Dummy Android Component of Basic Function Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHPALI14443P4_ANDROID_H
#define PHPALI14443P4_ANDROID_H

#include <ph_Status.h>
#include <phpalI14443p4.h>

phStatus_t phpalI14443p4_Android_SetProtocol(
                                        phpalI14443p4_Android_DataParams_t * pDataParams,
                                        uint8_t   bCidEnable,
                                        uint8_t   bCid,
                                        uint8_t   bNadEnable,
                                        uint8_t   bNad,
                                        uint8_t   bFwi,
                                        uint8_t   bFsdi,
                                        uint8_t   bFsci
                                        );

phStatus_t phpalI14443p4_Android_ResetProtocol(
                                        phpalI14443p4_Android_DataParams_t * pDataParams
                                        );

phStatus_t phpalI14443p4_Android_Deselect(
                                        phpalI14443p4_Android_DataParams_t * pDataParams
                                        );

phStatus_t phpalI14443p4_Android_PresCheck(
                                        phpalI14443p4_Android_DataParams_t * pDataParams
                                        );

phStatus_t phpalI14443p4_Android_Exchange(
                                        phpalI14443p4_Android_DataParams_t * pDataParams,
                                        uint16_t wOption,
                                        uint8_t * pTxBuffer,
                                        uint16_t wTxLength,
                                        uint8_t ** ppRxBuffer,
                                        uint16_t * pRxLength
                                        );

phStatus_t phpalI14443p4_Android_SetConfig(
                                        phpalI14443p4_Android_DataParams_t * pDataParams,
                                        uint16_t wConfig,
                                        uint16_t wValue
                                        );

phStatus_t phpalI14443p4_Android_GetConfig(
                                        phpalI14443p4_Android_DataParams_t * pDataParams,
                                        uint16_t wConfig,
                                        uint16_t * pValue
                                        );

#endif /* PHPALI14443P4_ANDROID_H */
