/*
 * Copyright 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * SAM (AV4 and future SAM's) ISO14443-4 Component of Basic Function Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7230 $
 * $Date: 2025-03-14 10:27:23 +0530 (Fri, 14 Mar 2025) $
 */

#ifndef PHPALI14443P4_SAM_X_H
#define PHPALI14443P4_SAM_X_H

#include <ph_Status.h>

#define I14443P4_SAM_X_FREE_CID                          0x01   /**< force CID to be freed in any case */
#define I14443P4_SAM_X_LFI_NO_DATA                       0x00   /**<  Last Frame Indicator: A00h if data field holds last frame to be sent to the PICC */
#define I14443P4_SAM_X_LFI_MORE_DATA                     0xAF   /**<  Last Frame Indicator: AFh if more data shall be sent to the PICC */
#define I14443P4_SAM_X_DATA_RESPONSE_MAX                 0xF8   /**<  Last Frame Indicator: AFh if more data shall be sent to the PICC */

phStatus_t phpalI14443p4_Sam_X_SetProtocol(phpalI14443p4_Sam_X_DataParams_t * pDataParams, uint8_t bCidEnable, uint8_t bCid,
    uint8_t bNadEnable, uint8_t bNad, uint8_t bFwi, uint8_t bFsdi, uint8_t bFsci);

phStatus_t phpalI14443p4_Sam_X_ResetProtocol(phpalI14443p4_Sam_X_DataParams_t * pDataParams);

phStatus_t phpalI14443p4_Sam_X_Deselect(phpalI14443p4_Sam_X_DataParams_t * pDataParams);

phStatus_t phpalI14443p4_Sam_X_PresCheck(phpalI14443p4_Sam_X_DataParams_t * pDataParams);

phStatus_t phpalI14443p4_Sam_X_Exchange(phpalI14443p4_Sam_X_DataParams_t * pDataParams, uint16_t wOption, uint8_t * pTxBuffer,
    uint16_t wTxLength, uint8_t ** ppResponse, uint16_t * pRespLen);

phStatus_t phpalI14443p4_Sam_X_SetConfig(phpalI14443p4_Sam_X_DataParams_t * pDataParams, uint16_t wConfig, uint16_t wValue);

phStatus_t phpalI14443p4_Sam_X_GetConfig(phpalI14443p4_Sam_X_DataParams_t * pDataParams, uint16_t wConfig, uint16_t * pValue);

#endif /* PHPALI14443P4_SAM_X_H */
