/*
 * Copyright 2023, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Callback ISO14443-4A Component of Reader Library.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#include <phpalI14443p4a.h>
#include <ph_RefDefs.h>
#include <phhalHw.h>

#ifdef NXPBUILD__PHPAL_I14443P4A_CALLBACK

#include "phpalI14443p4a_Callback.h"

phStatus_t phpalI14443p4a_Callback_Init(
                                    phpalI14443p4a_Callback_DataParams_t * pDataParams,
                                    uint16_t wSizeOfDataParams,
                                    cbPalI14443p4a_Rats pRatsCb,
                                    cbPalI14443p4a_Pps pPpsCb,
                                    cbPalI14443p4a_ActivateCard pActivateCardCb,
                                    cbPalI14443p4a_GetProtocolParams pGetProtocolParamsCb,
                                    void * pCbContext
                                    )
{
    if (sizeof(phpalI14443p4a_Callback_DataParams_t) != wSizeOfDataParams)
    {
        return PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_PAL_ISO14443P4A);
    }
    PH_ASSERT_NULL (pDataParams);

    /* Initialize data parameters */
    pDataParams->wId            = PH_COMP_PAL_ISO14443P4A | PHPAL_I14443P4A_CALLBACK_ID;
    pDataParams->pRatsCb = pRatsCb;
    pDataParams->pPpsCb = pPpsCb;
    pDataParams->pActivateCardCb = pActivateCardCb;
    pDataParams->pGetProtocolParamsCb = pGetProtocolParamsCb;
    pDataParams->pCbContext = pCbContext;

    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_PAL_ISO14443P4A);
}

phStatus_t phpalI14443p4a_Callback_Rats(
                                    phpalI14443p4a_Callback_DataParams_t * pDataParams,
                                    uint8_t bFsdi,
                                    uint8_t bCid,
                                    uint8_t * pAts
                                    )
{
    if (pDataParams->pRatsCb)
    {
        return (*pDataParams->pRatsCb)(bFsdi, bCid, pAts, pDataParams->pCbContext);
    }
    else
    {
        return PH_ADD_COMPCODE(PH_ERR_UNSUPPORTED_COMMAND, PH_COMP_PAL_ISO14443P4A);
    }
}

phStatus_t phpalI14443p4a_Callback_Pps(
                                   phpalI14443p4a_Callback_DataParams_t * pDataParams,
                                   uint8_t bDri,
                                   uint8_t bDsi
                                   )
{
    if (pDataParams->pPpsCb)
    {
        return (*pDataParams->pPpsCb)(bDri, bDsi, pDataParams->pCbContext);
    }
    else
    {
        return PH_ADD_COMPCODE(PH_ERR_UNSUPPORTED_COMMAND, PH_COMP_PAL_ISO14443P4A);
    }
}

phStatus_t phpalI14443p4a_Callback_ActivateCard(
                                            phpalI14443p4a_Callback_DataParams_t * pDataParams,
                                            uint8_t bFsdi,
                                            uint8_t bCid,
                                            uint8_t bDri,
                                            uint8_t bDsi,
                                            uint8_t * pAts
                                            )
{
    if (pDataParams->pActivateCardCb)
    {
        return (*pDataParams->pActivateCardCb)(bFsdi, bCid, bDri, bDsi, pAts, pDataParams->pCbContext);
    }
    else
    {
        return PH_ADD_COMPCODE(PH_ERR_UNSUPPORTED_COMMAND, PH_COMP_PAL_ISO14443P4A);
    }
}

phStatus_t phpalI14443p4a_Callback_GetProtocolParams(
                                                 phpalI14443p4a_Callback_DataParams_t * pDataParams,
                                                 uint8_t * pCidEnabled,
                                                 uint8_t * pCid,
                                                 uint8_t * pNadSupported,
                                                 uint8_t * pFwi,
                                                 uint8_t * pFsdi,
                                                 uint8_t * pFsci
                                                 )
{
    if (pDataParams->pGetProtocolParamsCb)
    {
        return (*pDataParams->pGetProtocolParamsCb)(pCidEnabled, pCid, pNadSupported, pFwi, pFsdi, pFsci, pDataParams->pCbContext);
    }
    else
    {
        return PH_ADD_COMPCODE(PH_ERR_UNSUPPORTED_COMMAND, PH_COMP_PAL_ISO14443P4A);
    }
}

#endif /* NXPBUILD__PHPAL_I14443P4A_RD710 */

