/*
 * Copyright 2022 - 2023, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Internal definitions for ISO7816 Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHPALI7816P4_SW_INT_H
#define PHPALI7816P4_SW_INT_H

#include <phpalI7816p4.h>
#include <ph_Status.h>
#include <ph_TypeDefs.h>

/*HEADER OFFSETS*/
#define PHPAL_I7816P4_SW_HEADER_NAD_OFFSET              0
#define PHPAL_I7816P4_SW_HEADER_PCB_OFFSET              1
#define PHPAL_I7816P4_SW_HEADER_LEN_OFFSET              2
#define PHPAL_I7816P4_SW_HEADER_PAY_OFFSET_LEN_ONE      3
#define PHPAL_I7816P4_SW_HEADER_PAY_OFFSET_LEN_TWO      4

/*I2C PROTOCOLS CONFIG OPTIONS*/
#define PHPAL_I7816P4_SW_I2C_PROTOCOL_LEN_ONE           0
#define PHPAL_I7816P4_SW_I2C_PROTOCOL_LEN_TWO           1
#define PHPAL_I7816P4_SW_I2C_PROTOCOL_LRC               0
#define PHPAL_I7816P4_SW_I2C_PROTOCOL_CRC               2
#define PHPAL_I7816P4_SW_I2C_PROTOCOL_CRC_NOT_SWAPPED   0
#define PHPAL_I7816P4_SW_I2C_PROTOCOL_CRC_SWAPPED       4
#define PHPAL_I7816P4_SW_I2C_PROTOCOL_T1OVERI2C         0
#define PHPAL_I7816P4_SW_I2C_PROTOCOL_GLOBALPLATFORM    8

/*I BLOCK*/
#define PHPAL_I7816P4_SW_I_BLOCK_MASK                   0x80
#define PHPAL_I7816P4_SW_I_BLOCK_SIGNATURE              0x00
#define PHPAL_I7816P4_SW_I_BLOCK_CHAINING               0x20
#define PHPAL_I7816P4_SW_I_BLOCK_SEQ                    0x40
#define PHPAL_I7816P4_SW_I_BLOCK_ERROR_MASK             0x03

/*R BLOCK*/
#define PHPAL_I7816P4_SW_R_BLOCK_MASK                   0xC0
#define PHPAL_I7816P4_SW_R_BLOCK_SIGNATURE              0x80
#define PHPAL_I7816P4_SW_R_BLOCK_ERROR_MASK             0x0F
#define PHPAL_I7816P4_SW_R_BLOCK_SEQ                    0x10

/*SUPPORTED S BLOCKS*/
#define PHPAL_I7816P4_SW_T1_S_IFS_REQUEST               0xC1
#define PHPAL_I7816P4_SW_T1_S_IFS_ACK                   0xE1
#define PHPAL_I7816P4_SW_T1_S_WTX_REQUEST               0xC3
#define PHPAL_I7816P4_SW_T1_S_WTX_ACK                   0xE3

/* S-Blocks */
#define PHPAL_I7816P4_SW_S_REQUEST                      0xC0
#define PHPAL_I7816P4_SW_S_RESPONSE                     0xE0
#define PHPAL_I7816P4_SW_S_RESYNCH                      0x00
#define PHPAL_I7816P4_SW_S_IFS                          0x01
#define PHPAL_I7816P4_SW_S_ABORT                        0x02
#define PHPAL_I7816P4_SW_S_WTX                          0x03
#define PHPAL_I7816P4_SW_S_SWR                          0x0F
/* Global Platform S-Blocks */
#define PHPAL_I7816P4_SW_GP_S_MAX_LEN                   0x06
#define PHPAL_I7816P4_SW_GP_S_CIP                       0x04
#define PHPAL_I7816P4_SW_GP_S_RELEASE                   0x06
/* T1overI2C S-Blocks */
#define PHPAL_I7816P4_SW_T1OI_S_ENDOFAPDUSESS           0x05
#define PHPAL_I7816P4_SW_T1OI_S_SECHIPRESET             0x06
#define PHPAL_I7816P4_SW_T1OI_S_GETATR                  0x07

/*Minimum size of the block*/
#define PHPAL_I7816P4_SW_PHDLPROTOCOL_T1_MIN_INF_SIZE   0x00
#define PHPAL_I7816P4_SW_PHDLPROTOCOL_T1_MAX_INF_SIZE   0xFE
#define PHPAL_I7816P4_SW_PHDLPROTOCOL_T1_MIN_BLOCK_SIZE (PHPAL_I7816P4_SW_PHDLPROTOCOL_T1_MIN_INF_SIZE \
                                                        + PHPAL_I7816P4_SW_HEADER_PAY_OFFSET_LEN_ONE)
/*Maximum size of the payload in the block*/
#define PHPAL_I7816P4_SW_MAX_PAY_LENGTH                 (PHPAL_I7816P4_SW_INT_BUFFER_SIZE - PHPAL_I7816P4_SW_HEADER_PAY_OFFSET_LEN_ONE)

/** ISO ISO7816 Block Mask */
#define PHPAL_I7816P4_SW_BLOCK_MASK                     0xC0U

/** ISO ISO7816 I-Block */
#define PHPAL_I7816P4_SW_I_BLOCK                        0x00U
/** ISO ISO7816 I-Block RFU mask */
#define PHPAL_I7816P4_SW_I_BLOCK_RFU_MASK               0x22U
/** ISO ISO7816 I-Block RFU bits */
#define PHPAL_I7816P4_SW_I_BLOCK_RFU_BITS               0x02U

/** ISO ISO7816 R-Block */
#define PHPAL_I7816P4_SW_R_BLOCK                        0x80U
/** ISO ISO7816 R-Block RFU mask */
#define PHPAL_I7816P4_SW_R_BLOCK_RFU_MASK               0x26U
/** ISO ISO7816 R-Block RFU bits */
#define PHPAL_I7816P4_SW_R_BLOCK_RFU_BITS               0x22U

/** ISO ISO7816 S-Block */
#define PHPAL_I7816P4_SW_S_BLOCK                        0xC0U
/** ISO ISO7816 S-Block RFU mask */
#define PHPAL_I7816P4_SW_S_BLOCK_RFU_MASK               0x03U
/** ISO ISO7816 S-Block RFU bits */
#define PHPAL_I7816P4_SW_S_BLOCK_RFU_BITS               0x02U

/** Byte position of PCB byte */
#define PHPAL_I7816P4_SW_PCB_POS                        0x00U

/** Blocknumber Bit within PCB */
#define PHPAL_I7816P4_SW_PCB_BLOCKNR                    0x01U

/** Bit within PCB which signals presence of NAD byte */
#define PHPAL_I7816P4_SW_PCB_NAD_FOLLOWING              0x04U

/** Bit within PCB which signals presence of CID byte */
#define PHPAL_I7816P4_SW_PCB_CID_FOLLOWING              0x08U

/** Bit within PCB which signals chaining */
#define PHPAL_I7816P4_SW_PCB_CHAINING                   0x10U

/** Bit within PCB which signals ACK */
#define PHPAL_I7816P4_SW_PCB_ACK                        0x00U

/** Bit within PCB which signals NAK */
#define PHPAL_I7816P4_SW_PCB_NAK                        0x10U

/** Bits within PCB which signal a DESELECT command */
#define PHPAL_I7816P4_SW_PCB_DESELECT                   0x00U

/** Bits within PCB which signal a WTX command */
#define PHPAL_I7816P4_SW_PCB_WTX                        0x30U

/** WTXM Bits of WTX INF byte */
#define PHPAL_I7816P4_SW_WTXM_BITS                      0x3FU

/** FSCI default value */
#define PHPAL_I7816P4_SW_FSCI_DEFAULT                   0x20U

/** FSDI default value */
#define PHPAL_I7816P4_SW_FSDI_DEFAULT                   0x20U

/** Valid CID bits within CID field */
#define PHPAL_I7816P4_SW_CID_MASK                       0x0FU

/** I-Block transmission mode  */
#define PHPAL_I7816P4_SW_STATE_I_BLOCK_TX               0x01U

/** I-Block reception mode  */
#define PHPAL_I7816P4_SW_STATE_I_BLOCK_RX               0x02U

/** Exchange finished mode  */
#define PHPAL_I7816P4_SW_STATE_FINISHED                 0x0FU

/** An I-Block mode is retramsmitting */
#define PHPAL_I7816P4_SW_STATE_RETRANSMIT_BIT           0x40U

/** An I-Block mode is chaining */
#define PHPAL_I7816P4_SW_STATE_CHAINING_BIT             0x80U

/** Only 6 bits of the state are pure state codes */
#define PHPAL_I7816P4_SW_STATE_MASK                     0x0FU

/** Default Maximum Retry count */
#define PHPAL_I7816P4_SW_MAX_RETRIES_DEFAULT            2U

/** Commands */
#define PHPAL_I7816P4_SW_GET_RESPONSE_INS               0xC0
#define PHPAL_I7816P4_SW_ENVELOPE_INS                   0xC2

/** Procedure Bytes */
#define PHPAL_I7816P4_SW_PROCEDURE_BYTE_NULL            0x60
#define PHPAL_I7816P4_SW_PROCEDURE_BYTE_61              0x61
#define PHPAL_I7816P4_SW_PROCEDURE_BYTE_6C              0x6C
#define PHPAL_I7816P4_SW_PROCEDURE_BYTE_WARNING         0x62
#define PHPAL_I7816P4_SW_PROCEDURE_BYTE_90              0x90

/** HEADER OFFSETS */
#define PHPAL_I7816P4_SW_HEADER_CLA_OFFSET              0
#define PHPAL_I7816P4_SW_HEADER_INS_OFFSET              1
#define PHPAL_I7816P4_SW_HEADER_P1_OFFSET               2
#define PHPAL_I7816P4_SW_HEADER_P2_OFFSET               3
#define PHPAL_I7816P4_SW_HEADER_P3_OFFSET               4

#define PHPAL_I7816P4_SW_SW1_OFFSET                     0
#define PHPAL_I7816P4_SW_SW2_OFFSET                     1

#define PHPAL_I7816P4_SW_HEADER_LENGTH                  5
#define PHPAL_I7816P4_SW_SW_LENGTH                      2
#define PHPAL_I7816P4_SW_INS_LENGTH                     1

/** Command Exchange Cases */
#define PHPAL_I7816P4_SW_CASE_1                         0x00
#define PHPAL_I7816P4_SW_CASE_2S                        0x01
#define PHPAL_I7816P4_SW_CASE_3S                        0x02
#define PHPAL_I7816P4_SW_CASE_4S                        0x03
#define PHPAL_I7816P4_SW_CASE_2E                        0x04
#define PHPAL_I7816P4_SW_CASE_3E                        0x05
#define PHPAL_I7816P4_SW_CASE_4E                        0x06

#define PHPAL_I7816P4_SW_MAX_VALUE_SHORT_PAYLOAD        256
#define PHPAL_I7816P4_SW_MAX_VALUE_SHORT_APDU           (PHPAL_I7816P4_SW_MAX_VALUE_SHORT_PAYLOAD + PHPAL_I7816P4_SW_HEADER_LENGTH)

/**Main States of T1 protocol*/
typedef enum {
    PHDLPROTOCOL_T1_STATE_RX = 0xF0,
    PHDLPROTOCOL_T1_STATE_TX,
    PHDLPROTOCOL_T1_STATE_ERROR
} phdlProtocol_T1_State_t;

/**TX Substates of T1 protocol*/
typedef enum {
    PHDLPROTOCOL_T1_TXSUB_READY=0x70,
    PHDLPROTOCOL_T1_TXSUB_S_WTX_ACK,
    PHDLPROTOCOL_T1_TXSUB_I,
    PHDLPROTOCOL_T1_TXSUB_S_IFS_ACK,
    PHDLPROTOCOL_T1_TXSUB_S_IFS_REQUEST,
    PHDLPROTOCOL_T1_TXSUB_ACK,
} phdlProtocol_T1_TxSubState_t;

/**RX Substates of T1 protocol */
typedef enum {
    PHDLPROTOCOL_T1_RXSUB_READY,
    PHDLPROTOCOL_T1_RXSUB_S_IFS_ACK,
    PHDLPROTOCOL_T1_RXSUB_S_BWT_ACK,
    PHDLPROTOCOL_T1_RXSUB_I,
    PHDLPROTOCOL_T1_RXSUB_R_ACK
} phdlProtocol_T1_RxSubState_t;

phStatus_t phpalI7816p4_Sw_Int_T1_Exchange(
                                           phpalI7816p4_Sw_DataParams_t * pDataParams,
                                           uint16_t wOption,
                                           uint8_t * pTxBuffer,
                                           uint16_t wTxLength,
                                           uint8_t ** ppRxBuffer,
                                           uint16_t * pRxLength
                                           );

phStatus_t phpalI7816p4_Sw_Int_T1_TxStateMachine(
                                                 phpalI7816p4_Sw_DataParams_t * pDataParams,
                                                 uint8_t error,
                                                 uint8_t bForceTxChaining);

phStatus_t phpalI7816p4_Sw_Int_T1_RxStateMachine(
                                                 phpalI7816p4_Sw_DataParams_t * pDataParams,
                                                 uint8_t bForceTxChaining
                                                 );

phStatus_t phpalI7816p4_Sw_Int_T1_ResetStates(
                                              phpalI7816p4_Sw_DataParams_t * pDataParams
                                              );

phStatus_t phpalI7816p4_Sw_Int_T1_SendBlock(
                                            phpalI7816p4_Sw_DataParams_t * pDataParams
                                            );

phStatus_t phpalI7816p4_Sw_Int_T1_CheckForBwtExtension(
                                                       phpalI7816p4_Sw_DataParams_t * pDataParams,
                                                       uint32_t * pOldBwtTimeout
                                                       );

phStatus_t phpalI7816p4_Sw_Int_T1_RestoreBwtTimeoutIfModified(
                                                              phpalI7816p4_Sw_DataParams_t * pDataParams,
                                                              uint32_t dwOldBwtTimeout
                                                              );

phStatus_t phpalI7816p4_Sw_Int_T0_Exchange(
                                           phpalI7816p4_Sw_DataParams_t * pDataParams,
                                           uint16_t wOption,
                                           uint8_t * pTxBuffer,
                                           uint16_t wTxLength,
                                           uint8_t ** ppRxBuffer,
                                           uint16_t * pRxLength
                                           );

phStatus_t phpalI7816p4_Sw_Int_T0_Parse_Apdu(
                                             phpalI7816p4_Sw_DataParams_t * pDataParams,
                                             uint8_t * pTxBuffer,
                                             uint16_t wTxLength
                                             );

phStatus_t phpalI7816p4_Sw_Int_T0_ReceiveBlock(
                                               phpalI7816p4_Sw_DataParams_t * pDataParams
                                               );

phStatus_t phpalI7816p4_Sw_Int_T0_SendCommandExtendedLength(
                                                            phpalI7816p4_Sw_DataParams_t * pDataParams
                                                            );

phStatus_t phpalI7816p4_Sw_Int_T0_SendRestOfCommand(
                                                    phpalI7816p4_Sw_DataParams_t * pDataParams
                                                    );

phStatus_t phpalI7816p4_Sw_Int_T0_ReceiveExtendedLength(
                                                        phpalI7816p4_Sw_DataParams_t * pDataParams
                                                        );

phStatus_t phpalI7816p4_Sw_Int_T0_ReceiveFullResponseCase4(
                                                           phpalI7816p4_Sw_DataParams_t * pDataParams
                                                           );

phStatus_t phpalI7816p4_Sw_Int_T0_ReceiveFullResponseCase2(
                                                           phpalI7816p4_Sw_DataParams_t * pDataParams
                                                           );

phStatus_t phpalI7816p4_Sw_Int_T0_ReceiveBytes(
                                               phpalI7816p4_Sw_DataParams_t * pDataParams,
                                               uint32_t dwNumExpectedBytes
                                               );

phStatus_t phpalI7816p4_Sw_Int_T0_SendBlockExpectedBytes(
                                                         phpalI7816p4_Sw_DataParams_t * pDataParams,
                                                         uint32_t dwNumExpectedBytes
                                                         );

#endif /* PHPALI7816p4_SW_INT_H */
