/*
 * Copyright 2022 - 2023, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Software ISO7816-4A Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHPALI7816P4A_SW_H
#define PHPALI7816P4A_SW_H

#include <ph_Status.h>

phStatus_t phpalI7816p4a_Sw_IfsRequest(
                                       phpalI7816p4a_Sw_DataParams_t * pDataParams,
                                       uint8_t bFsdi
                                       );

phStatus_t phpalI7816p4a_Sw_Pps(
                                phpalI7816p4a_Sw_DataParams_t * pDataParams,
                                uint8_t bProtocolType,
                                uint8_t bFValue,
                                uint8_t bDValue
                                );

phStatus_t phpalI7816p4a_Sw_ActivateCard(
                                         phpalI7816p4a_Sw_DataParams_t * pDataParams,
                                         uint8_t bProtocolType,
                                         uint8_t bFsdi,
                                         uint8_t bFValue,
                                         uint8_t bDValue,
                                         uint8_t * pAtr,
                                         uint16_t * pwATRLength
                                         );

phStatus_t phpalI7816p4a_Sw_GetConfig(
                                      phpalI7816p4a_Sw_DataParams_t * pDataParams,
                                      uint16_t wConfig,
                                      uint16_t * pValue
                                      );

#endif /* PHPALI7816P4A_SW_H */
