/*
 * Copyright 2022 - 2023, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Internal definitions for Software ISO7816-4A Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHPALI7816P4A_SW_INT_H
#define PHPALI7816P4A_SW_INT_H

#include <ph_Status.h>

/** PPSS Command Code */
#define PHPAL_I7816P4A_SW_PPSS                      0xFFU

/** PPS0 Command Code */
#define PHPAL_I7816P4A_SW_PPS0                      0x10U

/** PPS Lenght */
#define PHPAL_I7816P4A_SW_PPS_LENGTH                0x03U

/** IFS Request Command Code */
#define PHPAL_I7816P4A_SW_IFS_REQUEST_CMD           0xC1U

/** IFS Response Command Code */
#define PHPAL_I7816P4A_SW_IFS_RESPONSE_CMD          0xE1U

/** T=1 Prologue Length */
#define PHPAL_I7816P4A_SW_T1PROLOGUE_LENGTH         0x03U

/** T=1 LengthField Offset */
#define PHPAL_I7816P4A_SW_T1LENGTHFIELD_OFFSET      0x02U

/** FSDI default value */
#define PHPAL_I7816P4A_SW_FSDI_DEFAULT              0x20U

#endif /* PHPALI7816P4A_SW_INT_H */
