/*
 * Copyright 2013, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Internal definitions for Software MIFARE(R) Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHPALMIFARE_INT_H
#define PHPALMIFARE_INT_H

#include <ph_Status.h>

/** \addtogroup ph_Private
* @{
*/

#define PHPAL_MIFARE_RESP_ACK    0x0A    /**< MIFARE ACK response code */
#define PHPAL_MIFARE_RESP_NAK0   0x00    /**< MIFARE NAK0 response code */
#define PHPAL_MIFARE_RESP_NAK1   0x01    /**< MIFARE NAK1 response code */
#define PHPAL_MIFARE_RESP_NAK4   0x04    /**< MIFARE NAK4 response code */
#define PHPAL_MIFARE_RESP_NAK5   0x05    /**< MIFARE NAK5 response code */
#define PHPAL_MIFARE_RESP_NAK6   0x06    /**< MIFARE NAK6 response code */
#define PHPAL_MIFARE_RESP_NAK7   0x07    /**< MIFARE NAK7 response code */
#define PHPAL_MIFARE_RESP_NAK9   0x09    /**< MIFARE NAK9 response code */

/** @}
* end of ph_Private
*/

#endif /* PHPALMIFARE_INT_H */
