/*
 * Copyright 2013, 2015, 2017, 2020, 2023, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Internal definitions for Software ISO15693 Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHPALSLI15693_SW_INT_H
#define PHPALSLI15693_SW_INT_H

#include <ph_Status.h>

#ifdef  NXPBUILD__PHPAL_SLI15693_SW

/* Constants */
#define PHPAL_SLI15693_SW_NXP_MFG_CODE                          0x04U   /* IC Manufacturer Code of NXP. */
#define PHPAL_SLI15693_SW_EXT_TIME_US                           60      /* Time extension in microseconds for all commands.  */
#define PHPAL_SLI15693_SW_T1_WAITING_TIME                       324U    /* Waiting time T1 in us (ISO/IEC15693, 9.1.4.) */
#define PHPAL_SLI15693_SW_T2_WAITING_TIME                       310U    /* Waiting time T2 in us (ISO/IEC15693, 9.1.4.) */
#define PHPAL_SLI15693_SW_UID_COMPLETE                          64U     /* UID length in bits when complete. */
#define PHPAL_SLI15693_SW_FLAGS_DEFAULT                         0x02U   /* Default flags (DATA_RATE is set). */
#define PHPAL_SLI15693_SW_TIMEOUT_SLOT_US                       PHPAL_SLI15693_SW_T1_WAITING_TIME + PHPAL_SLI15693_SW_T2_WAITING_TIME

#define PHPAL_SLI15693_SW_HIGH_NRT_US                           3928U   /* Nominal Response Time for High Data Rate */
#define PHPAL_SLI15693_SW_FASTHIGH_NRT_US                       1964U   /* Nominal Response Time for Fast High Data Rate */
#define PHPAL_SLI15693_SW_LOW_NRT_US                            15709U  /* Nominal Response Time for Low Data Rate */
#define PHPAL_SLI15693_SW_FASTLOW_NRT_US                        7855U   /* Nominal Response Time for Fast Low Data Rate */
#define PHPAL_SLI15693_SW_HIGH_SOF_US                           152U    /* Start of Frame Time for High Data Rate */
#define PHPAL_SLI15693_SW_FASTHIGH_SOF_US                       76U     /* Start of Frame  Time for Fast High Data Rate */
#define PHPAL_SLI15693_SW_LOW_SOF_US                            605U    /* Start of Frame Time for Low Data Rate */
#define PHPAL_SLI15693_SW_FASTLOW_SOF_US                        303U    /* Start of Frame  Time for Fast Low Data Rate */
#define PHPAL_SLI15693_SW_RETRYCOUNT_DEFAULT                    0x02U   /* Default retry count. */
#define PHPAL_SLI15693_SW_RETRYCOUNT_MAX                        0x05U   /* Max retry count. */

#define PHPAL_SLI15693_SW_CUSTOM_CMD_CODE_BEGIN                 0x9F    /* ISO/IEC 15693 / ISO/IEC 18000-3m1 Custom Command Code Begin. */
#define PHPAL_SLI15693_SW_CUSTOM_CMD_CODE_END                   0xE0    /* ISO/IEC 15693 / ISO/IEC 18000-3m1 Custom Command Code End. */
#define PHPAL_SLI15693_SW_FLAG_INVENTORY_READ_EXTENSION         0x80    /* ISO/IEC 15693 / ISO/IEC 18000-3m1 Inventory Read Extension flag. */
#define PHPAL_SLI15693_SW_MAX_BLOCKS                            256U    /* ISO/IEC 15693 / ISO/IEC 18000-3m1 Maximum number of blocks supported. */

#define PHPAL_SLI15693_SW_IN_PROCESS_REPLY_RESPONSE_FRAMES      0x02U   /* Maximum number of response received from reader for In-Process reply. */
#define PHPAL_SLI15693_SW_IN_PROCESS_REPLY                      0x0080U /* Flag to avoid validation of response flags in phpalSli15693_Sw_Exchange
                                                                         *  command while exchanging ISO15693 In-Reply process
                                                                         */

/**
 * \addtogroup phpalSli15693_Mandatory
 * @{
 */

/**
 * \defgroup phpalSli15693_Mandatory_Defines_CommandCodes CommandCodes
 * @{
 */
#define PHPAL_SLI15693_SW_CMD_INVENTORY                         0x01U   /* ISO/IEC 15693 / ISO/IEC 18000-3m1 Inventory command code. */
#define PHPAL_SLI15693_SW_CMD_STAY_QUIET                        0x02U   /* ISO/IEC 15693 / ISO/IEC 18000-3m1 Inventory command code. */
#define PHPAL_SLI15693_SW_CMD_STAY_QUIET_PERS                   0xBCU   /* ISO/IEC 15693 / ISO/IEC 18000-3m1 Inventory command code. */
/**
 * end of group phpalSli15693_Mandatory_Defines_CommandCodes
 * @}
 */

/**
 * end of group phpalSli15693_Mandatory
 * @}
 */

/**
 * \addtogroup phpalSli15693_Optional
 * @{
 */

/**
 * \defgroup phpalSli15693_Optional_Defines_CommandCodes CommandCodes
 * @{
 */
#define PHPAL_SLI15693_SW_CMD_SELECT                            0x25U   /* ISO/IEC 15693 / ISO/IEC 18000-3m1 Select command code. */
#define PHPAL_SLI15693_SW_CMD_RESET_TO_READY                    0x26U   /* ISO/IEC 15693 / ISO/IEC 18000-3m1 ResetToReady command code. */
/**
 * end of group phpalSli15693_Optional_Defines_CommandCodes
 * @}
 */

/**
 * end of group phpalSli15693_Optional
 * @}
 */

/**
 * \addtogroup phpalSli15693_Custom
 * @{
 */

/**
 * \defgroup phpalSli15693_Custom_Defines_CommandCodes CommandCodes
 * @{
 */
#define PHPAL_SLI15693_SW_CMD_INVENTORY_READ                    0xA0U   /* ISO/IEC 15693 / ISO/IEC 18000-3m1 InventoryRead command code. */
#define PHPAL_SLI15693_SW_CMD_FAST_INVENTORY_READ               0xA1U   /* ISO/IEC 15693 / ISO/IEC 18000-3m1 FastInventoryRead command code. */
#define PHPAL_SLI15693_SW_CMD_INVENTORY_PAGE_READ               0xB0U   /* ISO/IEC 15693 / ISO/IEC 18000-3m1 InventoryPageRead command code. */
#define PHPAL_SLI15693_SW_CMD_FAST_INVENTORY_PAGE_READ          0xB1U   /* ISO/IEC 15693 / ISO/IEC 18000-3m1 FastInventoryPageRead command code. */
#define PHPAL_SLI15693_SW_CMD_EXTENDED_GET_SYSTEM_INFORMATION   0x3B    /* ISO/IEC 15693 / ISO/IEC 18000-3m1 Extended GetSystemInformation command code. */
/**
 * end of group phpalSli15693_Custom_Defines_CommandCodes
 * @}
 */

/**
 * end of group phpalSli15693_Custom
 * @}
 */

/**
 * Perform all kinds of Inventory commands in normal and extended mode. The parameter bEntended defines whether the command should be
 * used in framed in normal or in extended mode.
 *
 * Input Parameters:
 *      pDataParams         : Pointer to this layer's parameter structure.
 *      bExtended           : Whether the command should be framed in normal or in extended mode. Also same for response frame.
 *      bCmd                : The command code to be framed or performed.
 *                              Inventory
 *                              InventoryRead (Extended)
 *                              FastInventoryRead (Extended)
 *                              InventoryPageRead
 *                              FastInventoryPageRead
 *      bFlags              : Request flags byte.
 *      bAfi                : Application Family Identifier.
 *      pMask               : UID mask, holding known UID bits.
 *      bMaskBitLength      : Number of UID bits within pMask.
 *      bExtendedOptions    : Features of the extended mode.
 *      pCID                : Two byte CID -> if marked in extended options.
 *      bPage_Block_No      : Block number of first block to read.
 *      wNoOfPages_Blocks   : Number of blocks to read.
 *
 * Output Parameters:
 *      pCIDOut             : Received CID
 *      pUid                : Received UID
 *      pUidLength          : Number of received UID bytes.
 *      pData               : Received data will have page information or blocks information or DSFID information.
 *      pDataLength         : Length of bytes available in Data buffer.
 *
 * \return Status code
 * \retval #PH_ERR_SUCCESS Operation successful.
 * \retval #PH_ERR_PROTOCOL_ERROR Invalid response received.
 * \retval Other Depending on implementation and underlaying component.
 */
phStatus_t phpalSli15693_Sw_Int_Inventory(phpalSli15693_Sw_DataParams_t* pDataParams, uint8_t bExtended, uint8_t bCmd, uint8_t bFlags, uint8_t bAfi,
    uint8_t * pMask, uint8_t bMaskBitLen, uint8_t bExtendedOptions, uint8_t * pCID, uint8_t bPage_Block_No, uint16_t wNoOfPages_Blocks, uint8_t * pCIDOut,
    uint8_t * pUid, uint8_t * pUidLen, uint8_t * pData, uint16_t * pDataLen);

#endif /* NXPBUILD__PHPAL_SLI15693_SW */

#endif /* PHPALSLI15693_SW_INT_H */
