/*
 * Copyright 2015, 2017, 2019, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Example Source for MIFARE DESFire EV1 / EV2 using PCSC Reader.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef EXAMPLE__PCSC_H
#define EXAMPLE__PCSC_H

/* Reader Library Headers. */
#include <phCidManager.h>
#include <phKeyStore.h>
#include <phCryptoRng.h>
#include <phCryptoSym.h>

#include <phbalReg.h>
#include <phhalHw.h>

#include <phpalI14443p3a.h>
#include <phpalI14443p4a.h>
#include <phpalI14443p4.h>
#include <phpalMifare.h>

#include <phalMfdf.h>

/* Standard Header. */
#ifdef _WIN32
	#pragma warning(push)           /* PRQA S 3116 */
	#pragma warning(disable:4001)   /* PRQA S 3116 */
#endif
	#include <crtdbg.h>
	#include <memory.h>
	#include <stdio.h>
	#include <string.h>
	#include <stdlib.h>
	#include <conio.h>
#ifdef _WIN32
	#pragma warning(pop)            /* PRQA S 3116 */
#endif

#define COMMAND_FORMAT_NATIVE				0x00
#define COMMAND_FORMAT_WRAPPED				0x01
#define COMMAND_FORMAT_STANDARD_ISO7816		0x02

#define OMNIKEY_CL_READER_PORT				"OMNIKEY CardMan 5x21-CL 0"
#define PR533_CL_READER_PORT				"NXP PR533 0"
#define REINERSCT_CL_READER_PORT			"REINER SCT cyberJack RFID basis 0"
#define IDENTIV_CL_READER_PORT				"Identiv CLOUD 3700 F Contactless Reader 0"

#define CHECK_SUCCESS(x)																				\
	if ( (x) != PH_ERR_SUCCESS )																		\
	{																									\
		printf ( "\n\n" );																				\
		printf ( "An error occurred: (0x%04X)\n", (x) );												\
		printf ( "\n\n" );																				\
	}

/* Context for RdLib components. -------------------------------------------------------------------------------*/
phKeyStore_Sw_DataParams_t stKeyStore;
phKeyStore_Sw_KeyEntry_t aKeyEntry[0xFF];
phKeyStore_Sw_KeyVersionPair_t aKeyVersion[0xFF];
phKeyStore_Sw_KUCEntry_t aKeyUsageCounter[0xFF];

phCryptoSym_Sw_DataParams_t stCryptoEnc;
phCryptoSym_Sw_DataParams_t stCryptoSymRng;
phCryptoRng_Sw_DataParams_t stCryptoRng;

phbalReg_PcscWin_DataParams_t stBal_Pcsc;
phhalHw_Pcsc_DataParams_t stHal_Pcsc;

phpalI14443p3a_Pcsc_DataParams_t stI14443p3a;
phpalI14443p4a_Pcsc_DataParams_t stI14443p4a;
phpalI14443p4_Pcsc_DataParams_t stI14443p4;
phpalMifare_Pcsc_DataParams_t stMifare;

phalMfdf_Sw_DataParams_t stMfdf;

/* Variables and Arrays. ---------------------------------------------------------------------------------------*/
uint8_t bSak;
uint8_t aUid[10];
uint8_t bUid_Len = 0;
uint8_t aAID_1[] = { 0x01, 0x00, 0x00 };
uint8_t aAID_2[] = { 0x02, 0x00, 0x00 };
uint8_t aAID_3[] = { 0x03, 0x00, 0x00 };

uint8_t aIsoFileID_App_1[] = { 0x11, 0x00 };
uint8_t aIsoFileID_App_2[] = { 0x22, 0x00 };
uint8_t aIsoFileID_App_3[] = { 0x33, 0x00 };

uint8_t aIsoDFName_1[] = { 'A', 'P', 'P', '1' };
uint8_t aIsoDFName_2[] = { 'A', 'P', 'P', '2' };
uint8_t aIsoDFName_3[] = { 'A', 'P', 'P', '3' };

uint8_t bFileID_1 = 0x01;
uint8_t bFileID_2 = 0x02;
uint8_t bFileID_3 = 0x03;

uint8_t aIsoFileID_File_1[] = { 0x01, 0x11 };
uint8_t aIsoFileID_File_2[] = { 0x02, 0x22 };
uint8_t aIsoFileID_File_3[] = { 0x03, 0x33 };

uint8_t aAccessRights[] = { 0xEE, 0xEE };
uint8_t aFileSize[] = { 0x40, 0x00, 0x00 };
uint8_t aLength[] = { 0x10, 0x00, 0x00 };
uint8_t aOffset[] = { 0x00, 0x00, 0x00 };

uint8_t aTx_Data[] = { 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F };

uint8_t * pRx_Data = NULL;
uint8_t * pFCI = NULL;
uint16_t wFCILen = 0;

/* Prototypes. -------------------------------------------------------------------------------------------------*/
phStatus_t UpdateKeystore ();
void PrintData ( uint8_t * pBuffer, uint32_t dwLength, char* pFormat, char* pSpecialChar );
void Log ( void* pDataParams, uint8_t bOption, phLog_LogEntry_t* pEntries, uint16_t wEntryCount );

phStatus_t CreateApplication ( uint32_t dwChoice, uint8_t bMode );
phStatus_t SelectApplication ( uint32_t dwChoice, uint8_t bMode );
phStatus_t CreateFile ( uint32_t dwChoice, uint8_t bMode );
phStatus_t WriteData ( uint32_t dwChoice, uint8_t bReset, uint8_t bMode );
phStatus_t ReadData ( uint32_t dwChoice, uint8_t bMode );
phStatus_t IsoSelectFile ( uint32_t dwChoice );
phStatus_t IsoUpdateBinary ( uint8_t bReset );
phStatus_t IsoReadBinary ();

phStatus_t ExecuteDemo ( uint32_t dwChoice, uint8_t bMode );

#endif /* EXAMPLE__PCSC_H */
