/*
 * Copyright 2019, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * General ISO3 device layer.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHDLISO3_H
#define PHDLISO3_H

#include <ph_Status.h>
#include <phbalReg.h>

#ifdef __cplusplus
extern "C" {
#endif	/* __cplusplus */


#ifdef NXPBUILD__PHDL_ISO3_FDT
/** \cond INCLUDE_INTERNALS \defgroup phdlISO3_FDT Component : FDT
* @{
*/

#define PHDL_ISO3_FDT_ID  0x01U                /**< ID for ISO3 FDT Architecture layer. */

/**
* \brief FDT Software parameter structure
*/
typedef struct
{
    uint16_t wId;                               /**< Layer ID for this component, NEVER MODIFY! */
    void * pBalRegDataParams;                   /**< Pointer to the parameter structure of the balReg component. */
    uint8_t onOffSwitch;                        /**< Keep device running until this parameter is set to 0x0. */
} phdlISO3_FDT_DataParams_t;

/**
* \brief Initialise this layer.
* \return Status code
* \retval #PH_ERR_SUCCESS Operation successful.
*/
phStatus_t phdlISO3_FDT_Init(
    phdlISO3_FDT_DataParams_t * pDataParams,    /**< [In] Pointer to this layer's parameter structure. */
    uint16_t wSizeOfDataParams,                 /**< [In] Specifies the size of the data parameter structure. */
    void * pBalRegDataParams                    /**< [In] Pointer to the parameter structure of the balReg component. */
    );

/** @} \endcond */
#endif /* NXPBUILD__PHDL_ISO3_FDT */



#ifdef NXPBUILD__PHDL_ISO3_FILTERCALIBRATION
/** \cond INCLUDE_INTERNALS \defgroup phdlISO3_FilterCalibration Component : Filter Calibration
* @{
*/

#define PHDL_ISO3_FILTERCALIBRATION_ID  0x02U   /**< ID for IIR-Filter calibration control */

typedef struct
{
    uint32_t a1;
    uint32_t a2;
    uint32_t b0;
    uint32_t b1;
    uint32_t b2;
} SOSection_t;

typedef struct
{
    SOSection_t sec1;
    SOSection_t sec2;
    SOSection_t sec3;
    SOSection_t sec4;
    uint32_t gain;
} IIRFilterCoeffs_t;

/** \name ISO3 Soft scope trigger conditions
*/
/*@{*/
#define PHDL_ISO3_FILTERCALIBRATION_CONFIG_USE_REMOTE_BUFFERS   (PH_CONFIG_CUSTOM_BEGIN) + 0   /**< Use server buffers */
/*@}*/

/** \name ISO3 Soft scope trigger conditions
*/
/*@{*/
#define PHDL_ISO3_FILTERCALIBRATION_REMOTE_BUFFER_MLS           0x0001      /**< Remote Buffer ID for Maximum length sequence */
#define PHDL_ISO3_FILTERCALIBRATION_REMOTE_BUFFER_SYS_RESP      0x0002      /**< Remote Buffer ID for System response */
/*@}*/

/**
* \brief Filter Calibration parameter structure
*/
typedef struct
{
    uint16_t wId;                                   /**< Layer ID for this component, NEVER MODIFY! */
    void * pHalDataParams;                          /**< Pointer to the HAL ISO3 layers parameter structure */
    void * pDlScopeDataParams;                      /**< Pointer to the DL ISO3 SoftScope parameter structure */
    uint8_t bUseRemoteBuffers;                      /**< Bool indication. Indicates if data should be stored remotely or fetched.*/
} phdlISO3_FilterCalibration_DataParams_t;

phStatus_t phdlISO3_FilterCalibration_Init(
                        phdlISO3_FilterCalibration_DataParams_t * pDataParams,
                        uint16_t wSizeOfDataParams,
                        void * pISO3HalDataParams,
                        void * pISO3DlSoftScopeParams
                        );

phStatus_t phdlISO3_FilterCalibration_SetConfig(
                        phdlISO3_FilterCalibration_DataParams_t * pDataParams,
                        uint16_t wIdentifier,
                        uint16_t wValue
                        );

phStatus_t phdlISO3_FilterCalibration_GetConfig(
                        phdlISO3_FilterCalibration_DataParams_t * pDataParams,
                        uint16_t wIdentifier,
                        uint16_t* pwValue
                        );

/** @} \endcond */
#endif /* NXPBUILD__PHDL_ISO3_FILTERCALIBRATION */


#ifdef NXPBUILD__PHDL_ISO3

/**
* \brief Set Config values
* \return Status code
* \retval #PH_ERR_SUCCESS Operation successful.
* \retval Other Depending on implementation and underlying component.
*/
phStatus_t phdlISO3_SetConfig(
        void * pDataParams,
        uint16_t wIdentifier,
        uint16_t wValue
        );

#endif /* NXPBUILD__PHDL_ISO3 */

#ifdef __cplusplus
} /* Extern C */
#endif

#endif /* PHDLAMP_H */
