/*
 * Copyright 2017, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Internal Hardware Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHDLOSCI_DSO7052A_CMD_H
#define PHDLOSCI_DSO7052A_CMD_H

#include <ph_Status.h>
#include <phdlOsci.h>

phStatus_t phdlOsci_DSO7052A_Cmd_SaveSetupSlotNumber(
    phdlOsci_DSO7052A_DataParams_t * pDataParams,
    uint8_t bSlotNumber
    );

phStatus_t phdlOsci_DSO7052A_Cmd_RecallSetupSlotNumber(
    phdlOsci_DSO7052A_DataParams_t * pDataParams,
    uint8_t bSlotNumber
    );

phStatus_t phdlOsci_DSO7052A_Cmd_SaveSetupFileName(
    phdlOsci_DSO7052A_DataParams_t * pDataParams,
    uint8_t *pFileName
    );

phStatus_t phdlOsci_DSO7052A_Cmd_RecallSetupFileName(
    phdlOsci_DSO7052A_DataParams_t * pDataParams,
    uint8_t *pFileName
    );

phStatus_t phdlOsci_DSO7052A_Cmd_GetAverage(
                                   phdlOsci_DSO7052A_DataParams_t * pDataParams,
                                   uint8_t  bChannel,
                                   uint16_t * pwAverage
                                   );

#endif /* PHDLOSCI_DSO7052A_CMD_H */
