/*
 * Copyright 2022 - 2023, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Micropross specific HAL-Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHHALHW_CONTACT_MICROPROSS_CMD_H
#define PHHALHW_CONTACT_MICROPROSS_CMD_H

#include <ph_Status.h>
#include <phhalHwContact.h>

#ifdef __cplusplus
extern "C" {
#endif  /* __cplusplus */

#ifdef NXPBUILD__PHHAL_HW_CONTACT_MICROPROSS

/** \defgroup phhalHwContact_Micropross_Cmd Commands
* \brief Supported Micropross Contactbased commands.
* @{
*/

/**
* \brief Enables Spy
* \return Status code
* \retval #PH_ERR_SUCCESS Command successfully executed
* \retval Other Invalid parameters or conditions - the error status is returned by the underlayed functions.
*/
phStatus_t phhalHwContact_Micropross_Cmd_EnableSpy(
                                                    phhalHwContact_Micropross_DataParams_t * pDataParams,
                                                    uint32_t dwEventMask,
                                                    uint8_t * pFilename,
                                                    uint16_t wDateFormat
                                                    );

/**
* \brief Disables Spy
* \return Status code
* \retval #PH_ERR_SUCCESS Command successfully executed
* \retval Other Invalid parameters or conditions - the error status is returned by the underlayed functions.
*/
phStatus_t phhalHwContact_Micropross_Cmd_DisableSpy(
                                                    phhalHwContact_Micropross_DataParams_t * pDataParams
                                                    );

/**
* \brief Used to force any parameters that can be defined with an ATR
* \return Status code
* \retval #PH_ERR_SUCCESS Command successfully executed
* \retval Other Invalid parameters or conditions - the error status is returned by the underlayed functions.
*/
phStatus_t phhalHwContact_Micropross_Cmd_SimAtrString(
                                                    phhalHwContact_Micropross_DataParams_t * pDataParams,
                                                    uint8_t * pAtrString
                                                    );

/**
* \brief Used to open a scenario
* \return Status code
* \retval #PH_ERR_SUCCESS Command successfully executed
* \retval Other Invalid parameters or conditions - the error status is returned by the underlayed functions.
*/
phStatus_t phhalHwContact_Micropross_Cmd_OpenScenario(
    phhalHwContact_Micropross_DataParams_t * pDataParams    /**< [In] Pointer to an initialized HAL parameter structure. */
    );

/**
* \brief Used to execute a scenario
* \return Status code
* \retval #PH_ERR_SUCCESS Command successfully executed
* \retval Other Invalid parameters or conditions - the error status is returned by the underlayed functions.
*/
phStatus_t phhalHwContact_Micropross_Cmd_ExecuteScenario(
    phhalHwContact_Micropross_DataParams_t * pDataParams,   /**< [In] Pointer to an initialized HAL parameter structure. */
    uint32_t dwTimeout                                      /**< [In] timeout of command in seconds. 0 direct return, 0xFFFFFFFF infinite timeout */
    );

/**
* \brief Used to close a scenario
* \return Status code
* \retval #PH_ERR_SUCCESS Command successfully executed
* \retval Other Invalid parameters or conditions - the error status is returned by the underlayed functions.
*/
phStatus_t phhalHwContact_Micropross_Cmd_CloseScenario(
    phhalHwContact_Micropross_DataParams_t * pDataParams    /**< [In] Pointer to an initialized HAL parameter structure. */
    );

/**
* \brief Used to add a action to a scenario
* \return Status code
* \retval #PH_ERR_SUCCESS Command successfully executed
* \retval Other Invalid parameters or conditions - the error status is returned by the underlayed functions.
*/
phStatus_t phhalHwContact_Micropross_Cmd_AddToScenario(
    phhalHwContact_Micropross_DataParams_t * pDataParams,    /**< [In] Pointer to an initialized HAL parameter structure. */
    uint8_t * pAction,                                       /**< [In] string with the action. */
    uint16_t wActionLength,                                  /**< [In] Length of the action string. */
    uint8_t * pParameter,                                    /**< [In] string with parameter for the action. */
    uint16_t wParameterLength                                /**< [In] Length of the parameter string. */
    );

/**
* \brief Returns bytes left in RxBuffer
* \return Status code
* \retval #PH_ERR_SUCCESS Command successfully executed
* \retval Other Invalid parameters or conditions - the error status is returned by the underlayed functions.
*/
phStatus_t phhalHwContact_Micropross_Cmd_GetRxBuffer(
    phhalHwContact_Micropross_DataParams_t * pDataParams,    /**< [In] Pointer to an initialized HAL parameter structure. */
    uint8_t ** ppRxBuffer,                                   /**< [Out] Pointer to received data. */
    uint16_t * pRxLength                                     /**< [Out] Number of received data bytes. */
    );

/**
* \brief Set the handler for Bal timeout
* \return Status code
* \retval #PH_ERR_SUCCESS Command successfully executed
*/
phStatus_t phhalHwContact_Micropross_Cmd_SetBalTimeoutHandler(
    phhalHwContact_Micropross_DataParams_t * pDataParams,    /**< [In] Pointer to an initialized HAL parameter structure. */
    cbBalTimeoutHandling pBalTimeoutHandling,                /**< [In] Pointer to the handler function. */
    void * pContext                                          /**< [In] Pointer to the context of the callback function */
);

/**
* \brief Get the license status for a specified license
* \return Status code
* \retval #PH_ERR_SUCCESS Command successfully executed
*/
phStatus_t phhalHwContact_Micropross_Cmd_CouplerCheckLicense(
    phhalHwContact_Micropross_DataParams_t * pDataParams,    /**< [In] Pointer to an initialized HAL parameter structure. */
    uint32_t dwLicenseId,                                    /**< [In] Specifies the license. */
    int32_t *pValidLicense                                   /**< [Out] license status. */
);

/** @} */
#endif /* NXPBUILD__PHHAL_HW_CONTACT_MICROPROSS */

#ifdef __cplusplus
} /* Extern C */
#endif

#endif /* PHHALHW_CONTACT_MICROPROSS_CMD_H */
