/*
 * Copyright 2013, 2016 - 2017, 2019 - 2020, 2023, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Generic ISO14443-3A Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 *
 * History:
 *  CHu: Generated 19. May 2009
 *
 */

#ifndef PHPALI14443P3A_H
#define PHPALI14443P3A_H

#include <ph_Status.h>
#include <phhalHw.h>

#ifdef __cplusplus
extern "C" {
#endif	/* __cplusplus */

#ifdef NXPBUILD__PHPAL_I14443P3A_SW

/** \defgroup phpalI14443p3a_Sw Component : Software
 * @{
 */
#define PHPAL_I14443P3A_SW_ID										0x01	/**< ID for Software ISO14443-3A layer. */

/** \brief Software PAL-ISO14443P3A parameter structure */
typedef struct
{
	uint16_t wId;															/**< Layer ID for this component, NEVER MODIFY! */
	void  * pHalDataParams;													/**< Pointer to the parameter structure of the underlying layer. */
	uint8_t abUid[10];														/**< Array holding the activated UID. */
	uint8_t bUidLength;														/**< Length of UID stored in \c abUid. */
	uint8_t bUidComplete;													/**< Whether the UID is complete (\c 1) or not (\c 0). */
#ifdef NXPBUILD__PHPAL_I14443P3A_NDA
	uint8_t bSilentMode;													/**< Whether the SilentMode is enabled (\c #PHPAL_I14443P3A_SILENT_MODE_ENABLED)
																			 *	 or disabled (\c #PHPAL_I14443P3A_SILENT_MODE_DISABLED).
																			 */
#endif /* NXPBUILD__PHPAL_I14443P3A_NDA */
} phpalI14443p3a_Sw_DataParams_t;

/**
 * \brief Initialise this layer.
 *
 * \return Status code
 * \retval #PH_ERR_SUCCESS Operation successful.
 */
phStatus_t phpalI14443p3a_Sw_Init(
		phpalI14443p3a_Sw_DataParams_t * pDataParams,						/**< [In] Pointer to this layer's parameter structure. */
		uint16_t wSizeOfDataParams,											/**< [In] Specifies the size of the data parameter structure. */
		void * pHalDataParams												/**< [In] Pointer to the parameter structure of the underlying layer. */
	);

/**
 * end of group Software
 * @}
 */
#endif /* NXPBUILD__PHPAL_I14443P3A_SW */

#ifdef NXPBUILD__PHPAL_I14443P3A_SAMAV2_X

/** \defgroup phpalI14443p3a_SamAV2_X Component : SamAV2_X
 * @{
 */
#define PHPAL_I14443P3A_SAMAV2_X_ID									0x02	/**< ID for SamAV2 ISO14443-3A in X-Mode layer. */

/** \brief ISO14443-3A parameter structure for SAM AV2 X. */
typedef struct
{
	uint16_t wId;															/**< Layer ID for this component, NEVER MODIFY! */
	phhalHw_SamAV2_DataParams_t * pHalDataParams;							/**< Pointer to the parameter structure of the underlying layer. */
	uint8_t abUid[10];														/**< Array holding the activated UID. */
	uint8_t bUidLength;														/**< Length of UID stored in \c abUid. */
	uint8_t bUidComplete;													/**< Whether the UID is complete (\c 1) or not (\c 0). */
} phpalI14443p3a_SamAV2_X_DataParams_t;

/**
 * \brief Initialise this layer.
 *
 * \return Status code
 * \retval #PH_ERR_SUCCESS Operation successful.
 */
phStatus_t phpalI14443p3a_SamAV2_X_Init(
		phpalI14443p3a_SamAV2_X_DataParams_t * pDataParams,					/**< [In] Pointer to this layer's parameter structure. */
		uint16_t wSizeOfDataParams,											/**< [In] Specifies the size of the data parameter structure. */
		phhalHw_SamAV2_DataParams_t * pHalDataParams						/**< [In] Pointer to the parameter structure of the underlying layer. */
	);

/**
 * end of group SamAV2 X
 * @}
 */
#endif /* NXPBUILD__PHPAL_I14443P3A_SAMAV2_X */

#ifdef NXPBUILD__PHPAL_I14443P3A_SAMAV3_X

/** \defgroup phpalI14443p3a_SamAV3_X Component : SamAV3_X
 * @{
 */
#define PHPAL_I14443P3A_SAMAV3_X_ID									0x05	/**< ID for SamAV3 ISO14443-3A in X-Mode layer. */

/** \brief ISO14443-3A parameter structure for SAM AV3 X. */
typedef struct
{
	uint16_t wId;															/**< Layer ID for this component, NEVER MODIFY! */
	phhalHw_SamAV3_DataParams_t * pHalDataParams;							/**< Pointer to the parameter structure of the underlying layer. */
	uint8_t abUid[10];														/**< Array holding the activated UID. */
	uint8_t bUidLength;														/**< Length of UID stored in \c abUid. */
	uint8_t bUidComplete;													/**< Whether the UID is complete (\c 1) or not (\c 0). */
} phpalI14443p3a_SamAV3_X_DataParams_t;

/**
 * \brief Initialise this layer.
 *
 * \return Status code
 * \retval #PH_ERR_SUCCESS Operation successful.
 */
phStatus_t phpalI14443p3a_SamAV3_X_Init(
		phpalI14443p3a_SamAV3_X_DataParams_t * pDataParams,					/**< [In] Pointer to this layer's parameter structure. */
		uint16_t wSizeOfDataParams,											/**< [In] Specifies the size of the data parameter structure. */
		phhalHw_SamAV3_DataParams_t * pHalDataParams						/**< [In] Pointer to the parameter structure of the underlying layer. */
	);

/**
 * end of group SamAV3 X
 * @}
 */
#endif /* NXPBUILD__PHPAL_I14443P3A_SAMAV3_X */

#ifdef NXPBUILD__PHPAL_I14443P3A_RD70X

/** \defgroup phpalI14443p3a_Rd70x Component : Rd70x
 * @{
 */
#define PHPAL_I14443P3A_RD70X_ID									0x03	/**< ID for Rd70X ISO14443-3A layer. */

/** \brief PAL-ISO14443P3A parameter structure for Rd70x reader. */
typedef struct
{
	uint16_t wId;															/**< Layer ID for this component, NEVER MODIFY! */
	phhalHw_Rd70x_DataParams_t * pHalDataParams;							/**< Pointer to the parameter structure of the underlying layer. */
	uint8_t abUid[10];														/**< Array holding the activated UID. */
	uint8_t bUidLength;														/**< Length of UID stored in \c abUid. */
	uint8_t bUidComplete;													/**< Whether the UID is complete (\c 1) or not (\c 0). */
} phpalI14443p3a_Rd70x_DataParams_t;

/**
 * \brief Initialise this layer.
 *
 * \return Status code
 * \retval #PH_ERR_SUCCESS Operation successful.
 */
phStatus_t phpalI14443p3a_Rd70x_Init(
		phpalI14443p3a_Rd70x_DataParams_t * pDataParams,					/**< [In] Pointer to this layer's parameter structure. */
		uint16_t wSizeOfDataParams,											/**< [In] Specifies the size of the data parameter structure. */
		phhalHw_Rd70x_DataParams_t * pHalDataParams							/**< [In] Pointer to the parameter structure of the underlying layer. */
	);

/**
 * end of group Rd70x
 * @}
 */
#endif /* NXPBUILD__PHPAL_I14443P3A_RD70X */

#ifdef NXPBUILD__PHPAL_I14443P3A_RD710

/** \defgroup phpalI14443p3a_Rd710 Component : Rd710
 * @{
 */
#define PHPAL_I14443P3A_RD710_ID									0x04	/**< ID for Rd710 ISO14443-3A layer. */

/** \brief PAL-ISO14443P3A parameter structure for Rd710 reader. */
typedef struct
{
	uint16_t wId;															/**< Layer ID for this component, NEVER MODIFY! */
	phhalHw_Rd710_DataParams_t * pHalDataParams;							/**< Pointer to the parameter structure of the underlying layer. */
} phpalI14443p3a_Rd710_DataParams_t;

/**
 * \brief Initialise this layer.
 *
 * \return Status code
 * \retval #PH_ERR_SUCCESS Operation successful.
 */
phStatus_t phpalI14443p3a_Rd710_Init(
		phpalI14443p3a_Rd710_DataParams_t * pDataParams,					/**< [In] Pointer to this layer's parameter structure. */
		uint16_t wSizeOfDataParams,											/**< [In] Specifies the size of the data parameter structure. */
		phhalHw_Rd710_DataParams_t * pHalDataParams							/**< [In] Pointer to the parameter structure of the underlying layer. */
	);

/**
 * end of group Rd710
 * @}
 */
#endif /* NXPBUILD__PHPAL_I14443P3A_RD710 */

#ifdef NXPBUILD__PHPAL_I14443P3A_PCSC

/** \defgroup phpalI14443p3a_Pcsc Component : Pcsc
 * @{
 */
#define PHPAL_I14443P3A_PCSC_ID										0x06	/**< ID for PCSC ISO14443-3A layer. */

/** \brief PAL-ISO14443P3A parameter structure for PCSC reader. */
typedef struct
{
	uint16_t wId;															/**< Layer ID for this component, NEVER MODIFY! */
	void * pHalDataParams;													/**< pointer to the parameter structure of the underlying layer */
	phbalReg_PcscWin_DataParams_t * pBalDataParams;							/**< pointer to the parameter structure of the underlying pcsc bal.
																			 *	 Is used to access the pcsc parameter
																			 */
	phhalHw_Pcsc_DataParams_t * pHalPcscDataParams;                         /**< pointer to the parameter structure of the underlying pcsc hal. Is used to access the pcsc parameter */
} phpalI14443p3a_Pcsc_DataParams_t;

/**
 * \brief Initialise PCSC PAL ISO14443-3A layer.
 *
 * \return Status code
 * \retval #PH_ERR_SUCCESS Operation successful.
 */
phStatus_t phpalI14443p3a_Pcsc_Init(
		phpalI14443p3a_Pcsc_DataParams_t * pDataParams,						/**< [In] Pointer to this layer's parameter structure. */
		uint16_t wSizeOfDataParams,											/**< [In] Specifies the size of the data parameter structure. */
		void * pHalDataParams												/**< [In] Pointer to HAL layer */
	);

/**
 * end of group PCSC
 * @}
 */
#endif /* NXPBUILD__PHPAL_I14443P3A_PCSC */

#ifdef NXPBUILD__PHPAL_I14443P3A_CALLBACK

 /** \defgroup phpalI14443p3a_Callback Component : Callback
  * @{
  */
#define PHPAL_I14443P3A_CALLBACK_ID                                           0x07          /**< ID for Callback ISO14443-3A layer. */

  /** \brief Callback Delegate for \ref phpalI14443p3a_RequestA */
typedef phStatus_t(*cbPalI14443p3a_RequestA)(
    uint8_t * pAtqa,                                                                        /**< [Out] Response of RequestA command. The buffer cannot be null and
                                                                                             *         size should be 2 bytes long.
                                                                                             */
    void * pContext                                                                         /**< [Out] User Defined Context. */
    );

/** \brief Callback Delegate for \ref phpalI14443p3a_RequestS */
typedef phStatus_t(*cbPalI14443p3a_RequestS)(
    uint8_t * pAtqs,                                                                        /**< [Out] Response of RequestS command. The buffer cannot be null and
                                                                                             *         size should be 2 bytes long.
                                                                                             */
    void * pContext                                                                         /**< [Out] User Defined Context. */
    );

/** \brief Callback Delegate for \ref phpalI14443p3a_WakeUpA */
typedef phStatus_t(*cbPalI14443p3a_WakeUpA)(
    uint8_t * pAtqa,                                                                        /**< [Out] Response of WakeUpA command. The buffer cannot be null and
                                                                                             *         size should be 2 bytes long.
                                                                                             */
    void * pContext                                                                         /**< [Out] User Defined Context. */
    );

/** \brief Callback Delegate for \ref phpalI14443p3a_WakeUpS */
typedef phStatus_t(*cbPalI14443p3a_WakeUpS)(
    uint8_t * pAtqs,                                                                        /**< [Out] Response of WakeUpS command. The buffer cannot be null and
                                                                                             *         size should be 2 bytes long.
                                                                                             */
    void * pContext                                                                         /**< [Out] User Defined Context. */
    );

/** \brief Callback Delegate for \ref phpalI14443p3a_HaltA */
typedef phStatus_t(*cbPalI14443p3a_HaltA)(
    void * pContext                                                                         /**< [Out] User Defined Context. */
    );

/** \brief Callback Delegate for \ref phpalI14443p3a_Anticollision */
typedef phStatus_t(*cbPalI14443p3a_Anticollision)(
    uint8_t bCascadeLevel,                                                                  /**< [In] Cascade level code.
                                                                                             *          \arg #PHPAL_I14443P3A_CASCADE_LEVEL_1
                                                                                             *          \arg #PHPAL_I14443P3A_CASCADE_LEVEL_2
                                                                                             *          \arg #PHPAL_I14443P3A_CASCADE_LEVEL_3
                                                                                             */
    uint8_t * pUidIn,                                                                       /**< [In] Known Uid, can be NULL; uint8_t[0-4]. */
    uint8_t bNvbUidIn,                                                                      /**< [In] Number of valid bits of UidIn. MSB codes the valid bytes,
                                                                                             *        LSB codes the valid bits.
                                                                                             */
    uint8_t * pUidOut,                                                                      /**< [Out] Complete Uid; uint8_t[4]. */
    uint8_t * pNvbUidOut,                                                                   /**< [Out] Number of valid bits of UidOut. MSB codes the valid bytes,
                                                                                             *         LSB codes the valid bits.
                                                                                             */
    void * pContext                                                                         /**< [Out] User Defined Context. */
    );

/** \brief Callback Delegate for \ref phpalI14443p3a_Select */
typedef phStatus_t(*cbPalI14443p3a_Select)(
    uint8_t bCascadeLevel,                                                                  /**< [In] Cascade level code.
                                                                                             *          \arg #PHPAL_I14443P3A_CASCADE_LEVEL_1
                                                                                             *          \arg #PHPAL_I14443P3A_CASCADE_LEVEL_2
                                                                                             *          \arg #PHPAL_I14443P3A_CASCADE_LEVEL_3
                                                                                             */
    uint8_t * pUidIn,                                                                       /**< [In] Uid; uint8_t[4]. */
    uint8_t * pSak,                                                                         /**< [Out] Select Acknowledge; uint8_t. */
    void * pContext                                                                         /**< [Out] User Defined Context. */
    );

/** \brief Callback Delegate for \ref phpalI14443p3a_ActivateCard */
typedef phStatus_t(*cbPalI14443p3a_ActivateCard)(
    uint8_t * pUidIn,                                                                       /**< [In] Known Uid, can be NULL if bLenUidIn is 0; uint8_t[4/7/10]. */
    uint8_t bLenUidIn,                                                                      /**< [In] Length of known Uid; 0/4/7/10. */
    uint8_t * pUidOut,                                                                      /**< [Out] Complete Uid; uint8_t[10]. */
    uint8_t * pLenUidOut,                                                                   /**< [Out] Length of Uid; 4/7/10. */
    uint8_t * pSak,                                                                         /**< [Out] Select Acknowledge; uint8_t. */
    uint8_t * pMoreCardsAvailable,                                                          /**< [Out] Whether there are more cards in the field or not; uint8_t. */
    void * pContext                                                                         /**< [Out] User Defined Context. */
    );

/** \brief Callback Delegate for \ref phpalI14443p3a_Exchange */
typedef phStatus_t(*cbPalI14443p3a_Exchange)(
    uint16_t wOption,                                                                       /**< [In] Option parameter. */
    uint8_t * pTxBuffer,                                                                    /**< [In] Data to transmit. */
    uint16_t wTxLength,                                                                     /**< [In] Length of data to transmit. */
    uint8_t ** ppRxBuffer,                                                                  /**< [Out] Pointer to received data. */
    uint16_t * pRxLength,                                                                   /**< [Out] number of received data bytes. */
    void * pContext                                                                         /**< [Out] User Defined Context. */
    );

/** \brief Callback Delegate for \ref phpalI14443p3a_GetSerialNo */
typedef phStatus_t(*cbPalI14443p3a_GetSerialNo)(
    uint8_t * pUidOut,                                                                      /**< [Out] Last Complete Uid; uint8_t[10]. */
    uint8_t * pLenUidOut,                                                                   /**< [Out] Length of Uid; 4/7/10. */
    void * pContext                                                                         /**< [Out] User Defined Context. */
    );

/** \brief Callback Delegate for \ref phpalI14443p3a_GetConfig */
typedef phStatus_t(*cbPalI14443p3a_GetConfig)(
    uint16_t wConfig,                                                                       /**< [In] Configuration to read. Will be one of the below values.
                                                                                             *          \arg #PHPAL_I14443P3A_SILENT_MODE
                                                                                             */
    uint16_t * pValue,                                                                      /**< [Out] The value for the mentioned configuration. */
    void * pContext                                                                         /**< [Out] User Defined Context. */
    );

/** \brief Callback Delegate for \ref phpalI14443p3a_SetConfig */
typedef phStatus_t(*cbPalI14443p3a_SetConfig)(
    uint16_t wConfig,                                                                       /**< [In] Configuration to set. Will be one of the below values.
                                                                                             *          \arg #PHPAL_I14443P3A_SILENT_MODE
                                                                                             */
    uint16_t wValue,                                                                            /**< [In] The value for the mentioned configuration. */
    void * pContext                                                                         /**< [Out] User Defined Context. */
    );

/** \brief PAL-ISO14443P3A parameter structure for Callback reader. */
typedef struct
{
    uint16_t wId;                                                                               /**< Layer ID for this component, NEVER MODIFY! */
    cbPalI14443p3a_RequestA pRequestACb;                                                        /**< Pointer to \ref cbPalI14443p3a_RequestA Callback. */
    cbPalI14443p3a_RequestS pRequestSCb;                                                        /**< Pointer to \ref cbPalI14443p3a_RequestS Callback. */
    cbPalI14443p3a_WakeUpA pWakeUpACb;                                                          /**< Pointer to \ref cbPalI14443p3a_WakeUpA Callback. */
    cbPalI14443p3a_WakeUpS pWakeUpSCb;                                                          /**< Pointer to \ref cbPalI14443p3a_WakeUpS Callback. */
    cbPalI14443p3a_HaltA pHaltACb;                                                              /**< Pointer to \ref cbPalI14443p3a_HaltA Callback. */
    cbPalI14443p3a_Anticollision pAnticollisionCb;                                              /**< Pointer to \ref cbPalI14443p3a_Anticollision Callback. */
    cbPalI14443p3a_Select pSelectCb;                                                            /**< Pointer to \ref cbPalI14443p3a_Select Callback. */
    cbPalI14443p3a_ActivateCard pActivateCardCb;                                                /**< Pointer to \ref cbPalI14443p3a_ActivateCard Callback. */
    cbPalI14443p3a_Exchange pExchangeCb;                                                        /**< Pointer to \ref cbPalI14443p3a_Exchange Callback. */
    cbPalI14443p3a_GetSerialNo pGetSerialNoCb;                                                  /**< Pointer to \ref cbPalI14443p3a_GetSerialNo Callback. */
    cbPalI14443p3a_GetConfig pGetConfigCb;                                                      /**< Pointer to \ref cbPalI14443p3a_GetConfig Callback. */
    cbPalI14443p3a_SetConfig pSetConfigCb;                                                      /**< Pointer to \ref cbPalI14443p3a_SetConfig Callback. */
    void * pCbContext;                                                                          /**< Custom context which is passed back to each Callback. */
} phpalI14443p3a_Callback_DataParams_t;

/**
 * \brief Initialise Callback PAL ISO14443-3A layer.
 *
 * \return Status code
 * \retval #PH_ERR_SUCCESS Operation successful.
 */
phStatus_t phpalI14443p3a_Callback_Init(
    phpalI14443p3a_Callback_DataParams_t * pDataParams,                                         /**< [In] Pointer to this layer's parameter structure. */
    uint16_t wSizeOfDataParams,                                                                 /**< [In] Specifies the size of the data parameter structure. */
    cbPalI14443p3a_RequestA pRequestACb,                                                        /**< Pointer to \ref cbPalI14443p3a_RequestA Callback. */
    cbPalI14443p3a_RequestS pRequestSCb,                                                        /**< Pointer to \ref cbPalI14443p3a_RequestS Callback. */
    cbPalI14443p3a_WakeUpA pWakeUpACb,                                                          /**< Pointer to \ref cbPalI14443p3a_WakeUpA Callback. */
    cbPalI14443p3a_WakeUpS pWakeUpSCb,                                                          /**< Pointer to \ref cbPalI14443p3a_WakeUpS Callback. */
    cbPalI14443p3a_HaltA pHaltACb,                                                              /**< Pointer to \ref cbPalI14443p3a_HaltA Callback. */
    cbPalI14443p3a_Anticollision pAnticollisionCb,                                              /**< Pointer to \ref cbPalI14443p3a_Anticollision Callback. */
    cbPalI14443p3a_Select pSelectCb,                                                            /**< Pointer to \ref cbPalI14443p3a_Select Callback. */
    cbPalI14443p3a_ActivateCard pActivateCardCb,                                                /**< Pointer to \ref cbPalI14443p3a_ActivateCard Callback. */
    cbPalI14443p3a_Exchange pExchangeCb,                                                        /**< Pointer to \ref cbPalI14443p3a_Exchange Callback. */
    cbPalI14443p3a_GetSerialNo pGetSerialNoCb,                                                  /**< Pointer to \ref cbPalI14443p3a_GetSerialNo Callback. */
    cbPalI14443p3a_GetConfig pGetConfigCb,                                                      /**< Pointer to \ref cbPalI14443p3a_GetConfig Callback. */
    cbPalI14443p3a_SetConfig pSetConfigCb,                                                      /**< Pointer to \ref cbPalI14443p3a_SetConfig Callback. */
    void * pCbContext                                                                           /**< Custom context which is passed back to each Callback. */
);

/**
 * end of group phpalI14443p3a_Callback
 * @}
 */
#endif /* NXPBUILD__PHPAL_I14443P3A_CALLBACK */

#ifdef NXPBUILD__PHPAL_I14443P3A_SAM_X

 /** \defgroup phpalI14443p3a_Sam_X Component : Sam_X
 * @{
 */
#define PHPAL_I14443P3A_SAM_X_ID                            0x08    /**< ID for SAM (AV4 and future SAM's) ISO14443-3A in X-Mode layer. */

 /** \brief ISO14443-3A parameter structure for SAM (AV4 and future SAM's) X. */
typedef struct
{
    uint16_t wId;                                                   /**< Layer ID for this component, NEVER MODIFY! */
    phhalHw_Sam_DataParams_t * pHalDataParams;                      /**< Pointer to the parameter structure of the underlying layer. */
    uint8_t abUid[10];                                              /**< Array holding the activated UID. */
    uint8_t bUidLength;                                             /**< Length of UID stored in \c abUid. */
    uint8_t bUidComplete;                                           /**< Whether the UID is complete (\c 1) or not (\c 0). */
} phpalI14443p3a_Sam_X_DataParams_t;

/**
* \brief Initialise this layer.
*
* \return Status code
* \retval #PH_ERR_SUCCESS Operation successful.
*/
phStatus_t phpalI14443p3a_Sam_X_Init(
        phpalI14443p3a_Sam_X_DataParams_t * pDataParams,            /**< [In] Pointer to this layer's parameter structure. */
        uint16_t wSizeOfDataParams,                                 /**< [In] Specifies the size of the data parameter structure. */
        phhalHw_Sam_DataParams_t * pHalDataParams                   /**< [In] Pointer to the parameter structure of the underlying layer. */
    );

/**
 * @}
 * end of group phpalI14443p3a_Sam_X
 */
#endif /* NXPBUILD__PHPAL_I14443P3A_SAM_X */

#ifdef NXPBUILD__PHPAL_I14443P3A

/** \defgroup phpalI14443p3a ISO/IEC 14443-3A
 * \brief These Components implement the ISO/IEC 14443-3 Type-A contactless protocol.
 * @{
 */

#define PHPAL_I14443P3A_CASCADE_LEVEL_1     0x93							/**< Cascade Level 1 code for ISO14443-3A anticollision/select command. */
#define PHPAL_I14443P3A_CASCADE_LEVEL_2     0x95							/**< Cascade Level 2 code for ISO14443-3A anticollision/select command. */
#define PHPAL_I14443P3A_CASCADE_LEVEL_3     0x97							/**< Cascade Level 3 code for ISO14443-3A anticollision/select command. */
#define PHPAL_I14443P3A_TIMEOUT_DEFAULT_MS  10								/**< Timeout after card selection in milliseconds. */

/**
 * \brief Perform a ISO14443-3A Request A command.
 *
 * \b Note: The "Request Guard Time" <em>(see 6.2.2, ISO/IEC 14443-3:2009(E))</em> is mandatory and is
 * neither implemented here nor implemented in every \ref phhalHw layer.\n
 * Make sure that either the used HAL or the used application does comply to this rule.
 *
 * \return Status code
 * \retval #PH_ERR_SUCCESS Operation successful.
 * \retval #PH_ERR_PROTOCOL_ERROR Invalid response received.
 * \retval Other Depending on implementation and underlaying component.
 */
phStatus_t phpalI14443p3a_RequestA(
		void * pDataParams,													/**< [In] Pointer to this layer's parameter structure. */
		uint8_t * pAtqa														/**< [Out] Response of RequestA command. The buffer cannot be null and
																			 *		   size should be 2 bytes long.
																			 */
	);

#ifdef NXPBUILD__PHPAL_I14443P3A_NDA
/**
 * \brief Perform a ISO14443-3A Request S command. This command is support for software mode only.
 *
 * \b Note: The "Request Guard Time" <em>(see 6.2.2, ISO/IEC 14443-3:2009(E))</em> is mandatory and is
 * neither implemented here nor implemented in every \ref phhalHw layer.\n
 * Make sure that either the used HAL or the used application does comply to this rule.
 *
 * \return Status code
 * \retval #PH_ERR_SUCCESS Operation successful.
 * \retval #PH_ERR_PROTOCOL_ERROR Invalid response received.
 * \retval Other Depending on implementation and underlaying component.
 */
phStatus_t phpalI14443p3a_RequestS(
		void * pDataParams,													/**< [In] Pointer to this layer's parameter structure. */
		uint8_t * pAtqs														/**< [Out] Response of RequestS command. The buffer cannot be null and
																			 *		   size should be 2 bytes long.
																			 */
	);
#endif /* NXPBUILD__PHPAL_I14443P3A_NDA */

/**
 * \brief Perform a ISO14443-3A Wakeup A command.
 *
 * \b Note: The "Request Guard Time" <em>(see 6.2.2, ISO/IEC 14443-3:2009(E))</em> is mandatory and is
 * neither implemented here nor implemented in every \ref phhalHw layer.\n
 * Make sure that either the used HAL or the used application does comply to this rule.
 *
 * \return Status code
 * \retval #PH_ERR_SUCCESS Operation successful.
 * \retval #PH_ERR_PROTOCOL_ERROR Invalid response received.
 * \retval Other Depending on implementation and underlaying component.
 */
phStatus_t phpalI14443p3a_WakeUpA(
		void * pDataParams,													/**< [In] Pointer to this layer's parameter structure. */
		uint8_t * pAtqa														/**< [Out] Response of WakeUpA command. The buffer cannot be null and
																			 *		   size should be 2 bytes long.
																			 */
	);

#ifdef NXPBUILD__PHPAL_I14443P3A_NDA
/**
 * \brief Perform a ISO14443-3A Wakeup S command. This command is support for software mode only.
 *
 * \b Note: The "Request Guard Time" <em>(see 6.2.2, ISO/IEC 14443-3:2009(E))</em> is mandatory and is
 * neither implemented here nor implemented in every \ref phhalHw layer.\n
 * Make sure that either the used HAL or the used application does comply to this rule.
 *
 * \return Status code
 * \retval #PH_ERR_SUCCESS Operation successful.
 * \retval #PH_ERR_PROTOCOL_ERROR Invalid response received.
 * \retval Other Depending on implementation and underlaying component.
 */
phStatus_t phpalI14443p3a_WakeUpS(
		void * pDataParams,													/**< [In] Pointer to this layer's parameter structure. */
		uint8_t * pAtqs														/**< [Out] Response of WakeUpS command. The buffer cannot be null and
																			 *		   size should be 2 bytes long.
																			 */
	);
#endif /* NXPBUILD__PHPAL_I14443P3A_NDA */

/**
 * \brief Perform a ISO14443-3A Halt command.
 *
 * \return Status code
 * \retval #PH_ERR_SUCCESS Operation successful.
 * \retval #PH_ERR_PROTOCOL_ERROR Invalid response received.
 * \retval Other Depending on implementation and underlaying component.
 */
phStatus_t phpalI14443p3a_HaltA(
		void * pDataParams													/**< [In] Pointer to this layer's parameter structure. */
	);

/**
 * \brief Perform a ISO14443-3A Anticollision or Select command.
 *
 * bNvbUidIn != 0x40: Perform Anticollision command.\n
 * bNvbUidIn = 0x40: Perform Select command.
 * \return Status code
 * \retval #PH_ERR_SUCCESS Operation successful.
 * \retval #PH_ERR_PROTOCOL_ERROR Invalid response received.
 * \retval #PH_ERR_FRAMING_ERROR Bcc invalid.
 * \retval Other Depending on implementation and underlaying component.
 */
phStatus_t phpalI14443p3a_Anticollision(
		void * pDataParams,													/**< [In] Pointer to this layer's parameter structure. */
		uint8_t bCascadeLevel,												/**< [In] Cascade level code.
																			 *			\arg #PHPAL_I14443P3A_CASCADE_LEVEL_1
																			 *			\arg #PHPAL_I14443P3A_CASCADE_LEVEL_2
																			 *			\arg #PHPAL_I14443P3A_CASCADE_LEVEL_3
																			 */
		uint8_t * pUidIn,													/**< [In] Known Uid, can be NULL; uint8_t[0-4]. */
		uint8_t bNvbUidIn,													/**< [In] Number of valid bits of UidIn. MSB codes the valid bytes,
																			 *		  LSB codes the valid bits.
																			 */
		uint8_t * pUidOut,													/**< [Out] Complete Uid; uint8_t[4]. */
		uint8_t * pNvbUidOut												/**< [Out] Number of valid bits of UidOut. MSB codes the valid bytes,
																			 *		   LSB codes the valid bits.
																			 */
	);

/**
 * \brief Perform a ISO14443-3A Select command.
 *
 * \return Status code
 * \retval #PH_ERR_SUCCESS Operation successful.
 * \retval #PH_ERR_PROTOCOL_ERROR Invalid response received.
 * \retval Other Depending on implementation and underlaying component.
 */
phStatus_t phpalI14443p3a_Select(
		void * pDataParams,													/**< [In] Pointer to this layer's parameter structure. */
		uint8_t bCascadeLevel,												/**< [In] Cascade level code.
																			 *			\arg #PHPAL_I14443P3A_CASCADE_LEVEL_1
																			 *			\arg #PHPAL_I14443P3A_CASCADE_LEVEL_2
																			 *			\arg #PHPAL_I14443P3A_CASCADE_LEVEL_3
																			 */
		uint8_t * pUidIn,													/**< [In] Uid; uint8_t[4]. */
		uint8_t * pSak														/**< [Out] Select Acknowledge; uint8_t. */
	);

/**
 * \brief Perform ISO14443-3A ReqA/WupA or ReqS/WupS and Anticollision/Select commands for all cascade levels.
 *
 * \cond INTERNAL
 * If CardUid not given (bLenUidIn is '0') \n
 *		\c If SilentMode is disabled (#PHPAL_I14443P3A_SILENT_MODE_DISABLED): ReqA is performed.\n
 *		\c If SilentMode is enabled (#PHPAL_I14443P3A_SILENT_MODE_ENABLED): ReqS is performed.\n
 * \n
 * If CardUid is given (bLenUidIn is not '0') \n
 *		\c If SilentMode is disabled (#PHPAL_I14443P3A_SILENT_MODE_DISABLED): WupA is performed.
 *		\c If SilentMode is enabled (#PHPAL_I14443P3A_SILENT_MODE_ENABLED): WupS is performed.
 * \endcond
 *
 * \return Status code
 * \retval #PH_ERR_SUCCESS Operation successful.
 * \retval #PH_ERR_PROTOCOL_ERROR Invalid response received.
 * \retval #PH_ERR_FRAMING_ERROR Bcc invalid.
 * \retval #PH_ERR_LENGTH_ERROR Given \c pUidIn is not complete.
 * \retval Other Depending on implementation and underlaying component.
 */
phStatus_t phpalI14443p3a_ActivateCard(
		void * pDataParams,													/**< [In] Pointer to this layer's parameter structure. */
		uint8_t * pUidIn,													/**< [In] Known Uid, can be NULL if bLenUidIn is 0; uint8_t[4/7/10]. */
		uint8_t bLenUidIn,													/**< [In] Length of known Uid; 0/4/7/10. */
		uint8_t * pUidOut,													/**< [Out] Complete Uid; uint8_t[10]. */
		uint8_t * pLenUidOut,												/**< [Out] Length of Uid; 4/7/10. */
		uint8_t * pSak,														/**< [Out] Select Acknowledge; uint8_t. */
		uint8_t * pMoreCardsAvailable										/**< [Out] Whether there are more cards in the field or not; uint8_t. */
	);

/**
 * \brief Perform ISO14443-3A Data Exchange with Picc.
 *
 * \c wOption can be one of:\n
 * \li #PH_EXCHANGE_DEFAULT
 * \li #PH_EXCHANGE_BUFFER_FIRST
 * \li #PH_EXCHANGE_BUFFER_CONT
 * \li #PH_EXCHANGE_BUFFER_LAST
 *
 * Alternatively, the following bits can be combined:\n
 * \li #PH_EXCHANGE_BUFFERED_BIT
 * \li #PH_EXCHANGE_LEAVE_BUFFER_BIT
 *
 * \return Status code
 * \retval #PH_ERR_SUCCESS Operation successful.
 * \retval Other Depending on implementation and underlaying component.
 */
phStatus_t phpalI14443p3a_Exchange(
		void * pDataParams,													/**< [In] Pointer to this layer's parameter structure. */
		uint16_t wOption,													/**< [In] Option parameter. */
		uint8_t * pTxBuffer,												/**< [In] Data to transmit. */
		uint16_t wTxLength,													/**< [In] Length of data to transmit. */
		uint8_t ** ppRxBuffer,												/**< [Out] Pointer to received data. */
		uint16_t * pRxLength												/**< [Out] number of received data bytes. */
	);

/**
 * \brief Retrieve the serial number.
 *
 * \return Status code
 * \retval #PH_ERR_SUCCESS Operation successful.
 * \retval #PH_ERR_USE_CONDITION No Serial number available at the moment.
 */
phStatus_t phpalI14443p3a_GetSerialNo(
		void * pDataParams,													/**< [In] Pointer to this layer's parameter structure. */
		uint8_t * pUidOut,													/**< [Out] Last Complete Uid; uint8_t[10]. */
		uint8_t * pLenUidOut												/**< [Out] Length of Uid; 4/7/10. */
	);

#ifdef NXPBUILD__PHPAL_I14443P3A_NDA
/** \name The configuration to be used for SetConfig / GetConfig. */
/** @{ */
#define PHPAL_I14443P3A_SILENT_MODE									0x00A1U	/**< Option for Get/Set Config to enable/disable Silent mode activation
																			 *	 (\ref phpalI14443p3a_ActivateCard).
																			 *	 By default the configuration will be disabled.
																			 *		\arg #PHPAL_I14443P3A_SILENT_MODE_DISABLED
																			 *		\arg #PHPAL_I14443P3A_SILENT_MODE_ENABLED
																			 */
#define PHPAL_I14443P3A_SILENT_MODE_DISABLED						0x00U	/**< Silent mode is disabled. ReqA / WupA command will be used. This is the default
																			 *	 option for #PHPAL_I14443P3A_SILENT_MODE configuration.
																			 */
#define PHPAL_I14443P3A_SILENT_MODE_ENABLED							0x01U	/**< Silent mode is enabled. ReqS / WupS command will be used. */
/** @} */

/**
* \brief Perform a GetConfig command.
*
* \return Status code
* \retval #PH_ERR_SUCCESS Operation successful.
* \retval Other Depending on implementation and underlying component.
*/
phStatus_t phpalI14443p3a_GetConfig(
	void * pDataParams,														/**< [In] Pointer to this layer's parameter structure. */
	uint16_t wConfig,														/**< [In] Configuration to read. Will be one of the below values.
																			*			\arg #PHPAL_I14443P3A_SILENT_MODE
																			*/
	uint16_t * pValue														/**< [Out] The value for the mentioned configuration. */
);

/**
* \brief Perform a SetConfig command.
*
* \return Status code
* \retval #PH_ERR_SUCCESS Operation successful.
* \retval Other Depending on implementation and underlying component.
*/
phStatus_t phpalI14443p3a_SetConfig(
	void * pDataParams,														/**< [In] Pointer to this layer's parameter structure. */
	uint16_t wConfig,														/**< [In] Configuration to set. Will be one of the below values.
																			*			\arg #PHPAL_I14443P3A_SILENT_MODE
																			*/
	uint16_t wValue															/**< [In] The value for the mentioned configuration. */
);
#endif /* NXPBUILD__PHPAL_I14443P3A_NDA */

/**
 * end of group phpalI14443p3a
 * @}
 */
#endif /* NXPBUILD__PHPAL_I14443P3A */

#ifdef __cplusplus
} /* Extern C */
#endif

#endif /* PHPALI14443P3A_H */
