/*
 * Copyright 2021 - 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Software specific ASymmetric Cryptography Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 *
 * History:
 *  SLe: Generated 21.04.2021
 *
 */

#ifndef PHCRYPTOASYM_STUB_H
#define PHCRYPTOSSYM_STUB_H

#include <ph_Status.h>
#include <ph_RefDefs.h>
#include <phCryptoASym.h>

#ifdef NXPBUILD__PH_CRYPTOASYM_STUB

/* CryptoASym RSA related commands ----------------------------------------------------------------------------------------------------- */





/* CryptoASym Hash related commands ---------------------------------------------------------------------------------------------------- */
phStatus_t phCryptoASym_Stub_ComputeHash(phCryptoASym_Stub_DataParams_t * pDataParams, uint16_t wOption, uint8_t bHashAlgo,
    uint8_t * pMessage, uint16_t wMsgLen, uint8_t * pHash, uint16_t * pHashLen);





/* CryptoASym ECC related commands ----------------------------------------------------------------------------------------------------- */
phStatus_t phCryptoASym_Stub_ECC_GenerateKeyPair(phCryptoASym_Stub_DataParams_t * pDataParams, uint8_t bCurveID);

phStatus_t phCryptoASym_Stub_ECC_ExportKey(phCryptoASym_Stub_DataParams_t * pDataParams, uint16_t wOption, uint16_t wKeyBuffSize,
    uint8_t * pCurveID, uint8_t * pKey, uint16_t * pKeyLen);

phStatus_t phCryptoASym_Stub_ECC_LoadKey(phCryptoASym_Stub_DataParams_t * pDataParams, uint16_t wOption, uint16_t wKeyNo, uint16_t wPos);

phStatus_t phCryptoASym_Stub_ECC_LoadKeyDirect(phCryptoASym_Stub_DataParams_t * pDataParams, uint16_t wOption, uint8_t * pKey, uint16_t wKeyLen);

phStatus_t phCryptoASym_Stub_ECC_Sign(phCryptoASym_Stub_DataParams_t * pDataParams, uint16_t wOption, uint8_t bHashAlgo, uint8_t * pMessage,
    uint16_t wMsgLen, uint8_t * pSign, uint16_t * pSignLen);

phStatus_t phCryptoASym_Stub_ECC_Verify(phCryptoASym_Stub_DataParams_t * pDataParams, uint16_t wOption, uint8_t bHashAlgo, uint8_t * pMessage,
    uint16_t wMsgLen, uint8_t * pSign, uint16_t wSignLen);

phStatus_t phCryptoASym_Stub_ECC_SharedSecret(phCryptoASym_Stub_DataParams_t * pDataParams, uint16_t wOption, uint8_t * pPublicKey,
    uint16_t wPublicKeyLen, uint8_t * pSharedSecret, uint16_t * pSharedSecretLen);





/* CryptoASym Utility functions -------------------------------------------------------------------------------------------------------- */
phStatus_t phCryptoASym_Stub_InvalidateKey(phCryptoASym_Stub_DataParams_t * pDataParams);

phStatus_t phCryptoASym_Stub_GetLastStatus(phCryptoASym_Stub_DataParams_t * pDataParams, uint16_t wStatusMsgLen, int8_t * pStatusMsg,
	int32_t * pStatusCode);

#endif /* NXPBUILD__PH_CRYPTOASYM_STUB */

#endif /* PHCRYPTOASYM_STUB_H */
