/*
 * Copyright 2013 - 2014, 2017, 2023, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Internal definitions for Log Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHLOG_INT_H
#define PHLOG_INT_H

#include <ph_Status.h>
#include <ph_TypeDefs.h>

#ifdef __cplusplus
extern "C" {
#endif	/* __cplusplus */

/** \addtogroup ph_Private
*  @{
*/

/**
* \brief Retreive \ref phLog_RegisterEntry_t corresponding to given DataParams pointer
*/
phLog_RegisterEntry_t * phLog_GetRegisteredEntry(
    void * pDataParams  /**< [In] The DataParams of the calling function. */
    );

/**
* \brief Add a new log entry containing raw data. \see phLog_LogEnty_t
*/
void phLog_AddParam_Raw(
                        void * pDataParams,     /**< [In] The DataParams of the calling function. */
                        uint8_t bLogType,       /**< [In] Type of Entry (one of the \c PH_LOG_LOGTYPE_* values). */
                        const char * pName,     /**< [In] The Null-terminated name of the parameter. */
                        const void * pParam,    /**< [In] Pointer to the memory where the parameter resides. */
                        uint16_t wLength,       /**< [In] The length in bytes to the supplied buffer. */
                        uint8_t bDataType       /**< [In] Indicates the value type (either #PH_LOG_DATATYPE_BUFFER or #PH_LOG_DATATYPE_VALUE). */
                        );

/** @} */

#ifdef __cplusplus
} /* Extern C */
#endif

#endif  /* PHLOG_INT_H */
