/*
 * Copyright 2017 - 2020, 2022 - 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Software ICode Application Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 *
 * History:
 *  CHu: Generated 02. January 2017
 *
 */

#ifndef PHALICODE_SW_H
#define PHALICODE_SW_H

#include <ph_Status.h>

#ifdef NXPBUILD__PHAL_ICODE_SW
/* iCode Mandatory commands ---------------------------------------------------------------------------------------- */
phStatus_t phalICode_Sw_Inventory(phalICode_Sw_DataParams_t * pDataParams, uint8_t bFlags, uint8_t bAfi, uint8_t * pMask,
    uint8_t bMaskBitLen, uint8_t * pDsfid, uint8_t * pUid);

phStatus_t phalICode_Sw_StayQuiet(phalICode_Sw_DataParams_t * pDataParams);





/* iCode Optional commands ----------------------------------------------------------------------------------------- */
phStatus_t phalICode_Sw_ReadSingleBlock(phalICode_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bBlockNo,
    uint8_t ** ppData, uint16_t * pDataLen);

phStatus_t phalICode_Sw_WriteSingleBlock(phalICode_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bBlockNo,
    uint8_t * pData, uint8_t bDataLen);

phStatus_t phalICode_Sw_LockBlock(phalICode_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bBlockNo);

phStatus_t phalICode_Sw_ReadMultipleBlocks(phalICode_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bBlockNo,
    uint8_t bNumBlocks, uint8_t * pData, uint16_t * pDataLen);

phStatus_t phalICode_Sw_Select(phalICode_Sw_DataParams_t * pDataParams);

phStatus_t phalICode_Sw_ResetToReady(phalICode_Sw_DataParams_t * pDataParams);

phStatus_t phalICode_Sw_WriteAFI(phalICode_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bAfi);

phStatus_t phalICode_Sw_LockAFI(phalICode_Sw_DataParams_t * pDataParams, uint8_t bOption);

phStatus_t phalICode_Sw_WriteDSFID(phalICode_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bDsfid);

phStatus_t phalICode_Sw_LockDSFID(phalICode_Sw_DataParams_t * pDataParams, uint8_t bOption);

phStatus_t phalICode_Sw_GetSystemInformation(phalICode_Sw_DataParams_t * pDataParams, uint8_t ** ppSystemInfo,
    uint16_t * pSystemInfoLen);

phStatus_t phalICode_Sw_GetMultipleBlockSecurityStatus(phalICode_Sw_DataParams_t * pDataParams, uint8_t bBlockNo,
    uint8_t bNoOfBlocks, uint8_t * pStatus, uint16_t * pStatusLen);

phStatus_t phalICode_Sw_FastReadMultipleBlocks(phalICode_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bBlockNo,
    uint8_t bNumBlocks, uint8_t * pData, uint16_t * pDataLen);

phStatus_t phalICode_Sw_ExtendedReadSingleBlock(phalICode_Sw_DataParams_t * pDataParams, uint8_t bOption, uint16_t wBlockNo,
    uint8_t ** ppData, uint16_t * pDataLen);

phStatus_t phalICode_Sw_ExtendedWriteSingleBlock(phalICode_Sw_DataParams_t * pDataParams, uint8_t bOption, uint16_t wBlockNo,
    uint8_t * pData, uint8_t bDataLen);

phStatus_t phalICode_Sw_ExtendedLockBlock(phalICode_Sw_DataParams_t * pDataParams, uint8_t bOption, uint16_t wBlockNo);

phStatus_t phalICode_Sw_ExtendedReadMultipleBlocks(phalICode_Sw_DataParams_t * pDataParams, uint8_t bOption, uint16_t wBlockNo,
    uint16_t wNumBlocks, uint8_t * pData, uint16_t * pDataLen);

#ifdef NXPBUILD__PH_CRYPTOSYM
phStatus_t phalICode_Sw_AuthenticateTAM(phalICode_Sw_DataParams_t * pDataParams, uint16_t wOption, uint8_t bAuthType, uint8_t bKeyNo,
    uint8_t bKeyVer, uint8_t bKeyID_CertNum, uint8_t * pDivInput, uint8_t bDivLen, uint8_t * pChallenge, uint16_t wChallengeLen,
    uint8_t * pAddInfo, uint16_t wAddInfoLen, uint8_t ** ppResponse, uint16_t * pRespLen);

phStatus_t phalICode_Sw_AuthenticateTAM1(phalICode_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bKeyNo, uint8_t bKeyVer,
    uint8_t bKeyNoCard);

phStatus_t phalICode_Sw_AuthenticateMAM(phalICode_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bKeyNo, uint8_t bKeyVer,
    uint8_t bKeyNoCard, uint8_t bPurposeMAM2);
#endif /* NXPBUILD__PH_CRYPTOSYM */


#ifdef NXPBUILD__PH_CRYPTOSYM
phStatus_t phalICode_Sw_Challenge(phalICode_Sw_DataParams_t * pDataParams, uint16_t wOption, uint8_t bChallengeType, uint8_t bKeyID_CertNum,
    uint8_t * pChallenge, uint16_t wChallengeLen);

phStatus_t phalICode_Sw_ReadBuffer(phalICode_Sw_DataParams_t * pDataParams, uint8_t bVerify, uint8_t bKeyNo, uint8_t bKeyVer,
    uint8_t ** ppResponse, uint16_t * pRespLen);
#endif /* NXPBUILD__PH_CRYPTOSYM */

phStatus_t phalICode_Sw_ExtendedGetSystemInformation(phalICode_Sw_DataParams_t * pDataParams, uint8_t bInfoParams, uint8_t ** ppSystemInfo,
    uint16_t * pSystemInfoLen);

phStatus_t phalICode_Sw_ExtendedGetMultipleBlockSecurityStatus(phalICode_Sw_DataParams_t * pDataParams, uint16_t wBlockNo,
    uint16_t wNoOfBlocks, uint8_t * pStatus, uint16_t * pStatusLen);

phStatus_t phalICode_Sw_ExtendedFastReadMultipleBlocks(phalICode_Sw_DataParams_t * pDataParams, uint8_t bOption, uint16_t wBlockNo,
    uint16_t wNumBlocks, uint8_t * pData, uint16_t * pDataLen);





/* iCode Custom commands ------------------------------------------------------------------------------------------- */
phStatus_t phalICode_Sw_InventoryRead(phalICode_Sw_DataParams_t * pDataParams, uint8_t bFlags, uint8_t bAfi, uint8_t * pMask,
    uint8_t bMaskBitLen, uint8_t bBlockNo, uint8_t bNoOfBlocks, uint8_t * pUid, uint8_t * pUidLen, uint8_t * pData,
    uint16_t * pDataLen);

phStatus_t phalICode_Sw_InventoryReadExtended(phalICode_Sw_DataParams_t * pDataParams, uint8_t bFlags, uint8_t bAfi, uint8_t * pMask,
    uint8_t bMaskBitLen, uint8_t bExtendedOptions, uint8_t * pCID, uint8_t bBlockNo, uint8_t bNoOfBlocks, uint8_t * pCDIDOut,
    uint8_t * pUid, uint8_t * pUidLen, uint8_t * pData, uint16_t * pDataLen);

phStatus_t phalICode_Sw_FastInventoryRead(phalICode_Sw_DataParams_t * pDataParams, uint8_t bFlags, uint8_t bAfi, uint8_t * pMask,
    uint8_t bMaskBitLen, uint8_t bBlockNo, uint8_t bNoOfBlocks, uint8_t * pUid, uint8_t * pUidLen, uint8_t * pData,
    uint16_t * pDataLen);

phStatus_t phalICode_Sw_FastInventoryReadExtended(phalICode_Sw_DataParams_t * pDataParams, uint8_t bFlags, uint8_t bAfi, uint8_t * pMask,
    uint8_t bMaskBitLen, uint8_t bExtendedOptions, uint8_t * pCID, uint8_t bBlockNo, uint8_t bNoOfBlocks, uint8_t * pCDIDOut,
    uint8_t * pUid, uint8_t * pUidLen, uint8_t * pData, uint16_t * pDataLen);

phStatus_t phalICode_Sw_SetEAS(phalICode_Sw_DataParams_t * pDataParams, uint8_t bOption);

phStatus_t phalICode_Sw_ResetEAS(phalICode_Sw_DataParams_t * pDataParams, uint8_t bOption);

phStatus_t phalICode_Sw_LockEAS(phalICode_Sw_DataParams_t * pDataParams, uint8_t bOption);

phStatus_t phalICode_Sw_EASAlarm(phalICode_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t * pEasIdValue, uint8_t bEasIdMaskLen,
    uint8_t ** ppEas, uint16_t * pEasLen);

phStatus_t phalICode_Sw_PasswordProtectEAS(phalICode_Sw_DataParams_t * pDataParams);

phStatus_t phalICode_Sw_PasswordProtectAFI(phalICode_Sw_DataParams_t * pDataParams);

phStatus_t phalICode_Sw_WriteEAS_ID(phalICode_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t * pEasIdValue);

phStatus_t phalICode_Sw_ReadEPC(phalICode_Sw_DataParams_t * pDataParams, uint8_t ** ppEpc, uint16_t * pEpcLen);

phStatus_t phalICode_Sw_GetNXPSystemInformation(phalICode_Sw_DataParams_t * pDataParams, uint8_t ** ppSystemInfo, uint16_t * pSystemInfoLen);

phStatus_t phalICode_Sw_InventoryPageRead(phalICode_Sw_DataParams_t * pDataParams, uint8_t bFlags, uint8_t bAfi, uint8_t * pMask,
    uint8_t bMaskBitLen, uint8_t bPageNo, uint8_t bNoOfPages, uint8_t ** ppUid, uint8_t * pUidLen, uint8_t ** ppData, uint16_t * pDataLen);

phStatus_t phalICode_Sw_FastInventoryPageRead(phalICode_Sw_DataParams_t * pDataParams, uint8_t bFlags, uint8_t bAfi, uint8_t * pMask,
    uint8_t bMaskBitLen, uint8_t bPageNo, uint8_t bNoOfPages, uint8_t ** ppUid, uint8_t * pUidLen, uint8_t ** ppData, uint16_t * pDataLen);

phStatus_t phalICode_Sw_GetRandomNumber(phalICode_Sw_DataParams_t * pDataParams, uint8_t ** ppRnd, uint16_t * pRndLen);

phStatus_t phalICode_Sw_SetPassword(phalICode_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bPwdIdentifier, uint8_t * pXorPwd);

phStatus_t phalICode_Sw_WritePassword(phalICode_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bPwdIdentifier, uint8_t * pPwd);

phStatus_t phalICode_Sw_LockPassword(phalICode_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bPwdIdentifier);

phStatus_t phalICode_Sw_ProtectPage(phalICode_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bPPAdd_PageNo, uint8_t bProtectionStatus);

phStatus_t phalICode_Sw_LockPageProtectionCondition(phalICode_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bPageNo);

phStatus_t phalICode_Sw_GetMultipleBlockProtectionStatus(phalICode_Sw_DataParams_t * pDataParams, uint8_t bBlockNo, uint8_t bNoOfBlocks,
        uint8_t * pProtectionStates, uint16_t * pNumReceivedStates);

phStatus_t phalICode_Sw_Destroy(phalICode_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t * pXorPwd);

phStatus_t phalICode_Sw_EnablePrivacy(phalICode_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t * pXorPwd);

phStatus_t phalICode_Sw_64BitPasswordProtection(phalICode_Sw_DataParams_t * pDataParams, uint8_t bOption);

phStatus_t phalICode_Sw_StayQuietPersistent(phalICode_Sw_DataParams_t * pDataParams);

phStatus_t phalICode_Sw_ReadSignature(phalICode_Sw_DataParams_t * pDataParams, uint8_t ** ppSign, uint16_t * pSignLen);

phStatus_t phalICode_Sw_ReadConfig(phalICode_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bBlockAddr, uint8_t bNoOfBlocks,
    uint8_t ** ppData, uint16_t * pDataLen);

phStatus_t phalICode_Sw_WriteConfig(phalICode_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bBlockAddr, uint8_t * pData);

phStatus_t phalICode_Sw_PickRandomID(phalICode_Sw_DataParams_t * pDataParams);

phStatus_t phalICode_Sw_ReadTT(phalICode_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t ** ppResponse, uint16_t * pRspLen);

phStatus_t phalICode_Sw_ParameterRequest(phalICode_Sw_DataParams_t * pDataParams, uint8_t * pBitRate, uint8_t * pTiming);

phStatus_t phalICode_Sw_ParameterSelect(phalICode_Sw_DataParams_t * pDataParams, uint8_t bBitRate, uint8_t bTiming);

phStatus_t phalICode_Sw_ReadSRAM(phalICode_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bBlockNo, uint8_t bNumBlocks,
    uint8_t * pData, uint16_t * pDataLen);

phStatus_t phalICode_Sw_WriteSRAM(phalICode_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bBlockNo, uint8_t bNumBlocks,
    uint8_t * pData, uint16_t wDataLen);

phStatus_t phalICode_Sw_I2CMRead (phalICode_Sw_DataParams_t * pDataParams, uint8_t bI2CParam, uint16_t wDataLen, uint8_t * pData);

phStatus_t phalICode_Sw_I2CMWrite (phalICode_Sw_DataParams_t * pDataParams, uint8_t bI2CParam, uint8_t * pData, uint16_t wDataLen);






/* iCode Utility commands ------------------------------------------------------------------------------------------ */
phStatus_t phalICode_Sw_GetSerialNo(phalICode_Sw_DataParams_t * pDataParams, uint8_t ** ppUid, uint16_t * pUidLen);

phStatus_t phalICode_Sw_SetSerialNo(phalICode_Sw_DataParams_t * pDataParams, uint8_t * pUid, uint8_t bUidLen);

phStatus_t phalICode_Sw_GetConfig(phalICode_Sw_DataParams_t * pDataParams, uint16_t wConfig, uint16_t * pValue);

phStatus_t phalICode_Sw_SetConfig(phalICode_Sw_DataParams_t * pDataParams, uint16_t wConfig, uint16_t wValue);

phStatus_t phalICode_Sw_GetTagType(phalICode_Sw_DataParams_t * pDataParams, uint16_t * pTagType);

#endif /* NXPBUILD__PHAL_ICODE_SW */
#endif /* PHALICODE_SW_H */
