/*
 * Copyright 2013, 2017, 2019 - 2020, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */


#ifndef PHALMFDF_SW_H
#define PHALMFDF_SW_H

/* MIFARE DESFire security related commands. ----------------------------------------------------------------------------------------- */

phStatus_t phalMfdf_Sw_GetKeySettings(phalMfdf_Sw_DataParams_t * pDataParams, uint8_t * pResponse);


phStatus_t phalMfdf_Sw_GetKeyVersion(phalMfdf_Sw_DataParams_t * pDataParams, uint8_t bKeyNo, uint8_t * pResponse);




/* MIFARE DESFire PICC level commands. ----------------------------------------------------------------------------------------------- */
phStatus_t phalMfdf_Sw_CreateApplication(phalMfdf_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t * pAid, uint8_t bKeySettings1,
	uint8_t bKeySettings2, uint8_t * pISOFileId, uint8_t * pISODFName, uint8_t bISODFNameLen);

phStatus_t phalMfdf_Sw_DeleteApplication(phalMfdf_Sw_DataParams_t * pDataParams, uint8_t * pAppId);

phStatus_t phalMfdf_Sw_GetApplicationIDs(phalMfdf_Sw_DataParams_t * pDataParams, uint8_t * pAidBuff, uint8_t * pNumAIDs);

phStatus_t phalMfdf_Sw_GetDFNames(phalMfdf_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t * pDFBuffer, uint8_t * pDFInfoLen);

phStatus_t phalMfdf_Sw_SelectApplication(phalMfdf_Sw_DataParams_t * pDataParams, uint8_t * pAppId);


phStatus_t phalMfdf_Sw_GetVersion(phalMfdf_Sw_DataParams_t * pDataParams, uint8_t * pVerInfo);

phStatus_t phalMfdf_Sw_FreeMem(phalMfdf_Sw_DataParams_t * pDataParams, uint8_t * pMemInfo);

phStatus_t phalMfdf_Sw_SetConfiguration(phalMfdf_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t * pData, uint8_t bDataLen);

phStatus_t phalMfdf_Sw_GetCardUID(phalMfdf_Sw_DataParams_t * pDataParams, uint8_t * pUid);




/* MIFARE DESFire Application level commands. ---------------------------------------------------------------------------------------- */
phStatus_t phalMfdf_Sw_GetFileIDs(phalMfdf_Sw_DataParams_t * pDataParams, uint8_t * pFid, uint8_t * pNumFIDs);

phStatus_t phalMfdf_Sw_GetISOFileIDs(phalMfdf_Sw_DataParams_t * pDataParams, uint8_t * pFidBuffer, uint8_t * pNumFIDs);

phStatus_t phalMfdf_Sw_GetFileSettings(phalMfdf_Sw_DataParams_t * pDataParams, uint8_t bFileNo, uint8_t * pFSBuffer, uint8_t * pBufferLen);

phStatus_t phalMfdf_Sw_ChangeFileSettings(phalMfdf_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bFileNo, uint8_t bCommSett, uint8_t * pAccessRights);

phStatus_t phalMfdf_Sw_CreateStdDataFile(phalMfdf_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bFileNo, uint8_t  * pISOFileId, uint8_t bCommSett,
	uint8_t * pAccessRights, uint8_t * pFileSize);

phStatus_t phalMfdf_Sw_CreateBackupDataFile(phalMfdf_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bFileNo, uint8_t *pISOFileId, uint8_t bCommSett,
	uint8_t * pAccessRights, uint8_t * pFileSize);

phStatus_t phalMfdf_Sw_CreateValueFile(phalMfdf_Sw_DataParams_t * pDataParams, uint8_t bFileNo, uint8_t bCommSett, uint8_t * pAccessRights, uint8_t * pLowerLmit,
	uint8_t * pUpperLmit, uint8_t * pValue, uint8_t bLimitedCredit);

phStatus_t phalMfdf_Sw_CreateLinearRecordFile(phalMfdf_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t  bFileNo, uint8_t  *pIsoFileId, uint8_t bCommSett,
	uint8_t * pAccessRights, uint8_t * pRecordSize, uint8_t * pMaxNoOfRec);

phStatus_t phalMfdf_Sw_CreateCyclicRecordFile(phalMfdf_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t  bFileNo, uint8_t  *pIsoFileId, uint8_t bCommSett,
	uint8_t * pAccessRights, uint8_t * pRecordSize, uint8_t * pMaxNoOfRec);

phStatus_t phalMfdf_Sw_DeleteFile(phalMfdf_Sw_DataParams_t * pDataParams, uint8_t bFileNo);




/* MIFARE DESFire Data Manipulation commands. ---------------------------------------------------------------------------------------- */
phStatus_t phalMfdf_Sw_ReadData(phalMfdf_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bFileNo, uint8_t * pOffset, uint8_t * pLength, uint8_t ** ppRxdata,
	uint16_t * pRxdataLen);

phStatus_t phalMfdf_Sw_WriteData(phalMfdf_Sw_DataParams_t * pDataParams, uint8_t bCommOption, uint8_t bFileNo, uint8_t * pOffset, uint8_t * pData, uint8_t * pDataLen);

phStatus_t phalMfdf_Sw_GetValue(phalMfdf_Sw_DataParams_t * pDataParams, uint8_t bCommOption, uint8_t bFileNo, uint8_t * pValue);

phStatus_t phalMfdf_Sw_Credit(phalMfdf_Sw_DataParams_t * pDataParams, uint8_t bCommOption, uint8_t bFileNo, uint8_t * pValue);

phStatus_t phalMfdf_Sw_Debit(phalMfdf_Sw_DataParams_t * pDataParams, uint8_t bCommOption, uint8_t bFileNo, uint8_t * pValue);

phStatus_t phalMfdf_Sw_LimitedCredit(phalMfdf_Sw_DataParams_t * pDataParams, uint8_t bCommOption, uint8_t bFileNo, uint8_t * pValue);

phStatus_t phalMfdf_Sw_WriteRecord(phalMfdf_Sw_DataParams_t * pDataParams, uint8_t bCommOption, uint8_t bFileNo, uint8_t * pOffset, uint8_t * pData,
	uint8_t * pDataLen);

phStatus_t phalMfdf_Sw_ReadRecords(phalMfdf_Sw_DataParams_t * pDataParams, uint8_t bCommOption, uint8_t bFileNo, uint8_t * pOffset, uint8_t * pNumRec,
	uint8_t * pRecSize, uint8_t ** ppRxdata, uint16_t * pRxdataLen);

phStatus_t phalMfdf_Sw_ClearRecordFile(phalMfdf_Sw_DataParams_t * pDataParams, uint8_t bFileNo);

phStatus_t phalMfdf_Sw_CommitTransaction(phalMfdf_Sw_DataParams_t * pDataParams);

phStatus_t phalMfdf_Sw_AbortTransaction(phalMfdf_Sw_DataParams_t * pDataParams);




/* MIFARE DESFire ISO7816 commands. -------------------------------------------------------------------------------------------------- */
phStatus_t phalMfdf_Sw_IsoSelectFile(phalMfdf_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bSelector, uint8_t * pFid, uint8_t * pDFname,
	uint8_t bDFnameLen, uint8_t ** ppRecv, uint16_t * pwRxlen);

phStatus_t phalMfdf_Sw_IsoReadBinary(phalMfdf_Sw_DataParams_t * pDataParams, uint16_t wOption, uint8_t bOffset, uint8_t bSfid, uint8_t bBytesToRead,
	uint8_t ** ppRxBuffer, uint16_t * pBytesRead);

phStatus_t phalMfdf_Sw_IsoUpdateBinary(phalMfdf_Sw_DataParams_t * pDataParams, uint8_t bOffset, uint8_t bSfid, uint8_t * pData, uint8_t bDataLen);

phStatus_t phalMfdf_Sw_IsoReadRecords(phalMfdf_Sw_DataParams_t * pDataParams, uint16_t wOption, uint8_t bRecNo, uint8_t bReadAllFromP1, uint8_t bSfid,
	uint8_t bBytesToRead, uint8_t ** ppRxBuffer, uint16_t * pBytesRead);

phStatus_t phalMfdf_Sw_IsoAppendRecord(phalMfdf_Sw_DataParams_t * pDataParams, uint8_t bSfid, uint8_t * pData, uint8_t bDataLen);

phStatus_t phalMfdf_Sw_IsoGetChallenge(phalMfdf_Sw_DataParams_t * pDataParams, uint16_t wKeyNo, uint16_t wKeyVer, uint8_t bLe, uint8_t * pRPICC1);





/* MIFARE DESFire Miscellaneous functions. ------------------------------------------------------------------------------------------- */
phStatus_t phalMfdf_Sw_GetConfig(phalMfdf_Sw_DataParams_t * pDataParams, uint16_t wConfig, uint16_t * pValue);

phStatus_t phalMfdf_Sw_SetConfig(phalMfdf_Sw_DataParams_t *pDataParams, uint16_t wConfig, uint16_t wValue);

phStatus_t phalMfdf_Sw_ResetAuthStatus(phalMfdf_Sw_DataParams_t *pDataParams);

#endif /* PHALMFDF_SW_H */
