/*
 * Copyright 2020, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Internal functions of Software implementation of MIFARE DESFIRE EVx application layer.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHALMFDFEVX_INT_H
#define PHALMFDFEVX_INT_H

#include <ph_Status.h>
#include <phalMfdfEVx.h>

/** \addtogroup ph_Private
 * @{
 */

/** \name MIFARE DESFire Native Commands */
/** @{ */
#define PHAL_MFDFEVX_CMD_INVALID                                                0xFF    /**< INVALID Command code. */
#define PHAL_MFDFEVX_CMD_AUTHENTICATE                                           0x0A    /**< MFDFEVx Authenticate command. */
#define PHAL_MFDFEVX_CMD_AUTHENTICATE_ISO                                       0x1A    /**< MFDFEVx Authenticate ISO command. */
#define PHAL_MFDFEVX_CMD_AUTHENTICATE_AES                                       0xAA    /**< MFDFEVx Authenticate AES command. */
#define PHAL_MFDFEVX_CMD_AUTHENTICATE_EV2_FIRST                                 0x71    /**< MFDFEVx Authenticate EV2 First command. */
#define PHAL_MFDFEVX_CMD_AUTHENTICATE_EV2_NON_FIRST                             0x77    /**< MFDFEVx Authenticate EV2 Non First command. */
#define PHAL_MFDFEVX_CMD_AUTHENTICATE_PART2                                     0xAF    /**< MFDFEVx Authentication second part; 0xAF. */
#define PHAL_MFDFEVX_CMD_CHANGE_KEY_SETTINGS                                    0x54    /**< MFDFEVx Change key settings command. */
#define PHAL_MFDFEVX_CMD_GET_KEY_SETTINGS                                       0x45    /**< MFDFEVx Get Key Settings command.  */
#define PHAL_MFDFEVX_CMD_CHANGE_KEY                                             0xC4    /**< MFDFEVx Change key command. */
#define PHAL_MFDFEVX_CMD_CHANGE_KEY_EV2                                         0xC6    /**< MFDFEVx Change key stored on PICC command. */
#define PHAL_MFDFEVX_CMD_GET_KEY_VERSION                                        0x64    /**< MFDFEVx Get Key Version. */
#define PHAL_MFDFEVX_CMD_INITIALIZE_KEY_SET                                     0x56    /**< MFDFEVx Initialize a key set command. */
#define PHAL_MFDFEVX_CMD_FINALIZE_KEY_SET                                       0x57    /**< MFDFEVx Finalize a key set command. */
#define PHAL_MFDFEVX_CMD_ROLL_KEY_SET                                           0x55    /**< MFDFEVx Roll to a new key set command. */
#define PHAL_MFDFEVX_CMD_CREATE_APPLN                                           0xCA    /**< MFDFEVx Create Application command. */
#define PHAL_MFDFEVX_CMD_CREATE_DELEGATED_APPLN                                 0xC9    /**< MFDFEVx Create Delegated Application command. */
#define PHAL_MFDFEVX_CMD_DELETE_APPLN                                           0xDA    /**< MFDFEVx Delete Application command. */
#define PHAL_MFDFEVX_CMD_GET_APPLN_IDS                                          0x6A    /**< MFDFEVx Get Application Ids command. */
#define PHAL_MFDFEVX_CMD_GET_DF_NAMES                                           0x6D    /**< MFDFEVx Get Dedicated Fine names command. */
#define PHAL_MFDFEVX_CMD_GET_DELEGATED_INFO                                     0x69    /**< MFDFEVx Get Delegated info command. */
#define PHAL_MFDFEVX_CMD_SELECT_APPLN                                           0x5A    /**< MFDFEVx Select Application command. */
#define PHAL_MFDFEVX_CMD_FORMAT                                                 0xFC    /**< MFDFEVx Format PICC command. */
#define PHAL_MFDFEVX_CMD_GET_VERSION                                            0x60    /**< MFDFEVx Get Version command. */
#define PHAL_MFDFEVX_CMD_FREE_MEM                                               0x6E    /**< MFDFEVx Free Memory command. */
#define PHAL_MFDFEVX_CMD_SET_CONFIG                                             0x5C    /**< MFDFEVx Set Configuration command. */
#define PHAL_MFDFEVX_CMD_GET_CARD_UID                                           0x51    /**< MFDFEVx Get Card UID command. */
#define PHAL_MFDFEVX_CMD_GET_FILE_IDS                                           0x6F    /**< MFDFEVx Get File IDs command. */
#define PHAL_MFDFEVX_CMD_GET_ISO_FILE_IDS                                       0x61    /**< MFDFEVx Get ISO File IDs command. */
#define PHAL_MFDFEVX_CMD_GET_FILE_SETTINGS                                      0xF5    /**< MFDFEVx Get File settings command. */
#define PHAL_MFDFEVX_CMD_GET_FILE_COUNTERS                                      0xF6    /**< MFDFEVx Get File Counters command. */
#define PHAL_MFDFEVX_CMD_CHANGE_FILE_SETTINGS                                   0x5F    /**< MFDFEVx Change file settings command. */
#define PHAL_MFDFEVX_CMD_CREATE_STD_DATAFILE                                    0xCD    /**< MFDFEVx Create Standard data file command. */
#define PHAL_MFDFEVX_CMD_CREATE_BKUP_DATAFILE                                   0xCB    /**< MFDFEVx Create Backup data file command. */
#define PHAL_MFDFEVX_CMD_CREATE_VALUE_FILE                                      0xCC    /**< MFDFEVx Create Value File command. */
#define PHAL_MFDFEVX_CMD_CREATE_LINEAR_RECFILE                                  0xC1    /**< MFDFEVx Create Linear record file command. */
#define PHAL_MFDFEVX_CMD_CREATE_CYCLIC_RECFILE                                  0xC0    /**< MFDFEVx Create Cyclic record file command. */
#define PHAL_MFDFEVX_CMD_CREATE_TRANSTN_MACFILE                                 0xCE    /**< MFDFEVx Create Transaction MAC file command. */
#define PHAL_MFDFEVX_CMD_DELETE_FILE                                            0xDF    /**< MFDFEVx Delete File command. */
#define PHAL_MFDFEVX_CMD_READ_DATA                                              0xBD    /**< MFDFEVx Read Data command. */
#define PHAL_MFDFEVX_CMD_READ_DATA_ISO                                          0xAD    /**< MFDFEVx Read Data command using ISO chaining. */
#define PHAL_MFDFEVX_CMD_WRITE_DATA                                             0x3D    /**< MFDFEVx Write data command. */
#define PHAL_MFDFEVX_CMD_WRITE_DATA_ISO                                         0x8D    /**< MFDFEVx Write data command using ISO chaining. */
#define PHAL_MFDFEVX_CMD_GET_VALUE                                              0x6C    /**< MFDFEVx Get Value command. */
#define PHAL_MFDFEVX_CMD_CREDIT                                                 0x0C    /**< MFDFEVx Credit command. */
#define PHAL_MFDFEVX_CMD_DEBIT                                                  0xDC    /**< MFDFEVx Debit command. */
#define PHAL_MFDFEVX_CMD_LIMITED_CREDIT                                         0x1C    /**< MFDFEVx Limited Credit command. */
#define PHAL_MFDFEVX_CMD_WRITE_RECORD                                           0x3B    /**< MFDFEVx Write Record command. */
#define PHAL_MFDFEVX_CMD_WRITE_RECORD_ISO                                       0x8B    /**< MFDFEVx Write Record command using ISO chaining. */
#define PHAL_MFDFEVX_CMD_UPDATE_RECORD                                          0xDB    /**< MFDFEVx Update Record command. */
#define PHAL_MFDFEVX_CMD_UPDATE_RECORD_ISO                                      0xBA    /**< MFDFEVx Update Record command using ISO chaining. */
#define PHAL_MFDFEVX_CMD_READ_RECORDS                                           0xBB    /**< MFDFEVx Read Records command. */
#define PHAL_MFDFEVX_CMD_READ_RECORDS_ISO                                       0xAB    /**< MFDFEVx Read Records command using ISO chaining. */
#define PHAL_MFDFEVX_CMD_UPDATE_RECORDS                                         0xF0    /**< MFDFEVx Update Records command. */
#define PHAL_MFDFEVX_CMD_CLEAR_RECORD_FILE                                      0xEB    /**< MFDFEVx Clear records file command. */
#define PHAL_MFDFEVX_CMD_COMMIT_TXN                                             0xC7    /**< MFDFEVx Commit transaction command. */
#define PHAL_MFDFEVX_CMD_ABORT_TXN                                              0xA7    /**< MFDFEVx Abort transaction command. */
#define PHAL_MFDFEVX_CMD_COMMIT_READER_ID                                       0xC8    /**< MFDFEVx Commit Reader ID command. */
#define PHAL_MFDFEVX_CMD_READ_SIG                                               0x3C    /**< MFDFEVx Verify read signature command. */
#define PHAL_MFDFEVX_CMD_FORMAT_PICC                                            0xFC    /**< MFDFEVx Format PICC command. */
#define PHAL_MFDFEVX_CMD_CLEAR_RECORDS_FILE                                     0xEB    /**< MFDFEVx Clear records file command. */
#define PHAL_MFDFEVX_CMD_AUTH_PDC                                               0x7C    /**< MFDFEVx Post Delivery Command. */
#define PHAL_MFDFEVX_CMD_AUTH2                                                  0x72    /**< MFDFEVx Authenticate command (part 2). */
#define PHAL_MFDFEVX_CMD_CREATE_MFC_MAPPING                                     0xCF    /**< MFDFEVx CreateMFCMapping. */
#define PHAL_MFDFEVX_CMD_RESTORE_TRANSFER                                       0xB1    /**< MFDFEVx RestoreTransfer. */
#define PHAL_MFDFEVX_CMD_RESTORE_SHADOW                                         0xB5    /**< MFDFEVx RestoreShadow. */
#define PHAL_MFDFEVX_CMD_RESTRICT_MFC_UPDATE                                    0xBF    /**< MFDFEVx RestrictMFCUpdate. */
/** @} */

/** \name MIFARE DESFire Response Codes */
/** @{ */
#define PHAL_MFDFEVX_RESP_OPERATION_OK                                          0x00U   /**< MFDFEVx Response - Successful operation. */
#define PHAL_MFDFEVX_RESP_OPERATION_OK_LIM                                      0x01U   /**< MFDFEVx Response - Successful operation with limited functionality. */
#define PHAL_MFDFEVX_RESP_OK                                                    0x90U   /**< MFDFEVx Response - Successful operation. */
#define PHAL_MFDFEVX_RESP_NO_CHANGES                                            0x0CU   /**< MFDFEVx Response - No changes done to backup files. */
#define PHAL_MFDFEVX_RESP_ERR_NOT_SUP                                           0x0DU   /**< MFDFEVx Not Supported Error. */
#define PHAL_MFDFEVX_RESP_ERR_OUT_OF_EEPROM_ERROR                               0x0EU   /**< MFDFEVx Response - Insufficient NV-Memory. */
#define PHAL_MFDFEVX_RESP_ILLEGAL_COMMAND_CODE                                  0x1CU   /**< MFDFEVx command code not supported. */
#define PHAL_MFDFEVX_RESP_ERR_INTEGRITY_ERROR                                   0x1EU   /**< MFDFEVx CRC or MAC does not match data padding bytes not valid. */
#define PHAL_MFDFEVX_RESP_NO_SUCH_KEY                                           0x40U   /**< MFDFEVx Invalid key number specified. */
#define PHAL_MFDFEVX_RESP_CHAINING                                              0x71U   /**< MFDFEVx ISO Chaining Status. */
#define PHAL_MFDFEVX_RESP_ERR_LENGTH_ERROR                                      0x7EU   /**< MFDFEVx Length of command string invalid. */
#define PHAL_MFDFEVX_RESP_PERMISSION_DENIED                                     0x9DU   /**< MFDFEVx Current configuration/status does not allow the requested command. */
#define PHAL_MFDFEVX_RESP_ERR_PARAMETER_ERROR                                   0x9EU   /**< MFDFEVx Value of params invalid. */
#define PHAL_MFDFEVX_RESP_APPLICATION_NOT_FOUND                                 0xA0U   /**< MFDFEVx Requested AID not found on PICC. */
#define PHAL_MFDFEVX_RESP_ERR_APPL_INTEGRITY_ERROR                              0xA1U   /**< MFDFEVx Unrecoverable error within application, appln will be disabled. */
#define PHAL_MFDFEVX_RESP_ERR_AUTHENTICATION_ERROR                              0xAEU   /**< MFDFEVx Current authentication status does not allow the requested command. */
#define PHAL_MFDFEVX_RESP_ADDITIONAL_FRAME                                      0xAFU   /**< MFDFEVx Additional data frame is expected to be sent. */
#define PHAL_MFDFEVX_RESP_ERR_BOUNDARY_ERROR                                    0xBEU   /**< MFDFEVx Attempt to read/write data from/to beyond the files/record's limits. */
#define PHAL_MFDFEVX_RESP_ERR_PICC_INTEGRITY                                    0xC1U   /**< MFDFEVx Unrecoverable error within PICC. PICC will be disabled. */
#define PHAL_MFDFEVX_RESP_ERR_COMMAND_ABORTED                                   0xCAU   /**< MFDFEVx Previous command not fully completed. Not all frames were requested or provided by the PCD. */
#define PHAL_MFDFEVX_RESP_ERR_PIC_DISABLED                                      0xCDU   /**< MFDFEVx PICC was disabled by an unrecoverable error. */
#define PHAL_MFDFEVX_RESP_ERR_COUNT                                             0xCEU   /**< MFDFEVx Num. of applns limited to 28. No additional applications possible. */
#define PHAL_MFDFEVX_RESP_ERR_DUPLICATE                                         0xDEU   /**< MFDFEVx File/Application with same number already exists. */
#define PHAL_MFDFEVX_RESP_ERR_EEPROM                                            0xEEU   /**< MFDFEVx Could not complete NV-Write operation due to loss of power. */
#define PHAL_MFDFEVX_RESP_ERR_FILE_NOT_FOUND                                    0xF0U   /**< MFDFEVx Specified file number does not exist. */
#define PHAL_MFDFEVX_RESP_ERR_FILE_INTEGRITY                                    0xF1U   /**< MFDFEVx Unrecoverable error within file. File will be disabled. */
#define PHAL_MFDFEVX_RESP_ERR_AUTH_ERROR                                        0x06U   /**< MFDFEVx Authentication error. */
#define PHAL_MFDFEVX_RESP_ERR_CMD_OVERFLOW                                      0x07U   /**< MFDFEVx Too many commands in the session or transaction. */
#define PHAL_MFDFEVX_RESP_ERR_CMD_BNR                                           0x09U   /**< MFDFEVx Invalid Block number: not existing in the implementation or not valid to target with this command. */
#define PHAL_MFDFEVX_RESP_ERR_CMD_INVALID                                       0x0BU   /**< MFDFEVx Command is received in a state where this command is not supported, or a totally unknown command is received.*/
#define PHAL_MFDFEVX_RESP_ERR_CMD_ERR_FORMAT                                    0x0CU   /**< MFDFEVx Format of the command is not correct (e.g. too many or too few bytes). */
#define PHAL_MFDFEVX_RESP_ERR_CMD_GEN_FAILURE                                   0x0FU   /**< MFDFEVx Failure in the operation of the PD. */
/** @} */

/** \name ISO 7816 Instructions */
/** @{ */
#define PHAL_MFDFEVX_CMD_ISO7816_SELECT_FILE                                    0xA4    /**< ISO Select File. */
#define PHAL_MFDFEVX_CMD_ISO7816_READ_RECORDS                                   0xB2    /**< ISO Read records. */
#define PHAL_MFDFEVX_CMD_ISO7816_READ_BINARY                                    0xB0    /**< ISO Read Binary. */
#define PHAL_MFDFEVX_CMD_ISO7816_UPDATE_BINARY                                  0xD6    /**< ISO UPDATE Binary. */
#define PHAL_MFDFEVX_CMD_ISO7816_APPEND_RECORD                                  0xE2    /**< ISO Append record. */
#define PHAL_MFDFEVX_CMD_ISO7816_UPDATE_RECORD                                  0xD2    /**< ISO Update record. */
#define PHAL_MFDFEVX_CMD_ISO7816_GET_CHALLENGE                                  0x84    /**< ISO Get challenge. */
#define PHAL_MFDFEVX_CMD_ISO7816_EXT_AUTHENTICATE                               0x82    /**< ISO Ext. Authenticate. */
#define PHAL_MFDFEVX_CMD_ISO7816_INT_AUTHENTICATE                               0x88    /**< ISO Int. Authenticate. */
/** @} */

/** \name MIFARE DESFire specific defines */
/** @{ */
#define PHAL_MFDFEVX_MAXWRAPPEDAPDU_SIZE                                        0x37u   /**< Maximum size of wrapped APDU 55 bytes. */
#define PHAL_MFDFEVX_MAXDFAPDU_SIZE                                             0x3Cu   /**< Maximum size of DESFire APDU 60 bytes. */
#define PHAL_MFDFEVX_DFAPPID_SIZE                                               0x03u   /**< Size of MFDFEVx application Id. */
#define PHAL_MFDFEVX_DATA_BLOCK_SIZE                                            0x10u   /**< Data block size need for internal purposes. */
#define PHAL_MFDFEVX_MAX_FRAME_SIZE                                             0x40u   /**< Max size in a ISO 14443-4 frame. */
/** @} */

/** \name ISO 7816 DFEVx return Codes */
/** @{ */
#define PHAL_MFDFEVX_ISO7816_SUCCESS                                            0x9000U /**< Correct execution. */
#define PHAL_MFDFEVX_ISO7816_ERR_WRONG_LENGTH                                   0x6700U /**< Wrong length. */
#define PHAL_MFDFEVX_ISO7816_ERR_INVALID_APPLN                                  0x6A82U /**< Application / file not found. */
#define PHAL_MFDFEVX_ISO7816_ERR_WRONG_PARAMS                                   0x6A86U /**< Wrong parameters P1 and/or P2. */
#define PHAL_MFDFEVX_ISO7816_ERR_WRONG_LC                                       0x6A87U /**< LC inconsistent with P1/p2. */
#define PHAL_MFDFEVX_ISO7816_ERR_WRONG_LE                                       0x6C00U /**< Wrong Le. */
#define PHAL_MFDFEVX_ISO7816_ERR_NO_PRECISE_DIAGNOSTICS                         0x6F00U /**< No precise diagnostics. */
#define PHAL_MFDFEVX_ISO7816_ERR_EOF_REACHED                                    0x6282U /**< End of File reached. */
#define PHAL_MFDFEVX_ISO7816_ERR_FILE_ACCESS                                    0x6982U /**< File access not allowed. */
#define PHAL_MFDFEVX_ISO7816_ERR_FILE_EMPTY                                     0x6985U /**< File empty or access conditions not satisfied. */
#define PHAL_MFDFEVX_ISO7816_ERR_FILE_NOT_FOUND                                 0x6A82U /**< File not found. */
#define PHAL_MFDFEVX_ISO7816_ERR_MEMORY_FAILURE                                 0x6581U /**< Memory failure (unsuccessful update). */
#define PHAL_MFDFEVX_ISO7816_ERR_INCORRECT_PARAMS                               0x6B00U /**< Wrong parameter p1 or p2. READ RECORDS. */
#define PHAL_MFDFEVX_ISO7816_ERR_WRONG_CLA                                      0x6E00U /**< Wrong Class byte. */
#define PHAL_MFDFEVX_ISO7816_ERR_UNSUPPORTED_INS                                0x6D00U /**< Instruction not supported. */
#define PHAL_MFDFEVX_ISO7816_ERR_LIMITED_FUNCTIONALITY_INS                      0x6283U /**< Limited Functionality. */
/** @} */

#define PHAL_MFDFEVX_WRAP_HDR_LEN                                               0x05U   /**< Wrapped APDU header length */
#define PHAL_MFDFEVX_WRAPPEDAPDU_CLA                                            0x90U   /**< Wrapped APDU default class. */
#define PHAL_MFDFEVX_WRAPPEDAPDU_P1                                             0x00U   /**< Wrapped APDU default P1. */
#define PHAL_MFDFEVX_WRAPPEDAPDU_P2                                             0x00U   /**< Wrapped APDU default P2. */
#define PHAL_MFDFEVX_WRAPPEDAPDU_LE                                             0x00U   /**< Wrapped APDU default LE. */

#define PHAL_MFDFEVX_TRUNCATED_MAC_SIZE                                         8       /**< Size of the truncated MAC. */
#define PHAL_MFDFEVX_KEYSETVERSIONS                                             0x40U   /**< 6th bit KeyNo used to retrieve all KeySet versions. */
#define PHAL_MFDFEVX_ISO_CHAINING_MODE                                          0x04    /**< Option to enable ISO chaining. */
#define PHAL_MFDFEVX_DEFAULT_MODE                                               0x00    /**< Native Chaining. */
#define PHAL_MFDFEVX_PC_RND_LEN                                                 7       /**< Size of the Proximity Check Random numbers. */
#define PHAL_MFDFEVX_SIG_LENGTH                                                 0x38    /**< NXP Originality Signature length */
#define PHAL_MFDFEVX_DEFAULT_UID_LENGTH                                         0x07    /**< By default EVx card is configures as 7 byte UID */
#define PHAL_MFDFEVX_10B_UID_LENGTH                                             0x0C    /**< EVx can also be configured as 10 byte UID. */
#define PHAL_MFDFEVX_4B_UID_LENGTH                                              0x06    /**< EVx can also be configured as 4 byte UID. */
#define PHAL_MFDFEVX_DEF_VERSION_LENGTH                                         0x1C    /**< Version String is of 28 bytes by default(If its 7 Byte UID) */
#define PHAL_MFDFEVX_10B_VERSION_LENGTH                                         0x21    /**< Version String is of 30 bytes If its 10B Byte UID */
#define PHAL_MFDFEVX_4B_VERSION_LENGTH                                          0x1B    /**< Version String is of 27 bytes If its 4B Byte UID */
#define PHAL_MFDFEVX_ISO_CHAINING_MODE_MAPPED       (PHAL_MFDFEVX_ISO_CHAINING_MODE)    /**< Option to enable ISO chaining mapped for internal use. */

#define PHAL_MFDFEVX_ISO_7816_NO_LC_LE                                          0x00    /**< Check if LC=0 and Le=0 */
#define PHAL_MFDFEVX_ISO_7816_LC_SHORT_APDU                                     0x01    /**< Indicates LC=1 byte */
#define PHAL_MFDFEVX_ISO_7816_LC_EXT_APDU_3B                                    0x03    /**< Indicates LC=3 bytes */
#define PHAL_MFDFEVX_ISO_7816_LE_SHORT_APDU     PHAL_MFDFEVX_ISO_7816_LC_SHORT_APDU     /**< Indicates Le=1 byte */
#define PHAL_MFDFEVX_ISO_7816_LE_EXT_APDU_2B                                    0x02    /**< Indicates Le=2 bytes */
#define PHAL_MFDFEVX_ISO_7816_LE_EXT_APDU_3B    PHAL_MFDFEVX_ISO_7816_LC_EXT_APDU_3B    /**< Indicates Le=3 bytes */

/** \name Proximity Check return Codes */
/** @{ */
#define PHAL_MFDFEVX_RESP_NACK0                                                 0x00U   /*< MFDFEVx NACK 0 (in ISO14443-3 mode). */
#define PHAL_MFDFEVX_RESP_NACK1                                                 0x01U   /*< MFDFEVx NACK 1 (in ISO14443-3 mode). */
#define PHAL_MFDFEVX_RESP_NACK4                                                 0x04U   /*< MFDFEVx NACK 4 (in ISO14443-3 mode). */
#define PHAL_MFDFEVX_RESP_NACK5                                                 0x05U   /*< MFDFEVx NACK 5 (in ISO14443-3 mode). */
#define PHAL_MFDFEVX_RESP_ACK_ISO3                                              0x0AU   /*< MFDFEVx ACK (in ISO14443-3 mode). */
#define PHAL_MFDFEVX_RESP_ACK_ISO4                                              0x90U   /*< MFDFEVx ACK (in ISO14443-4 mode). */
#define PHAL_MFDFEVX_RESP_ERR_AUTH                                              0x06U   /*< MFDFEVx Authentication Error. */
#define PHAL_MFDFEVX_RESP_ERR_CMD_OVERFLOW                                      0x07U   /*< MFDFEVx Command Overflow Error. */
#define PHAL_MFDFEVX_RESP_ERR_MAC_PCD                                           0x08U   /*< MFDFEVx MAC Error. */
#define PHAL_MFDFEVX_RESP_ERR_BNR                                               0x09U   /*< MFDFEVx Block number Error. */
#define PHAL_MFDFEVX_RESP_ERR_EXT                                               0x0AU   /*< MFDFEVx Extension Error. */
#define PHAL_MFDFEVX_RESP_ERR_CMD_INVALID                                       0x0BU   /*< MFDFEVx Invalid Command Error. */
#define PHAL_MFDFEVX_RESP_ERR_FORMAT                                            0x0CU   /*< MFDFEVx Format Error. */
#define PHAL_MFDFEVX_RESP_ERR_GEN_FAILURE                                       0x0FU   /*< MFDFEVx Generic Error. */
/** @} */

/** \name Macros for SDM functionality */
/** @{ */
#define PHAL_MFDFEVX_PICC_DATA                                                  0x10U   /**< PICCDATA . */
#define PHAL_MFDFEVX_MAC_DATA                                                   0x08U   /**< MAC DATA. */
#define PHAL_MFDFEVX_SESSION_ENC                                                0x01U   /**< Option to perform generate the SDM session encryption keys. */
#define PHAL_MFDFEVX_SESSION_MAC                                                0x02U   /**< Option to perform generate the SDM session MAC keys. */
#define PHAL_MFDFEVX_PLAIN_PICCDATA_MIRRIORING                                  0xE0U   /**< Option to indicate the presence of VCUID or RdCtr in the data. */
#define PHAL_MFDFEVX_NO_PICCDATA_MIRRIORING                                     0xF0U   /**< Option to indicate the presence of Encrypted VCUID or RdCtr in the data. */
/** @} */

/* To avoid unused variable warnings. */
#define PHAL_MFDFEVX_UNUSED_VARIABLE(x)  {for( ( x ) = ( x ) ; ( x ) != ( x ) ; );}
#define PHAL_MFDFEVX_UNUSED_ARRAY(x)  {for( ( (x)[0] ) = ( (x)[0] ) ; ( (x)[0] ) != ( (x)[0] ) ; );}

phStatus_t phalMfdfEVx_ExchangeCmd(void * pDataParams, void * pPalMifareDataParams, uint8_t bWrappedMode, uint8_t * pCmd, uint16_t wCmdLen,
    uint8_t ** ppResponse, uint16_t * wRxlen);

phStatus_t phalMfdfEVx_Int_ComputeErrorResponse(void * pDataParams, uint16_t wStatus);

phStatus_t phalMfdfEVx_Int_Send7816Apdu(void * pDataParams, void * pPalMifareDataParams, uint8_t bOption, uint8_t bIns, uint8_t p1, uint8_t p2,
    uint32_t LC, uint8_t bExtendedLenApdu, uint8_t * pDataIn, uint32_t bLe, uint8_t ** pDataOut, uint16_t *pDataLen);

phStatus_t phalMfdfEVx_Int_ISOSelectFile(void * pDataParams, void * pPalMifareDataParams, uint8_t bOption, uint8_t * bCmdBuff, uint16_t wCmdLen,
    uint8_t bLc, uint8_t bExtendedLenApdu, uint8_t * pDataIn, uint8_t bLe, uint8_t ** ppDataOut, uint16_t *pDataLen);

phStatus_t phalMfdfEVx_Int_ISOUpdateBinary(void * pDataParams, void * pPalMifareDataParams, uint8_t bOption, uint8_t * bCmdBuff, uint16_t wCmdLen,
    uint32_t dwLc, uint8_t bExtendedLenApdu, uint8_t * pDataIn, uint8_t ** ppDataOut, uint16_t *pDataLen);

phStatus_t phalMfdfEVx_Int_ISOAppendRecord(void * pDataParams, void * pPalMifareDataParams, uint8_t bOption, uint8_t * bCmdBuff, uint16_t wCmdLen,
    uint32_t dwLc, uint8_t bExtendedLenApdu, uint8_t * pDataIn, uint8_t ** ppDataOut, uint16_t *pDataLen);

phStatus_t phalMfdfEVx_Int_ISOGetChallenge(void * pDataParams, void * pPalMifareDataParams, uint8_t bOption, uint8_t * bCmdBuff, uint16_t wCmdLen,
    uint8_t bLe, uint8_t bExtendedLenApdu, uint8_t ** ppDataOut, uint16_t *pDataLen);

phStatus_t phalMfdfEVx_Int_ISOExternalAuthenticate(void * pDataParams, void * pPalMifareDataParams, uint8_t bOption, uint8_t * bCmdBuff, uint16_t wCmdLen,
    uint8_t bLc, uint8_t bExtendedLenApdu, uint8_t * pDataIn, uint8_t ** ppDataOut, uint16_t *pDataLen);

phStatus_t phalMfdfEVx_Int_ISOInternalAuthenticate(void * pDataParams, void * pPalMifareDataParams, uint8_t bOption, uint8_t * bCmdBuff, uint16_t wCmdLen,
    uint8_t bLc, uint8_t bExtendedLenApdu, uint8_t * pDataIn, uint32_t dwLe, uint8_t ** ppDataOut, uint16_t *pDataLen);

phStatus_t phalMfdfEVx_Int_GetCmdCode(void * pDataParams, uint8_t * pCmdCode);

phStatus_t phalMfdfEVx_Int_SetCmdCode(void * pDataParams, uint8_t bCmdCode);
/** @} */

#endif /* PHALMFDFEVX_INT_H */
