/*
 * Copyright 2013, 2017 - 2020, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Software MIFARE Plus(R) Application Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHALMFP_SW_H
#define PHALMFP_SW_H

#include <ph_Status.h>

phStatus_t phalMfp_Sw_WritePerso(phalMfp_Sw_DataParams_t * pDataParams, uint8_t bLayer4Comm, uint16_t wBlockNr, uint8_t * pValue);

phStatus_t phalMfp_Sw_CommitPerso(phalMfp_Sw_DataParams_t * pDataParams, uint8_t bLayer4Comm);

phStatus_t phalMfp_Sw_AuthenticateClassicSL2(phalMfp_Sw_DataParams_t * pDataParams, uint8_t bBlockNo, uint8_t bKeyType, uint16_t wKeyNumber,
	uint16_t wKeyVersion, uint8_t * pUid, uint8_t bUidLength);




phStatus_t phalMfp_Sw_MultiBlockWrite(phalMfp_Sw_DataParams_t * pDataParams, uint8_t bBlockNr, uint8_t bNumBlocks, uint8_t * pBlocks);

phStatus_t phalMfp_Sw_MultiBlockRead(phalMfp_Sw_DataParams_t * pDataParams, uint8_t bBlockNr, uint8_t bNumBlocks, uint8_t * pBlocks);







phStatus_t phalMfp_Sw_ResetAuth(phalMfp_Sw_DataParams_t * pDataParams );

phStatus_t phalMfp_Sw_ResetSecMsgState(phalMfp_Sw_DataParams_t * pDataParams);

phStatus_t phalMfp_Sw_Cmd_ProximityCheck(phalMfp_Sw_DataParams_t * pDataParams, uint8_t bGenerateRndC, uint8_t * pRndC, uint8_t bNumSteps,
	uint8_t * pUsedRndRC);


#endif /* PHALMFP_SW_H */
