/*
 * Copyright 2017, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * PS6000USB BAL Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#include <ph_Status.h>
#include <phbalReg.h>
#include <ph_RefDefs.h>

#ifdef _WIN32
#include <string.h>
#endif

#ifdef NXPBUILD__PHBAL_REG_PS6000USB

#include "phbalReg_Ps6000Usb_Ex.h"

#pragma warning(push)                   /* PRQA S 3116 */
#pragma warning(disable:4200)           /* PRQA S 3116 */
#pragma warning(disable:4201)           /* PRQA S 3116 */
#include <windows.h>
#pragma warning(pop)                    /* PRQA S 3116 */

phStatus_t phbalReg_Ps6000Usb_Ex_LoadFunctions(
    phbalReg_Ps6000Usb_DataParams_t * pDataParams
    )
{
#ifdef _WIN32
    /* load library */
    pDataParams->pLibraryHandle = LoadLibrary(PHBAL_REG_PS6000USB_EX_DLL_NAME);

    /* check if loading succeded */
    if (pDataParams->pLibraryHandle == NULL)
    {
        /* failed to load the PS6000.dll */
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }

    /* get all function pointers */
    pDataParams->pfPs6000Usb_OpenUnit = (PHBAL_REG_PS6000USB_OPEN_UNIT) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_PS6000USB_EX_OPEN_UNIT_FNAME);
    if (pDataParams->pfPs6000Usb_OpenUnit == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfPs6000Usb_OpenUnitAsync = (PHBAL_REG_PS6000USB_OPEN_UNIT_ASYNC) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_PS6000USB_EX_OPEN_UNIT_ASYNC_FNAME);
    if (pDataParams->pfPs6000Usb_OpenUnitAsync == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfPs6000Usb_OpenUnitProgress = (PHBAL_REG_PS6000USB_OPEN_UNIT_PROGRESS) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_PS6000USB_EX_OPEN_UNIT_PROGRESS_FNAME);
    if (pDataParams->pfPs6000Usb_OpenUnitProgress == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfPs6000Usb_GetUnitInfo = (PHBAL_REG_PS6000USB_GET_UNIT_INFO) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_PS6000USB_EX_GET_UNIT_INFO_FNAME);
    if (pDataParams->pfPs6000Usb_GetUnitInfo == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfPs6000Usb_FlashLed = (PHBAL_REG_PS6000USB_FLASH_LED) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_PS6000USB_EX_FLASH_LED_FNAME);
    if (pDataParams->pfPs6000Usb_FlashLed == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfPs6000Usb_CloseUnit = (PHBAL_REG_PS6000USB_CLOSE_UNIT) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_PS6000USB_EX_CLOSE_UNIT_FNAME);
    if (pDataParams->pfPs6000Usb_CloseUnit == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfPs6000Usb_MemorySegments = (PHBAL_REG_PS6000USB_MEMORY_SEGMENTS) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_PS6000USB_EX_MEMORY_SEGMENTS_FNAME);
    if (pDataParams->pfPs6000Usb_MemorySegments == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfPs6000Usb_SetChannel = (PHBAL_REG_PS6000USB_SET_CHANNEL) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_PS6000USB_EX_SET_CHANNEL_FNAME);
    if (pDataParams->pfPs6000Usb_SetChannel == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfPs6000Usb_GetTimebase = (PHBAL_REG_PS6000USB_GET_TIMEBASE) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_PS6000USB_EX_GET_TIMEBASE_FNAME);
    if (pDataParams->pfPs6000Usb_GetTimebase == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfPs6000Usb_GetTimebase2 = (PHBAL_REG_PS6000USB_GET_TIMEBASE2) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_PS6000USB_EX_GET_TIMEBASE2_FNAME);
    if (pDataParams->pfPs6000Usb_GetTimebase2 == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfPs6000Usb_SetSigGenArbitrary = (PHBAL_REG_PS6000USB_SET_SIG_GEN_ARBITRARY) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_PS6000USB_EX_SET_SIG_GEN_ARBITRARY_FNAME);
    if (pDataParams->pfPs6000Usb_SetSigGenArbitrary == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfPs6000Usb_SetSigGenBuiltIn = (PHBAL_REG_PS6000USB_SET_SIG_GEN_BUILT_IN) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_PS6000USB_EX_SET_SIG_GEN_BUILT_IN_FNAME);
    if (pDataParams->pfPs6000Usb_SetSigGenBuiltIn == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfPs6000Usb_SigGenSoftwareControl = (PHBAL_REG_PS6000USB_SIG_GEN_SOFTWARE_CONTROL) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_PS6000USB_EX_SIG_GEN_SOFTWARE_CONTROL_FNAME);
    if (pDataParams->pfPs6000Usb_SigGenSoftwareControl == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfPs6000Usb_SetSimpleTrigger = (PHBAL_REG_PS6000USB_SET_SIMPLE_TRIGGER) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_PS6000USB_EX_SET_SIMPLE_TRIGGER_FNAME);
    if (pDataParams->pfPs6000Usb_SetSimpleTrigger == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfPs6000Usb_SetEts = (PHBAL_REG_PS6000USB_SET_ETS) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_PS6000USB_EX_SET_ETS_FNAME);
    if (pDataParams->pfPs6000Usb_SetEts == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfPs6000Usb_SetTriggerChannelProperties = (PHBAL_REG_PS6000USB_SET_TRIGGER_CHANNEL_PROPERTIES) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_PS6000USB_EX_SET_TRIGGER_CHANNEL_PROPERTIES_FNAME);
    if (pDataParams->pfPs6000Usb_SetTriggerChannelProperties == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfPs6000Usb_SetTriggerChannelConditions = (PHBAL_REG_PS6000USB_SET_TRIGGER_CHANNEL_CONDITIONS) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_PS6000USB_EX_SET_TRIGGER_CHANNEL_CONDITIONS_FNAME);
    if (pDataParams->pfPs6000Usb_SetTriggerChannelConditions == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfPs6000Usb_SetTriggerChannelDirections = (PHBAL_REG_PS6000USB_SET_TRIGGER_CHANNEL_DIRECTIONS) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_PS6000USB_EX_SET_TRIGGER_CHANNEL_DIRECTIONS_FNAME);
    if (pDataParams->pfPs6000Usb_SetTriggerChannelDirections == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfPs6000Usb_SetTriggerDelay = (PHBAL_REG_PS6000USB_SET_TRIGGER_DELAY) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_PS6000USB_EX_SET_TRIGGER_DELAY_FNAME);
    if (pDataParams->pfPs6000Usb_SetTriggerDelay == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfPs6000Usb_SetPulseWidthQualifier = (PHBAL_REG_PS6000USB_SET_PULSE_WIDTH_QUALIFIER) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_PS6000USB_EX_SET_PULSE_WIDTH_QUALIFIER_FNAME);
    if (pDataParams->pfPs6000Usb_SetPulseWidthQualifier == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfPs6000Usb_IsTriggerOrPulseWidthQualifierEnabled = (PHBAL_REG_PS6000USB_IS_TRIGGER_OR_PULSE_WIDTH_QUALIFIER_ENABLED) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_PS6000USB_EX_IS_TRIGGER_OR_PULSE_WIDTH_QUALIFIER_ENABLED_FNAME);
    if (pDataParams->pfPs6000Usb_IsTriggerOrPulseWidthQualifierEnabled == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfPs6000Usb_GetTriggerTimeOffset = (PHBAL_REG_PS6000USB_GET_TRIGGER_TIME_OFFSET) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_PS6000USB_EX_GET_TRIGGER_TIME_OFFSET_FNAME);
    if (pDataParams->pfPs6000Usb_GetTriggerTimeOffset == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfPs6000Usb_GetTriggerTimeOffset64 = (PHBAL_REG_PS6000USB_GET_TRIGGER_TIME_OFFSET64) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_PS6000USB_EX_GET_TRIGGER_TIME_OFFSET64_FNAME);
    if (pDataParams->pfPs6000Usb_GetTriggerTimeOffset64 == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfPs6000Usb_GetValuesTriggerTimeOffsetBulk = (PHBAL_REG_PS6000USB_GET_VALUES_TRIGGER_TIME_OFFSET_BULK) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_PS6000USB_EX_GET_VALUES_TRIGGER_TIME_OFFSET_BULK_FNAME);
    if (pDataParams->pfPs6000Usb_GetValuesTriggerTimeOffsetBulk == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfPs6000Usb_GetValuesTriggerTimeOffsetBulk64 = (PHBAL_REG_PS6000USB_GET_VALUES_TRIGGER_TIME_OFFSET_BULK64) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_PS6000USB_EX_GET_VALUES_TRIGGER_TIME_OFFSET_BULK64_FNAME);
    if (pDataParams->pfPs6000Usb_GetValuesTriggerTimeOffsetBulk64 == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfPs6000Usb_SetDataBuffers = (PHBAL_REG_PS6000USB_SET_DATA_BUFFERS) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_PS6000USB_EX_SET_DATA_BUFFERS_FNAME);
    if (pDataParams->pfPs6000Usb_SetDataBuffers == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfPs6000Usb_SetDataBuffer = (PHBAL_REG_PS6000USB_SET_DATA_BUFFER) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_PS6000USB_EX_SET_DATA_BUFFER_FNAME);
    if (pDataParams->pfPs6000Usb_SetDataBuffer == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfPs6000Usb_SetDataBufferBulk = (PHBAL_REG_PS6000USB_SET_DATA_BUFFER_BULK) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_PS6000USB_EX_SET_DATA_BUFFER_BULK_FNAME);
    if (pDataParams->pfPs6000Usb_SetDataBufferBulk == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfPs6000Usb_SetDataBuffersBulk = (PHBAL_REG_PS6000USB_SET_DATA_BUFFERS_BULK) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_PS6000USB_EX_SET_DATA_BUFFERS_BULK_FNAME);
    if (pDataParams->pfPs6000Usb_SetDataBuffersBulk == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfPs6000Usb_SetEtsTimeBuffer = (PHBAL_REG_PS6000USB_SET_ETS_TIME_BUFFER) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_PS6000USB_EX_SET_ETS_TIME_BUFFER_FNAME);
    if (pDataParams->pfPs6000Usb_SetEtsTimeBuffer == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfPs6000Usb_SetEtsTimeBuffers = (PHBAL_REG_PS6000USB_SET_ETS_TIME_BUFFERS) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_PS6000USB_EX_SET_ETS_TIME_BUFFERS_FNAME);
    if (pDataParams->pfPs6000Usb_SetEtsTimeBuffers == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfPs6000Usb_RunBlock = (PHBAL_REG_PS6000USB_RUN_BLOCK) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_PS6000USB_EX_RUN_BLOCK_FNAME);
    if (pDataParams->pfPs6000Usb_RunBlock == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfPs6000Usb_IsReady = (PHBAL_REG_PS6000USB_IS_READY) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_PS6000USB_EX_IS_READY_FNAME);
    if (pDataParams->pfPs6000Usb_IsReady == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfPs6000Usb_RunStreaming = (PHBAL_REG_PS6000USB_RUN_STREAMING) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_PS6000USB_EX_RUN_STREAMING_FNAME);
    if (pDataParams->pfPs6000Usb_RunStreaming == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfPs6000Usb_GetStreamingLatestValues = (PHBAL_REG_PS6000USB_GET_STREAMING_LATEST_VALUES) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_PS6000USB_EX_GET_STREAMING_LATEST_VALUES_FNAME);
    if (pDataParams->pfPs6000Usb_GetStreamingLatestValues == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfPs6000Usb_NoOfStreamingValues = (PHBAL_REG_PS6000USB_NO_OF_STREAMING_VALUES) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_PS6000USB_EX_NO_OF_STREAMING_VALUES_FNAME);
    if (pDataParams->pfPs6000Usb_NoOfStreamingValues == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfPs6000Usb_GetMaxDownSampleRatio = (PHBAL_REG_PS6000USB_GET_MAX_DOWN_SAMPLE_RATIO) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_PS6000USB_EX_GET_MAX_DOWN_SAMPLE_RATIO_FNAME);
    if (pDataParams->pfPs6000Usb_GetMaxDownSampleRatio == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfPs6000Usb_GetValues = (PHBAL_REG_PS6000USB_GET_VALUES) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_PS6000USB_EX_GET_VALUES_FNAME);
    if (pDataParams->pfPs6000Usb_GetValues == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfPs6000Usb_GetValuesBulk = (PHBAL_REG_PS6000USB_GET_VALUES_BULK) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_PS6000USB_EX_GET_VALUES_BULK_FNAME);
    if (pDataParams->pfPs6000Usb_GetValuesBulk == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfPs6000Usb_GetValuesAsync = (PHBAL_REG_PS6000USB_GET_VALUES_ASYNC) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_PS6000USB_EX_GET_VALUES_ASYNC_FNAME);
    if (pDataParams->pfPs6000Usb_GetValuesAsync == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfPs6000Usb_GetValuesOverlapped = (PHBAL_REG_PS6000USB_GET_VALUES_OVERLAPPED) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_PS6000USB_EX_GET_VALUES_OVERLAPPED_FNAME);
    if (pDataParams->pfPs6000Usb_GetValuesOverlapped == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfPs6000Usb_GetValuesOverlappedBulk = (PHBAL_REG_PS6000USB_GET_VALUES_OVERLAPPED_BULK) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_PS6000USB_EX_GET_VALUES_OVERLAPPED_BULK_FNAME);
    if (pDataParams->pfPs6000Usb_GetValuesOverlappedBulk == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfPs6000Usb_GetValuesBulkAsync = (PHBAL_REG_PS6000USB_GET_VALUES_BULK_ASYNC) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_PS6000USB_EX_GET_VALUES_BULK_ASYNC_FNAME);
    if (pDataParams->pfPs6000Usb_GetValuesBulkAsync == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfPs6000Usb_GetNoOfCaptures = (PHBAL_REG_PS6000USB_GET_NO_OF_CAPTURES) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_PS6000USB_EX_GET_NO_OF_CAPTURES_FNAME);
    if (pDataParams->pfPs6000Usb_GetNoOfCaptures == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfPs6000Usb_Stop = (PHBAL_REG_PS6000USB_STOP) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_PS6000USB_EX_STOP_FNAME);
    if (pDataParams->pfPs6000Usb_Stop == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfPs6000Usb_SetNoOfCaptures = (PHBAL_REG_PS6000USB_SET_NO_OF_CAPTURES) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_PS6000USB_EX_SET_NO_OF_CAPTURES_FNAME);
    if (pDataParams->pfPs6000Usb_SetNoOfCaptures == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfPs6000Usb_SetWaveformLimiter = (PHBAL_REG_PS6000USB_SET_WAVEFORM_LIMITER) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_PS6000USB_EX_SET_WAVEFORM_LIMITER_FNAME);
    if (pDataParams->pfPs6000Usb_SetWaveformLimiter == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfPs6000Usb_EnumerateUnits = (PHBAL_REG_PS6000USB_ENUMERATE_UNITS) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_PS6000USB_EX_ENUMERATE_UNITS_FNAME);
    if (pDataParams->pfPs6000Usb_EnumerateUnits == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfPs6000Usb_SetExternalClock = (PHBAL_REG_PS6000USB_SET_EXTERNAL_CLOCK) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_PS6000USB_EX_SET_EXTERNAL_CLOCK_FNAME);
    if (pDataParams->pfPs6000Usb_SetExternalClock == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfPs6000Usb_PingUnit = (PHBAL_REG_PS6000USB_PING_UNIT) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_PS6000USB_EX_GET_UNIT_INFO_FNAME);
    if (pDataParams->pfPs6000Usb_PingUnit == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_BAL);
#else
    return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
#endif
}

phStatus_t phbalReg_Ps6000Usb_Ex_UnLoadFunctions(
    phbalReg_Ps6000Usb_DataParams_t * pDataParams
    )
{
#ifdef _WIN32
    uint8_t bResult;

    /* check if the library is loaded */
    if (pDataParams->pLibraryHandle != NULL)
    {
        /* unload the library */
        bResult = (uint8_t)FreeLibrary((HMODULE)pDataParams->pLibraryHandle);

        /* check the success of the command */
        if (bResult == PH_OFF)
        {
            return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
        }

        /* set all function pointers to NULL */
        pDataParams->pfPs6000Usb_OpenUnit                              = NULL;
        pDataParams->pfPs6000Usb_OpenUnitAsync                         = NULL;
        pDataParams->pfPs6000Usb_OpenUnitProgress                      = NULL;
        pDataParams->pfPs6000Usb_GetUnitInfo                           = NULL;
        pDataParams->pfPs6000Usb_FlashLed                              = NULL;
        pDataParams->pfPs6000Usb_CloseUnit                             = NULL;
        pDataParams->pfPs6000Usb_MemorySegments                        = NULL;
        pDataParams->pfPs6000Usb_SetChannel                            = NULL;
        pDataParams->pfPs6000Usb_GetTimebase                           = NULL;
        pDataParams->pfPs6000Usb_GetTimebase2                          = NULL;
        pDataParams->pfPs6000Usb_SetSigGenArbitrary                    = NULL;
        pDataParams->pfPs6000Usb_SetSigGenBuiltIn                      = NULL;
        pDataParams->pfPs6000Usb_SigGenSoftwareControl                 = NULL;
        pDataParams->pfPs6000Usb_SetSimpleTrigger                      = NULL;
        pDataParams->pfPs6000Usb_SetEts                                = NULL;
        pDataParams->pfPs6000Usb_SetTriggerChannelProperties           = NULL;
        pDataParams->pfPs6000Usb_SetTriggerChannelConditions           = NULL;
        pDataParams->pfPs6000Usb_SetTriggerChannelDirections           = NULL;
        pDataParams->pfPs6000Usb_SetTriggerDelay                       = NULL;
        pDataParams->pfPs6000Usb_SetPulseWidthQualifier                = NULL;
        pDataParams->pfPs6000Usb_IsTriggerOrPulseWidthQualifierEnabled = NULL;
        pDataParams->pfPs6000Usb_GetTriggerTimeOffset                  = NULL;
        pDataParams->pfPs6000Usb_GetTriggerTimeOffset64                = NULL;
        pDataParams->pfPs6000Usb_GetValuesTriggerTimeOffsetBulk        = NULL;
        pDataParams->pfPs6000Usb_GetValuesTriggerTimeOffsetBulk64      = NULL;
        pDataParams->pfPs6000Usb_SetDataBuffers                        = NULL;
        pDataParams->pfPs6000Usb_SetDataBuffer                         = NULL;
        pDataParams->pfPs6000Usb_SetDataBufferBulk                     = NULL;
        pDataParams->pfPs6000Usb_SetDataBuffersBulk                    = NULL;
        pDataParams->pfPs6000Usb_SetEtsTimeBuffer                      = NULL;
        pDataParams->pfPs6000Usb_SetEtsTimeBuffers                     = NULL;
        pDataParams->pfPs6000Usb_RunBlock                              = NULL;
        pDataParams->pfPs6000Usb_IsReady                               = NULL;
        pDataParams->pfPs6000Usb_RunStreaming                          = NULL;
        pDataParams->pfPs6000Usb_GetStreamingLatestValues              = NULL;
        pDataParams->pfPs6000Usb_NoOfStreamingValues                   = NULL;
        pDataParams->pfPs6000Usb_GetMaxDownSampleRatio                 = NULL;
        pDataParams->pfPs6000Usb_GetValues                             = NULL;
        pDataParams->pfPs6000Usb_GetValuesBulk                         = NULL;
        pDataParams->pfPs6000Usb_GetValuesAsync                        = NULL;
        pDataParams->pfPs6000Usb_GetValuesOverlapped                   = NULL;
        pDataParams->pfPs6000Usb_GetValuesOverlappedBulk               = NULL;
        pDataParams->pfPs6000Usb_GetValuesBulkAsync                    = NULL;
        pDataParams->pfPs6000Usb_GetNoOfCaptures                       = NULL;
        pDataParams->pfPs6000Usb_Stop                                  = NULL;
        pDataParams->pfPs6000Usb_SetNoOfCaptures                       = NULL;
        pDataParams->pfPs6000Usb_SetWaveformLimiter                    = NULL;
        pDataParams->pfPs6000Usb_EnumerateUnits                        = NULL;
        pDataParams->pfPs6000Usb_SetExternalClock                      = NULL;
        pDataParams->pfPs6000Usb_PingUnit                              = NULL;

        /* set the handle to NULL */
        pDataParams->pLibraryHandle = NULL;
        /* return success */
        return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_BAL);
    }
    else
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
#else /* _WIN32 */
    return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
#endif
}
#endif /* NXPBUILD__PHBAL_REG_PS6000USB */
