/*
 * Copyright 2017, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * PS6000USB BAL Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHBALREG_PS6000USB_H
#define PHBALREG_PS6000USB_H

#include <ph_Status.h>
#include <phbalReg.h>

phStatus_t phbalReg_Ps6000Usb_GetPortList(
    phbalReg_Ps6000Usb_DataParams_t * pDataParams,
    uint16_t wPortBufSize,
    uint8_t * pPortNames,
    uint16_t * pNumOfPorts
    );

phStatus_t phbalReg_Ps6000Usb_SetPort(
                                     phbalReg_Ps6000Usb_DataParams_t * pDataParams,
                                     uint8_t * pPortName
                                     );

phStatus_t phbalReg_Ps6000Usb_Exchange(
                                      phbalReg_Ps6000Usb_DataParams_t * pDataParams,
                                      uint16_t wOption,
                                      uint8_t * pTxBuffer,
                                      uint16_t wTxLength,
                                      uint16_t wRxBufSize,
                                      uint8_t * pRxBuffer,
                                      uint16_t * pRxLength
                                      );

phStatus_t phbalReg_Ps6000Usb_OpenPort(
                                      phbalReg_Ps6000Usb_DataParams_t * pDataParams
                                      );

phStatus_t phbalReg_Ps6000Usb_ClosePort(
                                       phbalReg_Ps6000Usb_DataParams_t * pDataParams
                                       );

phStatus_t phbalReg_Ps6000Usb_SetConfig(
                                       phbalReg_Ps6000Usb_DataParams_t * pDataParams,
                                       uint16_t wConfig,
                                       uint16_t wValue
                                       );

phStatus_t phbalReg_Ps6000Usb_GetConfig(
                                       phbalReg_Ps6000Usb_DataParams_t * pDataParams,
                                       uint16_t wConfig,
                                       uint16_t * pValue
                                       );

#endif /* PHBALREG_PS6000USB_H */
