/*
 * Copyright 2013, 2017, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * RDFPGA BAL Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHBALREG_RDFPGA_EX_H
#define PHBALREG_RDFPGA_EX_H

#include <ph_Status.h>
#include <phbalReg.h>

phStatus_t phbalReg_RdFpgaV6_Ex_LoadFunctions(
    phbalReg_RdFpgaV6_DataParams_t * pDataParams
    );

phStatus_t phbalReg_RdFpgaV6_Ex_UnLoadFunctions(
    phbalReg_RdFpgaV6_DataParams_t * pDataParams
    );

/* define the dll that has to be loaded */
#define	PHBAL_REG_RDFPGAV6_EX_DLL_NAME                                      "phCDllReaderLib.dll"

/* define the function names that have to be loaded */
#define PHBAL_REG_RDFPGAV6_EX_OPEN_FNAME                                    "_phCIReaderLib_Open@8"
#define PHBAL_REG_RDFPGAV6_EX_CLOSE_FNAME                                   "_phCIReaderLib_Close@0"
#define PHBAL_REG_RDFPGAV6_EX_INIT_FNAME                                    "_phCIReaderLib_Init@4"
#define PHBAL_REG_RDFPGAV6_EX_SETPARAM_FNAME                                "_phCIReaderLib_SetParam@12"
#define PHBAL_REG_RDFPGAV6_EX_GETPARAM_FNAME                                "_phCIReaderLib_GetParam@8"
#define PHBAL_REG_RDFPGAV6_EX_EXCHANGEBITS_FNAME                            "_phCIReaderLib_ExchangeBits@28"
#define PHBAL_REG_RDFPGAV6_EX_SETTARGETJOINER_FNAME                         "_phCIFPGAJoiner_SetTargetJoiner@4"
#define PHBAL_REG_RDFPGAV6_EX_SETJOINERREG_FNAME                            "_phCIFPGAJoiner_SetJoinerReg@8"
#define PHBAL_REG_RDFPGAV6_EX_GETJOINERREG_FNAME                            "_phCIFPGAJoiner_GetJoinerReg@8"
#define PHBAL_REG_RDFPGAV6_EX_LOADJOINERINIFILE_FNAME                       "_phCIFPGAJoiner_LoadJoinerIniFile@4"
#define PHBAL_REG_RDFPGAV6_EX_ACTFIELD_FNAME                                "_phCIFPGA_ActivateField@0"
#define PHBAL_REG_RDFPGAV6_EX_DEACTIVATEFIELD_FNAME                         "_phCIFPGA_DeactivateField@0"
#define PHBAL_REG_RDFPGAV6_EX_HFPAUSE_FNAME                                 "_phCIFPGA_HFPause@4"
#define PHBAL_REG_RDFPGAV6_EX_SET_POTIPOS_FNAME                             "_phCIFPGA_SetPotiPos@4"
#define PHBAL_REG_RDFPGAV6_EX_SET_DEFAULTPOTIPOS_FNAME                      "_phCIFPGA_SetDefaultPotiPos@4"
#define PHBAL_REG_RDFPGAV6_EX_GET_POTIPOS_FNAME                             "_phCIFPGA_GetPotiPos@4"
#define PHBAL_REG_RDFPGAV6_EX_INC_POTIPOS_FNAME                             "_phCIFPGA_IncPotiPos@0"
#define PHBAL_REG_RDFPGAV6_EX_DEC_POTIPOS_FNAME                             "_phCIFPGA_DecPotiPos@0"
#define PHBAL_REG_RDFPGAV6_EX_SET_TIMEOUTVALUE_FNAME                        "_phCIFPGA_SetTimeoutValue@4"
#define PHBAL_REG_RDFPGAV6_EX_GET_TIMEOUTVALUE_FNAME                        "_phCIFPGA_GetTimeoutValue@4"
#define PHBAL_REG_RDFPGAV6_EX_LOAD_PATTERN_FNAME                            "_phCIFPGA_LoadPattern@8"
#define PHBAL_REG_RDFPGAV6_EX_PLAY_PATTERN_FNAME                            "_phCIFPGA_PlayPattern@4"
#define PHBAL_REG_RDFPGAV6_EX_PLAYSEQA_FNAME                                "_phCIFPGA_PlaySeqA@0"
#define PHBAL_REG_RDFPGAV6_EX_PLAYSEQB_FNAME                                "_phCIFPGA_PlaySeqB@0"
#define PHBAL_REG_RDFPGAV6_EX_PLAYSINUS_FNAME                               "_phCIFPGA_PlaySinus@0"
#define PHBAL_REG_RDFPGAV6_EX_SELECT_TRIGGER_FNAME                          "_phCIFPGA_SelectTrigger@4"
#define PHBAL_REG_RDFPGAV6_EX_LBLRST_FNAME                                  "_phCIFPGA_LabelReset@12"
#define PHBAL_REG_RDFPGAV6_EX_LBLRST_COUNTERRESET_FNAME                     "_phCIFPGA_LabelResetCounterReset@12"
#define PHBAL_REG_RDFPGAV6_EX_LBLRST_SSCOUNTERRESET_FNAME                   "_phCIFPGA_LabelResetCounterResetSingleShot@12"
#define PHBAL_REG_RDFPGAV6_EX_LBLRST_SINGLESHOT_FNAME                       "_phCIFPGA_LabelResetSingleShot@12"
#define PHBAL_REG_RDFPGAV6_EX_LBLRST_WITHCOMMAND_FNAME                      "_phCIFPGA_LabelResetWithCommand@4"
#define PHBAL_REG_RDFPGAV6_EX_ACT_FDT_MEASUREMENT_FNAME                     "_phCIFPGA_ActivateFDTMeasurement@0"
#define PHBAL_REG_RDFPGAV6_EX_GET_FDT_FNAME                                 "_phCIFPGA_GetFDT@4"
#define PHBAL_REG_RDFPGAV6_EX_GET_FDT_FAST_FNAME                            "_phCIFPGA_GetFDTFast@4"
#define PHBAL_REG_RDFPGAV6_EX_ACT_ANTITEARINGMODE_FNAME                     "_phCIFPGA_ActivateAntiTearingMode@8"
#define PHBAL_REG_RDFPGAV6_EX_RESONANCE_FREQ_TEST_FNAME                     "_phCIFPGA_ResonanceFrequenceTest@8"
#define PHBAL_REG_RDFPGAV6_EX_ACT_FDT_PICC_TO_PCD_MEASUREMENT_FNAME         "_phCIFPGA_ActivateFDTMeasurementPICCtoPCD@20"
#define PHBAL_REG_RDFPGAV6_EX_ACT_LMA_MEASUREMENT_FNAME                     "_phCIFPGA_ActivateLMAMeasurement@0"
#define PHBAL_REG_RDFPGAV6_EX_ACT_SEQUENCERMODE_FNAME                       "_phCIFPGA_ActivateSequencerMode@0"
#define PHBAL_REG_RDFPGAV6_EX_DEACTIVATE_MODES_FNAME                        "_phCIFPGA_DeactivateModes@0"
#define PHBAL_REG_RDFPGAV6_EX_SET_JOINER_RXGAIN_FNAME                       "_phCIFPGA_SetJoinerRxGain@4"
#define PHBAL_REG_RDFPGAV6_EX_GET_JOINER_RXGAIN_FNAME                       "_phCIFPGA_GetJoinerRxGain@4"
#define PHBAL_REG_RDFPGAV6_EX_ACTIVEDS_SET_FDT_FNAME                        "_phCIFPGA_SetFDTPCDforActiveDS@4"
#define PHBAL_REG_RDFPGAV6_EX_DS_SET_FDT_FNAME                              "_phCIFPGA_SetFDTPCDforDS@8"
#define PHBAL_REG_RDFPGAV6_EX_GET_VERSION_FNAME                             "_phCIFPGA_GetVersion@4"
#define PHBAL_REG_RDFPGAV6_EX_GET_REVISION_FNAME                            "_phCIFPGA_GetRevision@4"
#define PHBAL_REG_RDFPGAV6_EX_GET_ERROR_CODES_FNAME                         "_phCIFPGA_GetErrorCodes@12"
#define PHBAL_REG_RDFPGAV6_EX_SET_CLOCK_SOURCE_FNAME                        "_phCIFPGA_SetClockSource@4"
#define PHBAL_REG_RDFPGAV6_EX_GET_FIRST_RESPONSE_FNAME                      "_phCIFPGA_GetFirstResponce@20"
#define PHBAL_REG_RDFPGAV6_EX_GET_RESPONSE_FNAME                            "_phCIFPGA_GetResponce@20"
#define PHBAL_REG_RDFPGAV6_EX_GET_IQ_TIMEOUTVALUE_FNAME                     "_phCIFPGA_GetIQTimeoutValue@4"
#define PHBAL_REG_RDFPGAV6_EX_SET_IQ_TIMEOUTVALUE_FNAME                     "_phCIFPGA_SetIQTimeoutValue@4"
#define PHBAL_REG_RDFPGAV6_EX_GET_TERMINALID_FNAME                          "_phCIFPGA_GetTerminalID@4"
#define PHBAL_REG_RDFPGAV6_EX_RESET_JOINER_FNAME                            "_phCIFPGA_ResetJoiner@0"
#define PHBAL_REG_RDFPGAV6_EX_LOADFILTERFILE_FNAME                          "_phCIFPGA_LoadFilterFile@4"
#define PHBAL_REG_RDFPGAV6_EX_EXCHANGEFPGACOMMAND_FNAME                     "_phCIFPGA_ExchangeFPGACommand@20"
#define PHBAL_REG_RDFPGAV6_EX_ACTIVATETYPEBMODE_FNAME                       "_phCIFPGA_ActivateTypeBMode@0"

#endif /* PHBALREG_RDFPGA_EX_H */
