/*
 * Copyright 2022 - 2023, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Hal DUT specific definition of Version commands.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7463 $
 * $Date: 2025-08-29 15:56:52 +0530 (Fri, 29 Aug 2025) $
 *
 * History:
 *   Created On 12 October, 2022
 *
 */

#include <ph_Status.h>

#ifdef NXPBUILD__PHHAL_HW_DUT_CMD_VERSION
#include <ph_RefDefs.h>
#include <phhalHw_DUT_Cmd.h>

#include"../phhalHw_DUT.h"

phStatus_t phhalHw_DUT_Cmd_GetVersion(phhalHw_DUT_DataParams_t * pDataParams, uint8_t * pProductVer, uint16_t * pMajor, uint8_t * pMinor,
    uint16_t * pPatch_Dev, uint8_t * pVersionString, uint16_t * pVersionLen)
{
    phStatus_t  PH_MEMLOC_REM wStatus = 0;
    uint8_t *   PH_MEMLOC_REM pRxBuff = NULL;
    uint16_t    PH_MEMLOC_REM wRxLen = 0;
    uint16_t    PH_MEMLOC_REM wVerStringLen = 0;

    PH_CHECK_SUCCESS_FCT(wStatus, PHHALHW_DUT_INT(pDataParams,
        PHHAL_HW_DUT_CMD_GETVERSION,
        PH_EXCHANGE_DEFAULT,
        NULL,
        0,
        &pRxBuff,
        &wRxLen));

    *pProductVer = pRxBuff[0];

    *pMajor = (uint16_t) ((pRxBuff[2] << 8) | pRxBuff[1]);
    *pMinor = pRxBuff[3];
    *pPatch_Dev = (uint16_t) ((pRxBuff[5] << 8) | pRxBuff[4]);

    wVerStringLen = (uint16_t) ((pRxBuff[7] << 8) | pRxBuff[6]);

    if(wVerStringLen > *pVersionLen)
    {
        wVerStringLen = *pVersionLen;
    }

    (void) memcpy(pVersionString, &pRxBuff[8], wVerStringLen);

    *pVersionLen = wVerStringLen;
    pVersionString[(*pVersionLen)] = 0x00;

    return PH_ERR_SUCCESS;
}

phStatus_t phhalHw_DUT_Cmd_GetVersion_NFC(phhalHw_DUT_DataParams_t * pDataParams, uint8_t * pProductVer, uint16_t * pMajor, uint8_t * pMinor,
    uint16_t * pPatch_Dev, uint8_t * pVersionString, uint16_t * pVersionLen)
{
    phStatus_t  PH_MEMLOC_REM wStatus = 0;
    uint8_t *   PH_MEMLOC_REM pRxBuff = NULL;
    uint16_t    PH_MEMLOC_REM wRxLen = 0;
    uint16_t    PH_MEMLOC_REM wVerStringLen = 0;

    PH_CHECK_SUCCESS_FCT(wStatus, PHHALHW_DUT_INT(pDataParams,
        PHHAL_HW_DUT_CMD_GETVERSION_NFC,
        PH_EXCHANGE_DEFAULT,
        NULL,
        0,
        &pRxBuff,
        &wRxLen));

    *pProductVer = pRxBuff[0];

    *pMajor = (uint16_t) ((pRxBuff[2] << 8) | pRxBuff[1]);
    *pMinor = pRxBuff[3];
    *pPatch_Dev = (uint16_t) ((pRxBuff[5] << 8) | pRxBuff[4]);

    wVerStringLen = (uint16_t) ((pRxBuff[7] << 8) | pRxBuff[6]);

    if(wVerStringLen > *pVersionLen)
    {
        wVerStringLen = *pVersionLen;
    }

    (void) memcpy(pVersionString, &pRxBuff[8], wVerStringLen);

    *pVersionLen = wVerStringLen;
    pVersionString[(*pVersionLen)] = 0x00;

    return PH_ERR_SUCCESS;
}

phStatus_t phhalHw_DUT_Cmd_GetVersion_CompiledInfo(phhalHw_DUT_DataParams_t * pDataParams, uint8_t * pResponse, uint16_t * pRspLen)
{
    phStatus_t  PH_MEMLOC_REM wStatus = 0;
    uint8_t *   PH_MEMLOC_REM pRxBuff = NULL;
    uint16_t    PH_MEMLOC_REM wRxLen = 0;

    PH_CHECK_SUCCESS_FCT(wStatus, PHHALHW_DUT_INT(pDataParams,
        PHHAL_HW_DUT_CMD_GETVERSION_DATE_TIME,
        PH_EXCHANGE_DEFAULT,
        NULL,
        0,
        &pRxBuff,
        &wRxLen));

    if(wRxLen > *pRspLen)
    {
        wRxLen = *pRspLen;
    }

    (void) memcpy(pResponse, pRxBuff, wRxLen);

    *pRspLen = wRxLen;
    pResponse[*pRspLen] = 0x00;

    return PH_ERR_SUCCESS;
}

phStatus_t phhalHw_DUT_Cmd_GetVersion_ReaderIcType(phhalHw_DUT_DataParams_t * pDataParams, uint8_t * pResponse, uint16_t * pRspLen)
{
    phStatus_t  PH_MEMLOC_REM wStatus = 0;
    uint8_t *   PH_MEMLOC_REM pRxBuff = NULL;
    uint16_t    PH_MEMLOC_REM wRxLen = 0;

    PH_CHECK_SUCCESS_FCT(wStatus, PHHALHW_DUT_INT(pDataParams,
        PHHAL_HW_DUT_CMD_GETVERSION_READER_IC_TYPE,
        PH_EXCHANGE_DEFAULT,
        NULL,
        0,
        &pRxBuff,
        &wRxLen));

    if(wRxLen > *pRspLen)
    {
        wRxLen = *pRspLen;
    }

    (void) memcpy(pResponse, pRxBuff, wRxLen);

    *pRspLen = wRxLen;
    pResponse[*pRspLen] = 0x00;

    return PH_ERR_SUCCESS;
}

#endif /* NXPBUILD__PHHAL_HW_DUT_CMD_VERSION */
