/*
 * Copyright 2013, 2019, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * SAMAV2 specific HAL-Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHHALHW_SAMAV2_H
#define PHHALHW_SAMAV2_H

#include <ph_Status.h>
#include <phhalHw.h>

#define PHHAL_HW_SAMAV2_FIFOSIZE                0xFFU   /**< Size of RC internal FiFo buffer. */
#define PHHAL_HW_SAMAV2_DEFAULT_TIMEOUT         150U    /**< Default timeout in microseconds. */

#define PHHAL_HW_SAMAV2_HC_AV2_NO_CHAINING      0x00U
#define PHHAL_HW_SAMAV2_HC_AV2_CHAINING_NO_SM   0x0FU
#define PHHAL_HW_SAMAV2_HC_AV2_CHAINING         0xFFU
#define PHHAL_HW_SAMAV2_HC_AV2_NO_SM            0x00U
#define PHHAL_HW_SAMAV2_HC_AV2_MAC              0x0FU
#define PHHAL_HW_SAMAV2_HC_AV2_ENC              0xF0U

#define PHHAL_HW_SAMAV2_KEYENTRY_DESFIRE_AID_POS    48
#define PHHAL_HW_SAMAV2_KEYENTRY_DESFIRE_KEYNUM_POS 51
#define PHHAL_HW_SAMAV2_KEYENTRY_REFNUM_CEK_POS     52
#define PHHAL_HW_SAMAV2_KEYENTRY_KEYVER_CEK_POS     53
#define PHHAL_HW_SAMAV2_KEYENTRY_REFNUM_KUC_POS     54
#define PHHAL_HW_SAMAV2_KEYENTRY_CONFIG_SET_POS     55
#define PHHAL_HW_SAMAV2_KEYENTRY_KEY_A_VERSION_POS  57
#define PHHAL_HW_SAMAV2_KEYENTRY_KEY_B_VERSION_POS  58
#define PHHAL_HW_SAMAV2_KEYENTRY_KEY_C_VERSION_POS  59
#define PHHAL_HW_SAMAV2_KEYENTRY_CONFIG_SET2_POS    60


phStatus_t phhalHw_SamAV2_GetConfig(phhalHw_SamAV2_DataParams_t * pDataParams, uint16_t wConfig, uint16_t * pValue);

#endif /* PHHALHW_SAMAV2_H */
