/*
 * Copyright 2015 - 2017, 2023, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * RD710 SLI15693 Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 *
 * History:
 *  Generated 30. June 2015
 *
 */

#include <ph_Status.h>

#ifdef  NXPBUILD__PHPAL_SLI15693_RD710
#include <phhalHw.h>
#include <phhalHw_Rd710_Cmd.h>
#include <phpalSli15693.h>
#include <ph_RefDefs.h>

#include "phpalSli15693_Rd710.h"

phStatus_t phpalSli15693_Rd710_Init(phpalSli15693_Rd710_DataParams_t * pDataParams, uint16_t wSizeOfDataParams,
    phhalHw_Rd710_DataParams_t * pHalDataParams)
{
    if(sizeof(phpalSli15693_Rd710_DataParams_t) != wSizeOfDataParams)
    {
        return PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_PAL_SLI15693);
    }
    PH_ASSERT_NULL_DATA_PARAM(pDataParams, PH_COMP_PAL_SLI15693);
    PH_ASSERT_NULL_PARAM(pHalDataParams, PH_COMP_PAL_SLI15693);

    pDataParams->wId                = PH_COMP_PAL_SLI15693 | PHPAL_SLI15693_RD710_ID;
    pDataParams->pHalDataParams     = pHalDataParams;
    pDataParams->wAdditionalInfo    = 0;
    pDataParams->bFlags             = 0x02;
    pDataParams->bUidBitLen         = 0;

    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_PAL_SLI15693);
}





/* ISO15693 Mandatory commands ------------------------------------------------------------------------------------- */
phStatus_t phpalSli15693_Rd710_Inventory(phpalSli15693_Rd710_DataParams_t * pDataParams, uint8_t bFlags, uint8_t bAfi,
    uint8_t * pMask, uint8_t bMaskBitLen, uint8_t * pDsfid, uint8_t * pUid)
{
    return phhalHw_Rd710_Cmd_Inventory(
        pDataParams->pHalDataParams,
        bFlags,
        bAfi,
        pMask,
        bMaskBitLen,
        pDsfid,
        pUid);
}

phStatus_t phpalSli15693_Rd710_StayQuiet(phpalSli15693_Rd710_DataParams_t * pDataParams)
{
    return phhalHw_Rd710_Cmd_StayQuiet(pDataParams->pHalDataParams);
}





/* ISO15693 Optional commands -------------------------------------------------------------------------------------- */
phStatus_t phpalSli15693_Rd710_Select(phpalSli15693_Rd710_DataParams_t * pDataParams)
{
    return phhalHw_Rd710_Cmd_Select(pDataParams->pHalDataParams);
}

phStatus_t phpalSli15693_Rd710_ResetToReady(phpalSli15693_Rd710_DataParams_t * pDataParams)
{
    return phhalHw_Rd710_Cmd_ResetToReady(pDataParams->pHalDataParams);
}





/* ISO15693 Custom commands ---------------------------------------------------------------------------------------- */

phStatus_t phpalSli15693_Rd710_InventoryRead(phpalSli15693_Rd710_DataParams_t * pDataParams, uint8_t bFlags, uint8_t bAfi,
    uint8_t * pMask, uint8_t bMaskBitLen, uint8_t bBlockNo, uint16_t wNoOfBlocks, uint8_t * pUid, uint8_t * pUidLen,
    uint8_t * pData, uint16_t * pDataLen)
{
    return phhalHw_Rd710_Cmd_InventoryRead(
        pDataParams->pHalDataParams,
        bFlags,
        bAfi,
        pMask,
        bMaskBitLen,
        bBlockNo,
        wNoOfBlocks,
        pUid,
        pUidLen,
        pData,
        pDataLen);
}

phStatus_t phpalSli15693_Rd710_InventoryReadExtended(phpalSli15693_Rd710_DataParams_t * pDataParams, uint8_t bFlags, uint8_t bAfi,
    uint8_t * pMask, uint8_t bMaskBitLen, uint8_t bExtendedOptions, uint8_t * pCID, uint8_t bBlockNo, uint16_t wNumOfBlocks,
    uint8_t * pCDIDOut, uint8_t * pUid, uint8_t * pUidLen, uint8_t * pData, uint16_t * pDataLen)
{
    return phhalHw_Rd710_Cmd_InventoryReadExtended(
        pDataParams->pHalDataParams,
        bFlags,
        bAfi,
        pMask,
        bMaskBitLen,
        bExtendedOptions,
        pCID,
        bBlockNo,
        wNumOfBlocks,
        pCDIDOut,
        pUid,
        pUidLen,
        pData,
        pDataLen);
}

phStatus_t phpalSli15693_Rd710_FastInventoryRead(phpalSli15693_Rd710_DataParams_t * pDataParams, uint8_t bFlags, uint8_t bAfi,
    uint8_t * pMask, uint8_t bMaskBitLen, uint8_t bBlockNo, uint16_t wNoOfBlocks, uint8_t * pUid, uint8_t * pUidLen,
    uint8_t * pData, uint16_t * pDataLen)
{
    return phhalHw_Rd710_Cmd_FastInventoryRead(
        pDataParams->pHalDataParams,
        bFlags,
        bAfi,
        pMask,
        bMaskBitLen,
        bBlockNo,
        wNoOfBlocks,
        pUid,
        pUidLen,
        pData,
        pDataLen);
}

phStatus_t phpalSli15693_Rd710_FastInventoryReadExtended(phpalSli15693_Rd710_DataParams_t * pDataParams, uint8_t bFlags, uint8_t bAfi,
    uint8_t * pMask, uint8_t bMaskBitLen, uint8_t bExtendedOptions, uint8_t * pCID, uint8_t bBlockNo, uint16_t wNumOfBlocks,
    uint8_t * pCDIDOut, uint8_t * pUid, uint8_t * pUidLen, uint8_t * pData, uint16_t * pDataLen)
{
    return phhalHw_Rd710_Cmd_FastInventoryReadExtended(
        pDataParams->pHalDataParams,
        bFlags,
        bAfi,
        pMask,
        bMaskBitLen,
        bExtendedOptions,
        pCID,
        bBlockNo,
        wNumOfBlocks,
        pCDIDOut,
        pUid,
        pUidLen,
        pData,
        pDataLen);
}

phStatus_t phpalSli15693_Rd710_InventoryPageRead(phpalSli15693_Rd710_DataParams_t * pDataParams, uint8_t bFlags, uint8_t bAfi,
    uint8_t * pMask, uint8_t bMaskBitLen, uint8_t bPageNo, uint16_t wNoOfPages, uint8_t * pUid, uint8_t * pUidLen,
    uint8_t * pData, uint16_t * pDataLen)
{
    return phhalHw_Rd710_Cmd_InventoryPageRead(
        pDataParams->pHalDataParams,
        bFlags,
        bAfi,
        pMask,
        bMaskBitLen,
        bPageNo,
        wNoOfPages,
        pUid,
        pUidLen,
        pData,
        pDataLen);
}

phStatus_t phpalSli15693_Rd710_FastInventoryPageRead(phpalSli15693_Rd710_DataParams_t * pDataParams, uint8_t bFlags, uint8_t bAfi,
    uint8_t * pMask, uint8_t bMaskBitLen, uint8_t bPageNo, uint16_t wNoOfPages, uint8_t * pUid, uint8_t * pUidLen,
    uint8_t * pData, uint16_t * pDataLen)
{
    return phhalHw_Rd710_Cmd_FastInventoryPageRead(
        pDataParams->pHalDataParams,
        bFlags,
        bAfi,
        pMask,
        bMaskBitLen,
        bPageNo,
        wNoOfPages,
        pUid,
        pUidLen,
        pData,
        pDataLen);
}

phStatus_t phpalSli15693_Rd710_StayQuietPersistent(phpalSli15693_Rd710_DataParams_t * pDataParams)
{
    return phhalHw_Rd710_Cmd_StayQuietPersistent(pDataParams->pHalDataParams);
}





/* ISO15693 Common commands ---------------------------------------------------------------------------------------- */
phStatus_t phpalSli15693_Rd710_ActivateCard(phpalSli15693_Rd710_DataParams_t * pDataParams, uint8_t  bOption, uint8_t bFlags,
    uint8_t bAfi, uint8_t * pMask, uint8_t bMaskBitLen, uint8_t * pDsfid, uint8_t * pUid, uint8_t * pMoreCardsAvailable)
{
    return phhalHw_Rd710_Cmd_ActivateCard(
        pDataParams->pHalDataParams,
        bOption,
        bFlags,
        bAfi,
        pMask,
        bMaskBitLen,
        pDsfid,
        pUid,
        pMoreCardsAvailable);
}

phStatus_t phpalSli15693_Rd710_SendEof(phpalSli15693_Rd710_DataParams_t * pDataParams, uint8_t bOption, uint8_t * pDsfid,
    uint8_t * pUid, uint8_t * pUidLen, uint8_t * pData, uint16_t * pDataLen)
{
    return phhalHw_Rd710_Cmd_SendEof(
        pDataParams->pHalDataParams,
        bOption,
        pDsfid,
        pUid,
        pUidLen,
        pData,
        pDataLen);
}


phStatus_t phpalSli15693_Rd710_Exchange(phpalSli15693_Rd710_DataParams_t * pDataParams, uint16_t wOption, uint8_t * pTxBuffer,
    uint16_t wTxLen, uint8_t ** ppRxBuffer, uint16_t * pRxLen)
{
    return phhalHw_Rd710_Cmd_Exchange(
        pDataParams->pHalDataParams,
        wOption,
        pTxBuffer,
        wTxLen,
        ppRxBuffer,
        pRxLen);
}





/* ISO15693 Utility commands --------------------------------------------------------------------------------------- */
phStatus_t phpalSli15693_Rd710_GetSerialNo(phpalSli15693_Rd710_DataParams_t * pDataParams, uint8_t * pUid, uint8_t * pUidLen)
{
    return phhalHw_Rd710_Cmd_GetSerialNo(
        pDataParams->pHalDataParams,
        pUid,
        pUidLen);
}

phStatus_t phpalSli15693_Rd710_SetConfig(phpalSli15693_Rd710_DataParams_t * pDataParams, uint16_t wConfig, uint16_t wValue)
{
    phStatus_t  PH_MEMLOC_REM wStatus = 0;
    uint16_t    PH_MEMLOC_REM wValueOld = 0;

    switch(wConfig)
    {
        case PHPAL_SLI15693_CONFIG_FLAGS:

            /* Retrieve current Sub-Carrier setting */
            PH_CHECK_SUCCESS_FCT(wStatus, phhalHw_GetConfig(
                pDataParams->pHalDataParams,
                PHHAL_HW_CONFIG_SUBCARRIER,
                &wValueOld));

            /* Set dual Sub-Carrier if HAL is not already configured for it */
            if(wValue & PHPAL_SLI15693_FLAG_TWO_SUB_CARRIERS)
            {
                if(wValueOld != PHHAL_HW_SUBCARRIER_DUAL)
                {
                    PH_CHECK_SUCCESS_FCT(wStatus, phhalHw_SetConfig(
                        pDataParams->pHalDataParams,
                        PHHAL_HW_CONFIG_SUBCARRIER,
                        PHHAL_HW_SUBCARRIER_DUAL));
                }
            }
            /* Set single Sub-Carrier if HAL is not already configured for it */
            else
            {
                if(wValueOld != PHHAL_HW_SUBCARRIER_SINGLE)
                {
                    PH_CHECK_SUCCESS_FCT(wStatus, phhalHw_SetConfig(
                        pDataParams->pHalDataParams,
                        PHHAL_HW_CONFIG_SUBCARRIER,
                        PHHAL_HW_SUBCARRIER_SINGLE));
                }
            }

            /* Retrieve current DataRate setting. */
            PH_CHECK_SUCCESS_FCT(wStatus, phhalHw_GetConfig(
                pDataParams->pHalDataParams,
                PHHAL_HW_CONFIG_RXDATARATE,
                &wValueOld));

            /* Valid for the following scenarios.
             * Case1: If wConfig = PHPAL_SLI15693_CONFIG_FLAGS and wValue = PHPAL_SLI15693_FLAG_DATA_RATE flag is available, High DataRate will be set.
             * Case2: If wConfig = PHPAL_SLI15693_CONFIG_FLAGS and wValue = PHPAL_SLI15693_FLAG_DATA_RATE flag is not available, Low DataRate will be set.
             */
            if(wValue & PHPAL_SLI15693_FLAG_DATA_RATE)
            {
                /* Set high DataRate if HAL is not already configured for it */
                if(wValue & PHPAL_SLI15693_FLAG_DATA_RATE)
                {
                    if(wValueOld != PHHAL_HW_RF_RX_DATARATE_HIGH)
                    {
                        PH_CHECK_SUCCESS_FCT(wStatus, phhalHw_SetConfig(
                            pDataParams->pHalDataParams,
                            PHHAL_HW_CONFIG_RXDATARATE,
                            PHHAL_HW_RF_RX_DATARATE_HIGH));
                    }
                }
                /* Set low DataRate if HAL is not already configured for it */
                else
                {
                    if(wValueOld != PHHAL_HW_RF_RX_DATARATE_LOW)
                    {
                        PH_CHECK_SUCCESS_FCT(wStatus, phhalHw_SetConfig(
                            pDataParams->pHalDataParams,
                            PHHAL_HW_CONFIG_RXDATARATE,
                            PHHAL_HW_RF_RX_DATARATE_LOW));
                    }
                }
            }

            /* Valid for the following scenarios.
             * Case1: If wConfig = PHPAL_SLI15693_CONFIG_FLAGS and wValue = PHPAL_SLI15693_FLAG_FAST_DATA_RATE flag is available, FAST High DataRate will be set.
             * Case2: If wConfig = PHPAL_SLI15693_CONFIG_FLAGS and wValue = PHPAL_SLI15693_FLAG_FAST_DATA_RATE flag is not available, FAST Low DataRate will be set.
             */
            if(wValue & PHPAL_SLI15693_FLAG_FAST_DATA_RATE)
            {
                /* Set fast high DataRate if HAL is not already configured for it */
                if(wValue & PHPAL_SLI15693_FLAG_FAST_DATA_RATE)
                {
                    if(wValueOld != PHHAL_HW_RF_RX_DATARATE_FAST_HIGH)
                    {
                        PH_CHECK_SUCCESS_FCT(wStatus, phhalHw_SetConfig(
                            pDataParams->pHalDataParams,
                            PHHAL_HW_CONFIG_RXDATARATE,
                            PHHAL_HW_RF_RX_DATARATE_FAST_HIGH));
                    }
                }
                /* Set fast low DataRate if HAL is not already configured for it */
                else
                {
                    if(wValueOld != PHHAL_HW_RF_RX_DATARATE_FAST_LOW)
                    {
                        PH_CHECK_SUCCESS_FCT(wStatus, phhalHw_SetConfig(
                            pDataParams->pHalDataParams,
                            PHHAL_HW_CONFIG_RXDATARATE,
                            PHHAL_HW_RF_RX_DATARATE_FAST_LOW));
                    }
                }
            }

            /* retrieve flags */
            pDataParams->bFlags = (uint8_t) wValue;

            /* mask out the inventory flag */
            pDataParams->bFlags &= (uint8_t) ~(uint8_t) PHPAL_SLI15693_FLAG_INVENTORY;
            break;

        case PHPAL_SLI15693_CONFIG_TXDATARATE:
            PH_CHECK_SUCCESS_FCT(wStatus, phhalHw_Rd710_Cmd_SetConfig(
                pDataParams->pHalDataParams,
                0x0007U,
                wValue));
            break;

        case PHPAL_SLI15693_CONFIG_RXDATARATE:
            PH_CHECK_SUCCESS_FCT(wStatus, phhalHw_Rd710_Cmd_SetConfig(
                pDataParams->pHalDataParams,
                0x0008U,
                wValue));
            break;

        case PHPAL_SLI15693_CONFIG_T1_PARAMETER:
            PH_CHECK_SUCCESS_FCT(wStatus, phhalHw_Rd710_Cmd_SetConfig(
                pDataParams->pHalDataParams,
                0x0009U,
                wValue));
            break;

        case PHPAL_SLI15693_CONFIG_ENABLE_BUFFERING:
            PH_CHECK_SUCCESS_FCT(wStatus, phhalHw_Rd710_Cmd_SetConfig(
                pDataParams->pHalDataParams,
                0x0006U,
                wValue));
            break;

        default:
            PH_CHECK_SUCCESS_FCT(wStatus, phhalHw_Rd710_Cmd_SetConfig(
                pDataParams->pHalDataParams,
                wConfig,
                wValue));
            break;
    }

    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_PAL_SLI15693);
}

phStatus_t phpalSli15693_Rd710_GetConfig(phpalSli15693_Rd710_DataParams_t * pDataParams, uint16_t wConfig, uint16_t * pValue)
{
    phStatus_t PH_MEMLOC_REM wStatus = 0;

    switch(wConfig)
    {
        case PHPAL_SLI15693_CONFIG_FLAGS:
            *pValue = pDataParams->bFlags;
            break;

        case PHPAL_SLI15693_CONFIG_ADD_INFO:
            *pValue = pDataParams->wAdditionalInfo;
            break;

        case PHPAL_SLI15693_CONFIG_RXDATARATE:
            PH_CHECK_SUCCESS_FCT(wStatus, phhalHw_Rd710_Cmd_GetConfig(
                pDataParams->pHalDataParams,
                0x0008U,
                pValue));
            break;

        case PHPAL_SLI15693_CONFIG_T1_PARAMETER:
            PH_CHECK_SUCCESS_FCT(wStatus, phhalHw_Rd710_Cmd_GetConfig(
                pDataParams->pHalDataParams,
                0x0009U,
                pValue));
            break;

        case PHPAL_SLI15693_CONFIG_ENABLE_BUFFERING:
            PH_CHECK_SUCCESS_FCT(wStatus, phhalHw_Rd710_Cmd_GetConfig(
                pDataParams->pHalDataParams,
                0x0006U,
                pValue));
            break;

        default:
            PH_CHECK_SUCCESS_FCT(wStatus, phhalHw_Rd710_Cmd_GetConfig(
                pDataParams->pHalDataParams,
                wConfig,
                pValue));
            break;
    }

    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_PAL_SLI15693);
}

#endif /* NXPBUILD__PHPAL_SLI15693_SW */
