/*
 * Copyright 2022 - 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Example program to demonstrate ASymmetric features.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PH_EXAMPLE_CRYPTOLIBFOOTPRINT_ASYM_H
#define PH_EXAMPLE_CRYPTOLIBFOOTPRINT_ASYM_H

#include "Example-CryptoLibFootprint.h"

#ifdef NXPBUILD__PH_CRYPTOASYM
#include <phCryptoASym.h>

#define KEY_ADDRESS             1

#define KEY_PAIR_PRIVATE_KEY    0
#define KEY_PAIR_PUBLIC_KEY     1

enum Component_CryptoASym
{
    CRYPTOASYM_TEMPORARY = 0,

#ifdef NXPBUILD__PH_CRYPTOASYM_MBEDTLS
    CRYPTOASYM_MBEDTLS,
#endif /* NXPBUILD__PH_CRYPTOASYM_MBEDTLS */

    CRYPTOASYM_MAX
};

enum Demos_ASymmetric
{
    MESSAGE_DIGEST = 1,
    GENERATE_KEYPAIR,
    EXPORT_KEYS,
    SIGN_MESSAGE,
    VERIFY_MESSAGE,
    COMPUTE_SHARED_SECRET,

    LOAD_KEYPAIR_DIRECT,

#ifdef NXPBUILD__PH_KEYSTORE_ASYM
    LOAD_KEYPAIR_KEYSTORE,
#endif /* NXPBUILD__PH_KEYSTORE_ASYM */

    VERIFY_SIGNATURE
};

#ifdef NXPBUILD__PH_CRYPTOASYM_MBEDTLS
phCryptoASym_mBedTLS_DataParams_t stCryptoASym_mBedTLS;
#endif /* NXPBUILD__PH_CRYPTOASYM_MBEDTLS */

phStatus_t Demo_ASymmetricCrypto_Main();
phStatus_t Demo_ASymmetricCrypto_Features();

#ifdef NXPBUILD__PH_KEYSTORE_ASYM
phStatus_t UpdateKeystore_ASym();
#endif /* NXPBUILD__PH_KEYSTORE_ASYM */

phStatus_t MessageDigest(uint8_t * pMessage, uint16_t wMsgLen);
phStatus_t GenerateKeyPair();
phStatus_t ExportKey();
phStatus_t Message_Sign(uint8_t * pMessage, size_t wMsgLen, uint8_t bPrintLogs);
phStatus_t Message_Verify(uint8_t * pMessage, size_t wMsgLen);
phStatus_t ComputeSharedSecret();
phStatus_t LoadKeys_Direct(uint8_t * pPrivateKey, uint16_t wPrivateKeyLen, uint8_t * pPublicKey, uint16_t wPublicKeyLen);

#ifdef NXPBUILD__PH_KEYSTORE_ASYM
phStatus_t LoadKeys(uint16_t wKeyNo, uint16_t wKeyPair);
#endif /* NXPBUILD__PH_KEYSTORE_ASYM */

phStatus_t VerifySignature();

#endif /* NXPBUILD__PH_CRYPTOASYM */

#endif /* PH_EXAMPLE_CRYPTOLIBFOOTPRINT_ASYM_H */
