/*
 * Copyright 2022 - 2023, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Example program to demonstrate Symmetric features.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PH_EXAMPLE_CRYPTOLIBFOOTPRINT_SYM_H
#define PH_EXAMPLE_CRYPTOLIBFOOTPRINT_SYM_H

#include "Example-CryptoLibFootprint.h"

#ifdef NXPBUILD__PH_CRYPTOSYM
#include <phCryptoSym.h>

#define DES_KEY_ADDRESS     1
#define DES_KEY_VERSION     0

#define DES2K3_KEY_ADDRESS  1
#define DES2K3_KEY_VERSION  0

#define DES3K3_KEY_ADDRESS  1
#define DES3K3_KEY_VERSION  0

#define AES128_KEY_ADDRESS  2
#define AES128_KEY_VERSION  0

#define AES192_KEY_ADDRESS  2
#define AES192_KEY_VERSION  0

#define AES256_KEY_ADDRESS  2
#define AES256_KEY_VERSION  0

enum Component_CryptoSym
{
    CRYPTOSYM_TEMPORARY = 0,

#ifdef NXPBUILD__PH_CRYPTOSYM_SW
    CRYPTOSYM_SOFTWARE,
#endif /* NXPBUILD__PH_CRYPTOSYM_SW */

#ifdef NXPBUILD__PH_CRYPTOSYM_MBEDTLS
    CRYPTOSYM_MBEDTLS,
#endif /* NXPBUILD__PH_CRYPTOSYM_MBEDTLS */

#if !defined (NXPBUILD__PH_CRYPTOSYM_SW) && !defined (NXPBUILD__PH_CRYPTOSYM_MBEDTLS) && !defined (NXPBUILD__PH_CRYPTOSYM_DUT)
#error Please enable any one of Symmetric Crypto component to proceed
#endif /* NXPBUILD__PH_CRYPTOSYM_SW */

    CRYPTOSYM_MAX
};

enum Demo_Symmetric
{
    SYMMETRIC_DEFAULT = 0,

    LOAD_KEY_DIRECT,

#ifdef NXPBUILD__PH_KEYSTORE
    LOAD_KEY_KEYSTORE,
#endif /* NXPBUILD__PH_KEYSTORE */

    ENCRYPT_DECRYPT,
    DIVERSIFICATION_DIRECT_KEY,

#ifdef NXPBUILD__PH_KEYSTORE
    DIVERSIFICATION_KEYSTORE,
#endif /* NXPBUILD__PH_KEYSTORE */

    MAC
};

enum Demo_Symmetric_LoadKeyTypes
{
    LOAD_KEY_TYPE_DEFAULT = 0,

#ifndef MBEDTLS_DES_ALT
    LOAD_KEY_TYPE_DES,
#endif /* MBEDTLS_DES_ALT */

    LOAD_KEY_TYPE_2K3DES,
    LOAD_KEY_TYPE_3K3DES,
    LOAD_KEY_TYPE_AES128,

#ifndef MBEDTLS_AES_ALT
    LOAD_KEY_TYPE_AES192,
#endif /* MBEDTLS_AES_ALT */

    LOAD_KEY_TYPE_AES256
};

#ifdef NXPBUILD__PH_CRYPTOSYM_SW
phCryptoSym_Sw_DataParams_t stCryptoSym_Sw;
#endif /* NXPBUILD__PH_CRYPTOSYM_SW */

#ifdef NXPBUILD__PH_CRYPTOSYM_MBEDTLS
phCryptoSym_mBedTLS_DataParams_t stCryptoSym_mBedTLS;
#endif /* NXPBUILD__PH_CRYPTOSYM_MBEDTLS */

phStatus_t Demo_SymmetricCrypto_Main();
phStatus_t Demo_SymmetricCrypto_Features();

#ifdef NXPBUILD__PH_KEYSTORE
phStatus_t AddKeyToKeyStore_Sym(uint8_t bKeyNo, uint8_t bKeyVer, uint16_t wKeyType, uint8_t * pKey);
#endif /* NXPBUILD__PH_KEYSTORE */

phStatus_t LoadKeyDirect();
phStatus_t LoadKeyKeystore();
phStatus_t Message_Encrypt_Decrypt(uint8_t * pMessage, uint16_t wMesgLen);
phStatus_t Diversification(uint8_t bUseKeyStore);
phStatus_t ComputeMAC(uint8_t * pMessage, uint16_t wMesgLen);

#endif /* NXPBUILD__PH_CRYPTOSYM */

#endif /* PH_EXAMPLE_CRYPTOLIBFOOTPRINT_SYM_H */
