/*
 * Copyright 2013, 2015, 2019, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/*
 * RdCardSim specific HAL-Component of Reader Library Framework.
 * $RCSfile $
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHHALHW_RDCARDSIM_CMD_H
#define PHHALHW_RDCARDSIM_CMD_H

#include <ph_Status.h>
#include <phhalHw.h>


phStatus_t phhalHw_RdCardSim_Command_Int (
    phhalHw_RdCardSim_DataParams_t * pDataParams,
    uint8_t * pTxBuffer
    );

phStatus_t phhalHw_RdCardSim_Cmd_DownloadImage (
    phhalHw_RdCardSim_DataParams_t * pDataParams,
    uint32_t dwAddress,
    uint8_t bMemType,
    uint16_t *pImageLen,
    uint8_t * pImage
    );

phStatus_t phhalHw_RdCardSim_Cmd_UploadImage (
    phhalHw_RdCardSim_DataParams_t * pDataParams,
    uint32_t dwAddress,
    uint8_t bMemType,
    uint16_t *pImageLen,
    uint8_t * pImage
    );

phStatus_t phhalHw_RdCardSim_Cmd_WaferTestExchange(
                                      phhalHw_RdCardSim_DataParams_t * pDataParams,
                                      uint16_t    wOption,
                                      uint8_t   * pTxBuffer,
                                      uint16_t    wTxLength,
                                      uint8_t  ** ppRxBuffer,
                                      uint16_t  * pRxLength
                                      );

#endif /* PHHALHW_RDCARDSIM_CMD_H */
