/*
 * Copyright 2013, 2016 - 2020, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Internal definitions for SAMAV2 specific HAL-Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHHALHW_SAMAV2_CMD_H
#define PHHALHW_SAMAV2_CMD_H

#include <ph_Status.h>
#include <phhalHw.h>

#ifdef __cplusplus
extern "C" {
#endif	/* __cplusplus */

#ifdef  NXPBUILD__PHHAL_HW_SAMAV2

/** \defgroup phhalHw_SamAV2_Cmd_Status SAM Status Codes
 * \brief Defines used accross the whole SAM implementation for the status codes returned by Sam hardware.
 * @{
 */
#define PHHAL_HW_SAMAV2_RET_CODE_OK											0x9000	/**< Correct execution */
#define PHHAL_HW_SAMAV2_RET_CODE_OK_1BIT									0x9001	/**< Correct execution, 1 bits received */
#define PHHAL_HW_SAMAV2_RET_CODE_OK_2BIT									0x9002	/**< Correct execution, 2 bits received */
#define PHHAL_HW_SAMAV2_RET_CODE_OK_3BIT									0x9003	/**< Correct execution, 3 bits received */
#define PHHAL_HW_SAMAV2_RET_CODE_OK_4BIT									0x9004	/**< Correct execution, 4 bits received */
#define PHHAL_HW_SAMAV2_RET_CODE_OK_5BIT									0x9005	/**< Correct execution, 5 bits received */
#define PHHAL_HW_SAMAV2_RET_CODE_OK_6BIT									0x9006	/**< Correct execution, 7 bits received */
#define PHHAL_HW_SAMAV2_RET_CODE_OK_7BIT									0x9007	/**< Correct execution, 7 bits received */
#define PHHAL_HW_SAMAV2_RET_CODE_OK_CHAINING_ACTIVE							0x90AF	/**< Correct execution - 2 Part Command */
#define PHHAL_HW_SAMAV2_RET_CODE_COMM_IO_TIMEOUT							0x90E0	/**< no response from card (no card in field) */
#define PHHAL_HW_SAMAV2_RET_CODE_COMM_BITCNT_PROTOCOL						0x90E1	/**< bit count error or protocol error */
#define PHHAL_HW_SAMAV2_RET_CODE_COMM_PARITY								0x90E2	/**< parity error */
#define PHHAL_HW_SAMAV2_RET_CODE_COMM_FIFO_BUF_OVERFLOW						0x90E3	/**< MFRC52X FIFO buffer overflow */
#define PHHAL_HW_SAMAV2_RET_CODE_COMM_CRC_FAILURE							0x90E4	/**< CRC error */
#define PHHAL_HW_SAMAV2_RET_CODE_COMM_RF_FAILURE							0x90E5	/**< MFRC52X RF error */
#define PHHAL_HW_SAMAV2_RET_CODE_COMM_TEMP_FAILURE							0x90E6	/**< MFRC52X temperature error */
#define PHHAL_HW_SAMAV2_RET_CODE_COMM_FIFO_WRITE							0x90E7	/**< MFRC52X FIFO write error */
#define PHHAL_HW_SAMAV2_RET_CODE_COMM_COLLISION								0x90E8	/**< collision error */
#define PHHAL_HW_SAMAV2_RET_CODE_COMM_INTERNAL_BUF_OVERFLOW					0x90E9	/**< internal transaction buffer overflow (more than 256 bytes received from the card) */
#define PHHAL_HW_SAMAV2_RET_CODE_ISO_UID_BCC_INCORRECT						0x90EA	/**< UID check byte (BCC) incorrect */
#define PHHAL_HW_SAMAV2_RET_CODE_ISO_WRONG_BNR								0x90EB	/**< Invalid Layer 4 Block number in PCB */
#define PHHAL_HW_SAMAV2_RET_CODE_ISO_INVALID_FORMAT							0x90EC	/**< invalid format received in any ISO command */
#define PHHAL_HW_SAMAV2_RET_CODE_ISO_INVALID_PARAMETER						0x90ED	/**< invalid parameter received in any ISO command*/
#define PHHAL_HW_SAMAV2_RET_CODE_ISO_UID_INCOMPLETE							0x90C0	/**< UID not yet complete in card selection */
#define PHHAL_HW_SAMAV2_RET_CODE_PROT_MIFARE_ERROR							0x90EF	/**< MIFARE (R) protocol error */
#define PHHAL_HW_SAMAV2_RET_CODE_PROT_MIFARE_NACK_0							0x90F0	/**< MIFARE (R) NACK 0 received */
#define PHHAL_HW_SAMAV2_RET_CODE_PROT_MIFARE_NACK_1							0x90F1	/**< MIFARE (R) NACK 1 received */
#define PHHAL_HW_SAMAV2_RET_CODE_PROT_MIFARE_NACK_2							0x90F2	/**< MIFARE (R) NACK 2 received */
#define PHHAL_HW_SAMAV2_RET_CODE_PROT_MIFARE_NACK_3							0x90F3	/**< MIFARE (R) NACK 3 received */
#define PHHAL_HW_SAMAV2_RET_CODE_PROT_MIFARE_NACK_4							0x90F4	/**< MIFARE (R) NACK 4 received */
#define PHHAL_HW_SAMAV2_RET_CODE_PROT_MIFARE_NACK_5							0x90F5	/**< MIFARE (R) NACK 5 received */
#define PHHAL_HW_SAMAV2_RET_CODE_PROT_MIFARE_PLUS_ERROR						0x90BE	/**< MIFARE PLUS (R) protocol error */
#define PHHAL_HW_SAMAV2_RET_CODE_INS_MIFARE_PLUS_ERROR						0x90BF	/**< MIFARE PLUS (R) return code error */
#define PHHAL_HW_SAMAV2_RET_CODE_PROT_DESFIRE_ERROR							0x90DF	/**< MIFARE DESFIRE (R) protocol error */
#define PHHAL_HW_SAMAV2_RET_CODE_CRYPTO_FAILURE								0x901E	/**< MAC verification failed, CRC/Padding failed, auth error, integrity error */
#define PHHAL_HW_SAMAV2_RET_CODE_ISO7816_WRONG_LENGTH_LC					0x6700	/**< Wrong Length or LC byte */
#define PHHAL_HW_SAMAV2_RET_CODE_ISO7816_WRONG_P1P2							0x6A86	/**< Wrong P1 P2 */
#define PHHAL_HW_SAMAV2_RET_CODE_ISO7816_WRONG_LE							0x6C00	/**< Wrong LE */
#define PHHAL_HW_SAMAV2_RET_CODE_ISO7816_UNKNOWN_INS						0x6D00	/**< Wrong Instruction */
#define PHHAL_HW_SAMAV2_RET_CODE_ISO7816_WRONG_CLASS						0x6E00	/**< Wrong Class */
#define PHHAL_HW_SAMAV2_RET_CODE_ISO7816_COMMAND_NOT_ALLOWED				0x6986	/**< Command not allowed */
#define PHHAL_HW_SAMAV2_RET_CODE_ISO7816_WRONG_PARAMS_FOR_INS				0x6A80	/**< Wrong parameters for current instruction */
#define PHHAL_HW_SAMAV2_RET_CODE_HW_EEPROM									0x6400	/**< Memory Range, EEProm busy or access collision in EEPROM module */
#define PHHAL_HW_SAMAV2_RET_CODE_HW_RC5XX									0x6401	/**< MFRC52X interface error */
#define PHHAL_HW_SAMAV2_RET_CODE_HW_EE_HIGH_VOLTAGE							0x6581	/**< High voltage error in SAM EEprom module*/
#define PHHAL_HW_SAMAV2_RET_CODE_KEY_CREATE_FAILED							0x6501	/**< Creation of key entry failed */
#define PHHAL_HW_SAMAV2_RET_CODE_KEY_REF_NO_INVALID							0x6502	/**< Invalid key reference number */
#define PHHAL_HW_SAMAV2_RET_CODE_KEY_KUC_NO_INVALID							0x6503	/**< Invalid key usage counter reference number */
#define PHHAL_HW_SAMAV2_RET_CODE_KEY_INTEGRITY_ERROR						0x6984	/**< Key integrity error, wrong key reference */
#define PHHAL_HW_SAMAV2_RET_CODE_KEY_VERSION_INVALID						0x6A82	/**< Invalid key version */
#define PHHAL_HW_SAMAV2_RET_CODE_COND_USE_NOT_SATISFIED						0x6985	/**< conditions of use not satisfied, invalid key type, invalid CID, key limit reached */
#define PHHAL_HW_SAMAV2_RET_CODE_INTEGRITY_ERROR							0x6982	/**< Integrity error */
#define PHHAL_HW_SAMAV2_RET_CODE_INCOMPLETE_CHAINING						0x6883	/**< Invalid chaining sequence */
#define PHHAL_HW_SAMAV2_RET_CODE_HOST_PROTECTION_ERROR						0x6A84	/**< SAM Host Protection Error. */
/**
 * end of phhalHw_SamAV2_Cmd_Status
 * @}
 */

/** \defgroup phhalHw_SamAV2_Cmd_Cust_Errors SAM Custom Error Codes
 * \brief SamAV2 Custom Error Codes for the respective status codes returned by Sam hardwre.
 * @{
 */
#define PHHAL_HW_SAMAV2_ERR_HW_EEPROM						(PH_ERR_CUSTOM_BEGIN + 0)	/**< Custom error code for Sam's Resp.ISO6400 */
#define PHHAL_HW_SAMAV2_ERR_HW_RC5XX						(PH_ERR_CUSTOM_BEGIN + 1)	/**< Custom error code for Sam's Resp.ISO6401 */
#define PHHAL_HW_SAMAV2_ERR_KEY_CREATE_FAILED				(PH_ERR_CUSTOM_BEGIN + 2)	/**< Custom error code for Sam's Resp.ISO6501 */
#define PHHAL_HW_SAMAV2_ERR_KEY_REF_NO_INVALID				(PH_ERR_CUSTOM_BEGIN + 3)	/**< Custom error code for Sam's Resp.ISO6502 */
#define PHHAL_HW_SAMAV2_ERR_KEY_KUC_NO_INVALID				(PH_ERR_CUSTOM_BEGIN + 4)	/**< Custom error code for Sam's Resp.ISO6503 */
#define PHHAL_HW_SAMAV2_ERR_HW_EE_HIGH_VOLTAGE              (PH_ERR_CUSTOM_BEGIN + 5)	/**< Custom error code for Sam's Resp.ISO6581 */
#define PHHAL_HW_SAMAV2_ERR_ISO7816_WRONG_LENGTH_LC			(PH_ERR_CUSTOM_BEGIN + 6)	/**< Custom error code for Sam's Resp.ISO6700 */
#define PHHAL_HW_SAMAV2_ERR_INCOMPLETE_CHAINING				(PH_ERR_CUSTOM_BEGIN + 7)	/**< Custom error code for Sam's Resp.ISO6883 */
#define PHHAL_HW_SAMAV2_ERR_INTEGRITY_ERROR					(PH_ERR_CUSTOM_BEGIN + 8)	/**< Custom error code for Sam's Resp.ISO6982 */
#define PHHAL_HW_SAMAV2_ERR_KEY_INTEGRITY_ERROR				(PH_ERR_CUSTOM_BEGIN + 9)	/**< Custom error code for Sam's Resp.ISO6984 */
#define PHHAL_HW_SAMAV2_ERR_COND_USE_NOT_SATISFIED			(PH_ERR_CUSTOM_BEGIN + 10)	/**< Custom error code for Sam's Resp.ISO6985 */
#define PHHAL_HW_SAMAV2_ERR_ISO7816_COMMAND_NOT_ALLOWED		(PH_ERR_CUSTOM_BEGIN + 11)	/**< Custom error code for Sam's Resp.ISO6986 */
#define PHHAL_HW_SAMAV2_ERR_ISO7816_WRONG_PARAMS_FOR_INS	(PH_ERR_CUSTOM_BEGIN + 12)	/**< Custom error code for Sam's Resp.ISO6A80 */
#define PHHAL_HW_SAMAV2_ERR_KEY_VERSION_INVALID				(PH_ERR_CUSTOM_BEGIN + 13)	/**< Custom error code for Sam's Resp.ISO6A82 */
#define PHHAL_HW_SAMAV2_ERR_HOST_PROTECTION					(PH_ERR_CUSTOM_BEGIN + 14)	/**< Custom error code for Sam's Resp.ISO6A84 */
#define PHHAL_HW_SAMAV2_ERR_ISO7816_WRONG_P1P2				(PH_ERR_CUSTOM_BEGIN + 15)	/**< Custom error code for Sam's Resp.ISO6A86 */
#define PHHAL_HW_SAMAV2_ERR_ISO7816_WRONG_LE				(PH_ERR_CUSTOM_BEGIN + 16)	/**< Custom error code for Sam's Resp.ISO6C00 */
#define PHHAL_HW_SAMAV2_ERR_ISO7816_UNKNOWN_INS				(PH_ERR_CUSTOM_BEGIN + 17)	/**< Custom error code for Sam's Resp.ISO6D00 */
#define PHHAL_HW_SAMAV2_ERR_ISO7816_UNKNOWN_CLASS			(PH_ERR_CUSTOM_BEGIN + 18)	/**< Custom error code for Sam's Resp.ISO6E00 */
#define PHHAL_HW_SAMAV2_ERR_CRYPTO							(PH_ERR_CUSTOM_BEGIN + 19)	/**< Custom error code for Sam's Resp.ISO901E */
#define PHHAL_HW_SAMAV2_ERR_MIFARE_PLUS_CRYPTO				(PH_ERR_CUSTOM_BEGIN + 20)	/**< Custom error code for Sam's Resp.ISO90BE */
#define PHHAL_HW_SAMAV2_ERR_MIFARE_PLUS_GEN					(PH_ERR_CUSTOM_BEGIN + 21)	/**< Custom error code for Sam's Resp.ISO90BF */
#define PHHAL_HW_SAMAV2_ERR_ISO_UID_INCOMPLETE				(PH_ERR_CUSTOM_BEGIN + 22)	/**< Custom error code for Sam's Resp.ISO90C0 */
#define PHHAL_HW_SAMAV2_ERR_DESFIRE_GEN						(PH_ERR_CUSTOM_BEGIN + 23)	/**< Custom error code for Sam's Resp.ISO90DF */
#define PHHAL_HW_SAMAV2_ERR_ISO_UID_BCC_INCORRECT			(PH_ERR_CUSTOM_BEGIN + 24)	/**< Custom error code for Sam's Resp.ISO90EA */
#define PHHAL_HW_SAMAV2_ERR_ISO_WRONG_BNR					(PH_ERR_CUSTOM_BEGIN + 25)	/**< Custom error code for Sam's Resp.ISO90EB */
#define PHHAL_HW_SAMAV2_ERR_ISO_INVALID_FORMAT				(PH_ERR_CUSTOM_BEGIN + 26)	/**< Custom error code for Sam's Resp.ISO90EC */
#define PHHAL_HW_SAMAV2_ERR_ISO_INVALID_PARAMETER			(PH_ERR_CUSTOM_BEGIN + 27)	/**< Custom error code for Sam's Resp.ISO90ED */
#define PHHAL_HW_SAMAV2_ERR_MIFARE_GEN						(PH_ERR_CUSTOM_BEGIN + 28)	/**< Custom error code for Sam's Resp.ISO90EF */
#define PHHAL_HW_SAMAV2_ERR_MIFARE_NAK0						(PH_ERR_CUSTOM_BEGIN + 29)	/**< Custom error code for Sam's Resp.ISO90F0 */
#define PHHAL_HW_SAMAV2_ERR_MIFARE_NAK1						(PH_ERR_CUSTOM_BEGIN + 30)	/**< Custom error code for Sam's Resp.ISO90F1 */
#define PHHAL_HW_SAMAV2_ERR_MIFARE_NAK4						(PH_ERR_CUSTOM_BEGIN + 31)	/**< Custom error code for Sam's Resp.ISO90F4 */
#define PHHAL_HW_SAMAV2_ERR_MIFARE_NAK5						(PH_ERR_CUSTOM_BEGIN + 32)	/**< Custom error code for Sam's Resp.ISO90F5 */
#define PHHAL_HW_SAMAV2_ERR_MIFARE_NAK2						(PH_ERR_CUSTOM_BEGIN + 33)	/**< Custom error code for Sam's Resp.ISO90F2 */
#define PHHAL_HW_SAMAV2_ERR_MIFARE_NAK3						(PH_ERR_CUSTOM_BEGIN + 34)	/**< Custom error code for Sam's Resp.ISO90F3 */
#define PHHAL_HW_SAMAV2_ERR_OK_CHAINING_ACTIVE				(PH_ERR_CUSTOM_BEGIN + 35)	/**< Custom error code for Sam's Resp.ISO90AF */
/**
 * end of phhalHw_SamAV2_Cmd_Cust_Errors
 * @}
 */

/** \defgroup phhalHw_SamAV2_Cmd_Global SAM Global values.
 * \brief SamAV2 Global macro values that are used for most of the commands.
 * @{
 */
#define PHHAL_HW_SAMAV2_ISO7816_LAST_FRAME									0x00U	/**< Indication last frame in a cipher sequence */
#define PHHAL_HW_SAMAV2_ISO7816_CHAINED_FRAME								0xAFU	/**< Indication lnon ast frame in a cipher sequence */
/**
 * end of phhalHw_SamAV2_Cmd_Global
 * @}
 */

 /** Macros used for command buffer and other buffer processing. */
#define PHHAL_HW_SAMAV2_ISO7816_HEADER_LENGTH								0x05U	/**< Length of ISO7816 header */
#define PHHAL_HW_SAMAV2_ISO7816_HEADER_LE_LENGTH							0x06U	/**< Length of ISO7816 header including LE byte*/
#define PHHAL_HW_SAMAV2_ISO7816_HEADER_NO_LC_LENGTH							0x04U	/**< Length of ISO7816 header excluding LC byte*/
#define PHHAL_HW_SAMAV2_ISO7816_CLA_POS										0x00U	/**< Pos of CLA byte in ISO7816 header */
#define PHHAL_HW_SAMAV2_ISO7816_INS_POS										0x01U	/**< Pos of INS byte in ISO7816 header */
#define PHHAL_HW_SAMAV2_ISO7816_P1_POS										0x02U	/**< Pos of P1 byte in ISO7816 header */
#define PHHAL_HW_SAMAV2_ISO7816_P2_POS										0x03U	/**< Pos of P2 byte in ISO7816 header */
#define PHHAL_HW_SAMAV2_ISO7816_LC_POS										0x04U	/**< Pos of LC byte in ISO7816 header */
#define PHHAL_HW_SAMAV2_ISO7816_LE_NO_LC_POS								0x04U	/**< Pos of LE byte in ISO7816 header and no LC */
#define PHHAL_HW_SAMAV2_ISO7816_SW1SW2_LENGTH								0x02U	/**< Length of SW1SW2 in ISO7816 */
#define PHHAL_HW_SAMAV2_ISO7816_EXCHANGE_APP_DATA_MAX						0xFFU	/**< Max Length of Transparent Exchange Response */
#define PHHAL_HW_SAMAV2_ISO7816_EXCHANGE_RESPONSE_MAX						0xF8U	/**< Max Length of Transparent Exchange Response */
#define PHHAL_HW_SAMAV2_ISO7816_CLA_BYTE									0x80U	/**< Cla Byte of SamAV2 Commands */
#define PHHAL_HW_SAMAV2_ISO7816_DEFAULT_P1_BYTE								0x00U	/**< Default Ins Byte of SamAV2 Commands */
#define PHHAL_HW_SAMAV2_ISO7816_DEFAULT_P2_BYTE								0x00U	/**< Default Ins Byte of SamAV2 Commands */
#define PHHAL_HW_SAMAV2_ISO7816_DEFAULT_LE_BYTE								0x00U	/**< Default Le Byte of SamAV2 Commands */
#define PHHAL_HW_SAMAV2_ISO7816_MAX_LC_MULTIPLE_AESBLOCK					0xF0	/**< Maximal data field length, which is still a multiple of AES block length. */

#define PHHAL_HW_SAMAV2_CMD_TRANSPARENT_EXCHANGE_INS						0x7E	/** < ISO 14443-3 Transparent Exchange command */

/**
 * \brief Exchange commands with the SAM
 *
 * \return Status code
 * \retval #PH_ERR_SUCCESS Operation successful.
 * \retval Other Depending on implementation and underlaying component.
 */
phStatus_t phhalHw_SamAV2_Cmd_7816Exchange(
		phhalHw_SamAV2_DataParams_t * pDataParams,									/**< [In] Pointer to this layer's parameter structure. */
		uint16_t wOption,															/**< [In] Buffering options.
																					 *			\arg #PH_EXCHANGE_DEFAULT
																					 *			\arg #PH_EXCHANGE_BUFFER_FIRST
																					 *			\arg #PH_EXCHANGE_BUFFER_CONT
																					 *			\arg #PH_EXCHANGE_BUFFER_LAST
																					 *			\arg #PH_EXCHANGE_TXCHAINING
																					 *			\arg #PH_EXCHANGE_RXCHAINING
																					 *
																					 *			#PH_EXCHANGE_TXCHAINING should be used to exchange chunks of data.
																					 *			#PH_EXCHANGE_RXCHAINING should be used to receive chunks of data.
																					 */
		uint8_t * pTxBuffer,														/**< [In] The command to be be sent to Sam hardware. */
		uint16_t wTxLength,															/**< [In] Length of bytes available in TxBuffer. */
		uint8_t ** ppRxBuffer,														/**< [Out] The data received form SAM hardware. */
		uint16_t * pRxLength														/**< [Out] Length of bytes available in RxBuffer. */
	);




/*************************************************************************************************************************/
/*********************************************** Security and Configuration **********************************************/
/*************************************************************************************************************************/

/** \defgroup phhalHw_SamAV2_Cmd_Security_Configuration Security and Configuration
 * \brief SAM commands used for host communication and security related configuration.
 * @{
 */

/** \name Sam AV2 command code for Sam Security and configuration feature. */
/** @{ */

#define PHHAL_HW_SAMAV2_CMD_GET_VERSION_INS									0x60	/**< CMD Byte for GetVersion command */

/** @} */


#define PHHAL_HW_SAMAV2_CMD_GET_VERSION_DATA_LENGTH							0x00	/**< CMD length of GetVersion command */
#define PHHAL_HW_SAMAV2_CMD_GET_VERSION_RESPONSE_LENGTH						0x1F	/**< Response length for GetVersion command */
#define PHHAL_HW_SAMAV2_CMD_GET_VERSION_RESPONSE_UID_OFFSET					0x0E	/**< Offset of first UID byte field in the Version field */
#define PHHAL_HW_SAMAV2_CMD_GET_VERSION_RESPONSE_HOSTMODE_POS				0x1E	/**< Offset of first UID byte field in the Version field */


/**
 * \brief Get version information from the SAM.
 *
 * \return Status code
 * \retval #PH_ERR_SUCCESS Operation successful.
 * \retval Other Depending on implementation and underlaying component.
 */
phStatus_t phhalHw_SamAV2_Cmd_SAM_GetVersion(
	phhalHw_SamAV2_DataParams_t * pDataParams,										/**< [In] Pointer to this layer's parameter structure. */
	uint8_t * pVersion,																/**< [Out] Buffer containing the read version. It has to be 31 bytes long. */
	uint8_t * pVersionLength														/**< [Out] Amount of valid bytes in the version buffer. */
);


/**
 * end of phhalHw_SamAV2_Cmd_Security_Configuration
 * @}
 */




/*************************************************************************************************************************/
/***************************************************** Key Management ****************************************************/
/*************************************************************************************************************************/

/** \defgroup phhalHw_SamAV2_Cmd_KeyManagment Key Management
 * \brief SAM commands used for key management related configuration.
 * @{
 */

/** \name Sam AV2 command code for Sam Key Management feature. */
/** @{ */
#define PHHAL_HW_SAMAV2_CMD_GET_KEYENTRY_INS								0x64U	/**< CMD Byte for GetKeyEntry command */
#define PHHAL_HW_SAMAV2_CMD_GET_KUCENTRY_INS								0x6CU	/**< CMD Byte for GetKUCEntry command */
/** @} */

#define PHHAL_HW_SAMAV2_CMD_AV1_KEY_ENTRY_RESPONSE_NO_VC_LENGTH				0x0BU   /**< Response in AV1 Mode length if VC is not available */
#define PHHAL_HW_SAMAV2_CMD_AV1_KEY_ENTRY_RESPONSE_VC_LENGTH				0x0CU   /**< Response in AV1 Mode length if VC is available */
#define PHHAL_HW_SAMAV2_CMD_AV2_KEY_ENTRY_RESPONSE_NO_VC_LENGTH				0x0CU   /**< Response in AV2 Mode length if VC is not available */
#define PHHAL_HW_SAMAV2_CMD_AV2_KEY_ENTRY_RESPONSE_VC_LENGTH				0x0DU   /**< Response in AV2 Mode length if VC is available */
#define PHHAL_HW_SAMAV2_CMD_AV2_KEY_ENTRY_SIZE								0x0DU
#define PHHAL_HW_SAMAV2_CMD_KEY_C_VALID_OFFSET								0x04U
#define PHHAL_HW_SAMAV2_CMD_DF_AID_OFFSET									0x05U


/**
 * \brief Get information about a key entry.
 *
 * \return Status code
 * \retval #PH_ERR_SUCCESS Operation successful.
 * \retval Other Depending on implementation and underlaying component.
 */
phStatus_t phhalHw_SamAV2_Cmd_SAM_GetKeyEntry(
	phhalHw_SamAV2_DataParams_t * pDataParams,										/**< [In] Pointer to this layer's parameter structure. */
	uint8_t bKeyNo,																	/**< [In] Reference number of the key entry to be returned (00h to 7Fh). */
	uint8_t * pKeyEntry,															/**< [Out] Buffer containing the information about the key entry.
																					 *		   This buffer has to be 13 bytes long.
																					 */
	uint8_t * bKeyEntryLength														/**< [Out] Amount of valid bytes in pKeyEntry. */
);


/**
* \brief Get information about a key usage counter (KUC).
*
* \return Status code
* \retval #PH_ERR_SUCCESS Operation successful.
* \retval Other Depending on implementation and underlaying component.
*/
phStatus_t phhalHw_SamAV2_Cmd_SAM_GetKUCEntry(
	phhalHw_SamAV2_DataParams_t * pDataParams,										/**< [In] Pointer to this layer's parameter structure. */
	uint8_t bKucNo,																	/**< [In] Reference number of the key usage counter to be returned (00h to 0Fh). */
	uint8_t * pKucEntry																/**< [Out] Buffer containing the KUC entry. This buffer has to be 10 bytes long. */
);


/**
 * end of phhalHw_SamAV2_Cmd_KeyManagment
 * @}
 */





#endif /* NXPBUILD__PHHAL_HW_SAMAV2 */

#ifdef __cplusplus
} /* Extern C */
#endif

#endif /* PHHALHW_SAMAV2_CMD_H */
