/*
 * Copyright 2013 - 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Build System Definitions for Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PH_NXPBUILD_H
#define PH_NXPBUILD_H

/** \defgroup ph_NxpBuild NXP Build
 * \brief Controls build behavior of components.
 * @{
 */

/* NXPBUILD_DELETE: included code lines should be always removed from code */

/* NXP Build defines                            */
/* use #define to include components            */
/* comment out #define to exclude components    */

/* DEBUG build mode */

#ifdef _DEBUG
#endif

/* BAL components ------------------------------------------------------------------------------------------------------------ */
#define NXPBUILD__PHBAL_REG_STUB                            /**< Stub BAL definition */
#define NXPBUILD__PHBAL_REG_SERIALWIN                       /**< SerialWin BAL definition */
#define NXPBUILD__PHBAL_REG_PCSCWIN                         /**< PcscWin BAL definition */
#define NXPBUILD__PHBAL_REG_RD70XUSBWIN                     /**< Rd70X_UsbWin BAL definition */
#define NXPBUILD__PHBAL_REG_PIPELIN                         /**< PipeLin BAL definition */
#define NXPBUILD__PHBAL_REG_RD710SAM                        /**< Rd710Sam BAL definition */
#define NXPBUILD__PHBAL_REG_SAM                             /**< Sam BAL definition */
#define NXPBUILD__PHBAL_REG_SOCKETWIN                       /**< SocketWin BAL definition #### SD */
#define NXPBUILD__PHBAL_REG_RDFPGAV6                        /**< FPGA BOX BAL definition */
#define NXPBUILD__PHBAL_REG_PS6000USB                       /**< PicoScope OSCI BAL definition */

#if defined (NXPBUILD__PHBAL_REG_STUB) || \
    defined (NXPBUILD__PHBAL_REG_SERIALWIN) || \
    defined (NXPBUILD__PHBAL_REG_PCSCWIN) || \
    defined (NXPBUILD__PHBAL_REG_RD70XUSBWIN) || \
    defined (NXPBUILD__PHBAL_REG_PIPELIN) || \
    defined (NXPBUILD__PHBAL_REG_SOCKETWIN) || \
    defined (NXPBUILD__PHBAL_REG_RD710SAM) || \
    defined (NXPBUILD__PHBAL_REG_SAM) || \
    defined (NXPBUILD__PHBAL_REG_RDFPGAV6) || \
    defined (NXPBUILD__PHBAL_REG_PS6000USB)
    #define NXPBUILD__PHBAL_REG                             /**< Generic BAL definition */
#endif




/* HAL components ------------------------------------------------------------------------------------------------------------ */
#define NXPBUILD__PHHAL_HW_RC523                            /**< Rc523 HAL definition */
#define NXPBUILD__PHHAL_HW_SAMAV2                           /**< SamAV2 HAL definition */
#define NXPBUILD__PHHAL_HW_RD70X                            /**< Rd70X HAL definition */
#define NXPBUILD__PHHAL_HW_RC632                            /**< Rc632 HAL definition */
#define NXPBUILD__PHHAL_HW_RDCARDSIM                        /**< RdCardSim HAL definition */
#define NXPBUILD__PHHAL_HW_LICENSEEWRAPPER                  /**< LicenseeWrapper HAL definition */
#define NXPBUILD__PHHAL_HW_CALLBACK                         /**< Callback HAL definition */
#define NXPBUILD__PHHAL_HW_RC663                            /**< Rc663 HAL definition */
#define NXPBUILD__PHHAL_HW_RD710                            /**< Rd710 HAL definition */
#define NXPBUILD__PHHAL_HW_RDFPGAV6                         /**< RdFpga HAL definition */
#define NXPBUILD__PHHAL_HW_DUT                              /**< DUT HAL Definition*/
#define NXPBUILD__PHHAL_HW_DUT_CMD_VERSION                  /**< DUT HAL Definition for Version */
#define NXPBUILD__PHHAL_HW_DUT_CMD_HAL                      /**< DUT HAL Definition for Hal Commands */
#define NXPBUILD__PHHAL_HW_DUT_CMD_RDOPS                    /**< DUT HAL Definition for Reader Operations */
#define NXPBUILD__PHHAL_HW_PCSC                             /**< PCSC HAL definition */

#if defined (NXPBUILD__PHHAL_HW_RC523) || \
    defined (NXPBUILD__PHHAL_HW_SAMAV2) || \
    defined (NXPBUILD__PHHAL_HW_RD70X) || \
    defined (NXPBUILD__PHHAL_HW_RDCARDSIM) || \
    defined (NXPBUILD__PHHAL_HW_CALLBACK) || \
    defined (NXPBUILD__PHHAL_HW_RC663) || \
    defined (NXPBUILD__PHHAL_HW_RC632) || \
    defined (NXPBUILD__PHHAL_HW_RD710) || \
    defined (NXPBUILD__PHHAL_HW_RDFPGAV6) || \
    defined (NXPBUILD__PHHAL_HW_DUT) || \
    defined (NXPBUILD__PHHAL_HW_DUT_CMD_VERSION) || \
    defined (NXPBUILD__PHHAL_HW_DUT_CMD_HAL) || \
    defined (NXPBUILD__PHHAL_HW_DUT_CMD_RDOPS) || \
    defined (NXPBUILD__PHHAL_HW_LICENSEEWRAPPER) || \
    defined (NXPBUILD__PHHAL_HW_PCSC)
    #define NXPBUILD__PHHAL_HW                              /**< Generic HAL definition */
#endif

/* Contact HAL components ------------------------------------------------------------------------------------------------------------ */




/* PAL components ------------------------------------------------------------------------------------------------------------ */
/* PAL ISO 14443-3A components */
#define NXPBUILD__PHPAL_I14443P3A_SW                        /**< Software PAL ISO 14443-3A definition */
#define NXPBUILD__PHPAL_I14443P3A_RD70X                     /**< Rd70X PAL ISO 14443-3A definition */
#define NXPBUILD__PHPAL_I14443P3A_RD710                     /**< Rd710 PAL ISO 14443-3A definition */
#define NXPBUILD__PHPAL_I14443P3A_PCSC                      /**< PCSC PAL ISO 14443-3A definition */

#if defined (NXPBUILD__PHPAL_I14443P3A_SW) || \
    defined (NXPBUILD__PHPAL_I14443P3A_RD70X) || \
    defined (NXPBUILD__PHPAL_I14443P3A_RD710) || \
    defined (NXPBUILD__PHPAL_I14443P3A_PCSC)
    #define NXPBUILD__PHPAL_I14443P3A                       /**< Generic PAL ISO 14443-3A definition */
#endif

/* PAL ISO 14443-3B components */
#define NXPBUILD__PHPAL_I14443P3B_SW                        /**< Software PAL ISO 14443-3B definition */

#if defined (NXPBUILD__PHPAL_I14443P3B_SW)
    #define NXPBUILD__PHPAL_I14443P3B                       /**< Generic PAL ISO 14443-3B definition */
#endif

/* PAL ISO 14443-4A components */
#define NXPBUILD__PHPAL_I14443P4A_SW                        /**< Software PAL ISO 14443-4A definition */
#define NXPBUILD__PHPAL_I14443P4A_RD710                     /**< Rd710 PAL ISO 14443-4A definition */
#define NXPBUILD__PHPAL_I14443P4A_PCSC                      /**< PCSC PAL ISO 14443-4A definition */
#if defined (NXPBUILD__PHPAL_I14443P4A_SW) || \
    defined (NXPBUILD__PHPAL_I14443P4A_RD710) || \
    defined (NXPBUILD__PHPAL_I14443P4A_PCSC)
    #define NXPBUILD__PHPAL_I14443P4A                       /**< Generic PAL ISO 14443-4A definition */
#endif

/* PAL ISO 14443-4 components */
#define NXPBUILD__PHPAL_I14443P4_SW                         /**< Software PAL ISO 14443-4 definition */
#define NXPBUILD__PHPAL_I14443P4_RD710                      /**< Rd710 PAL ISO 14443-4 definition */
#define NXPBUILD__PHPAL_I14443P4_ANDROID                    /**< Android dummy PAL for ISO 14443-4 definition */
#define NXPBUILD__PHPAL_I14443P4_PCSC                       /**< PCSC PAL ISO 14443-4 definition */

#if defined (NXPBUILD__PHPAL_I14443P4_SW) || \
    defined (NXPBUILD__PHPAL_I14443P4_RD710) || \
    defined (NXPBUILD__PHPAL_I14443P4_ANDROID) || \
    defined (NXPBUILD__PHPAL_I14443P4_PCSC)
    #define NXPBUILD__PHPAL_I14443P4                        /**< Generic PAL ISO 14443-4 definition */
#endif

/* PAL ISO 7816P4 components */


/* PAL ISO 7816P4A components */


/* PAL MIFARE components */
#define NXPBUILD__PHPAL_MIFARE_STUB                         /**< Stub PAL MIFARE */
#define NXPBUILD__PHPAL_MIFARE_SW                           /**< Software PAL MIFARE */
#define NXPBUILD__PHPAL_MIFARE_RD710                        /**< Rd710 PAL MIFARE */
#define NXPBUILD__PHPAL_MIFARE_PCSC                         /**< PCSC PAL MIFARE */

#if defined (NXPBUILD__PHPAL_MIFARE_STUB) || \
    defined (NXPBUILD__PHPAL_MIFARE_SW) || \
    defined (NXPBUILD__PHPAL_MIFARE_RD710) || \
    defined (NXPBUILD__PHPAL_MIFARE_PCSC)
    #define NXPBUILD__PHPAL_MIFARE                          /**< Generic PAL MIFARE definition */
#endif

/* PAL ISO15693 ICode SLI components */
#define NXPBUILD__PHPAL_SLI15693_SW                         /**< Software PAL SLI 15693 */
#define NXPBUILD__PHPAL_SLI15693_RD710                      /**< PAL SLI 15693 using RD710 Hardware */

#if defined (NXPBUILD__PHPAL_SLI15693_SW) || \
    defined (NXPBUILD__PHPAL_SLI15693_RD710)
    #define NXPBUILD__PHPAL_SLI15693                        /**< Generic PAL SLI 15693 definition */
#endif

/* PAL FeLiCa components */
#define NXPBUILD__PHPAL_FELICA_SW                           /**< Software PAL FeLiCa */

#if defined (NXPBUILD__PHPAL_FELICA_SW)
    #define NXPBUILD__PHPAL_FELICA                          /**< Generic PAL FeLiCa definition */
#endif

/* PAL ICode EPC/UID components */
#define NXPBUILD__PHPAL_EPCUID_SW                           /**< Software ICode EPC/UID */

#if defined (NXPBUILD__PHPAL_EPCUID_SW)
    #define NXPBUILD__PHPAL_EPCUID                          /**< Generic PAL ICode EPC/UID definition */
#endif

/* PAL I18000p3m3 components */
#define NXPBUILD__PHPAL_I18000P3M3_SW                       /**< Software I18000p3m3 */

#if defined (NXPBUILD__PHPAL_I18000P3M3_SW)
    #define    NXPBUILD__PHPAL_I18000P3M3                   /**< Generic PAL I18000p3m3 definition */
#endif

/* PAL ISO 18092 components */
#define NXPBUILD__PHPAL_I18092MPI_SW                        /**< Software PAL ISO 18092 definition */

#if defined (NXPBUILD__PHPAL_I18092MPI_SW)
    #define NXPBUILD__PHPAL_I18092MPI                       /**< Generic PAL ISO 18092 definition */
#endif




/* AL components ------------------------------------------------------------------------------------------------------------- */
/* AL FeLiCa components */
#define NXPBUILD__PHAL_FELICA_SW                            /**< Software AL FeLiCa */

#if defined (NXPBUILD__PHAL_FELICA_SW)
    #define NXPBUILD__PHAL_FELICA                           /**< Generic AL FeLiCa definition */
#endif

/* AL MIFARE Ultralight components */
#define NXPBUILD__PHAL_MFUL_SW                              /**< Software MIFARE Ultralight */

#if defined (NXPBUILD__PHAL_MFUL_SW)
    #define NXPBUILD__PHAL_MFUL                             /**< Generic AL MIFARE Ultralight definition */
#endif

/* AL MIFARE Classic components */
#define NXPBUILD__PHAL_MFC_SW                               /**< Software MIFARE Classic */

#if defined (NXPBUILD__PHAL_MFC_SW)
    #define NXPBUILD__PHAL_MFC                              /**< Generic AL MIFARE Classic definition */
#endif

/* AL MIFARE Plus components */
#define NXPBUILD__PHAL_MFP_SW                               /**< Software MIFARE Plus */

#if defined (NXPBUILD__PHAL_MFP_SW)
    #define NXPBUILD__PHAL_MFP                              /**< Generic AL MIFARE Plus definition */
#endif

/* AL MIFARE Plus EVx components */
#define NXPBUILD__PHAL_MFPEVX_SW                            /**< Software MIFARE Plus EVx */

#if defined (NXPBUILD__PHAL_MFPEVX_SW)
    #define NXPBUILD__PHAL_MFPEVX                           /**< Generic AL MIFARE Plus EVx definition */
#endif

/* AL MIFARE DESFire components */
#define NXPBUILD__PHAL_MFDF_SW                              /**< Software MIFARE DESFire */

#if defined (NXPBUILD__PHAL_MFDF_SW)
    #define NXPBUILD__PHAL_MFDF                             /**< Generic AL MIFARE DESFire definition */
#endif

/* AL MIFARE DESFire EVx components */
#define NXPBUILD__PHAL_MFDFEVX_SW                           /**< Software MIFARE DESFire EVx */

#if defined (NXPBUILD__PHAL_MFDFEVX_SW)
    #define NXPBUILD__PHAL_MFDFEVX                          /**< Generic AL MIFARE DESFire EVx definition */
#endif

/* AL MIFARE DESFire Light components */
#define NXPBUILD__PHAL_MFDFLIGHT_SW                         /**< Software MIFARE DESFire Light */

#if defined (NXPBUILD__PHAL_MFDFLIGHT_SW)
    #define NXPBUILD__PHAL_MFDFLIGHT                        /**< Generic AL MIFARE DESFire Light definition */
#endif

/* AL MIFARE DUOX components */
#define NXPBUILD__PHAL_MFDUOX_SW                            /**< Software MIFARE DUOX. */

#if defined (NXPBUILD__PHAL_MFDUOX_SW)
    #define NXPBUILD__PHAL_MFDUOX                           /**< Generic AL MIFARE DUOX definition */
#endif

/* AL MIFARE IDENTITY components */


/* AL MIFARE PRIME Ntag42XDna components */
#define NXPBUILD__PHAL_MFNTAG42XDNA_SW                      /**< Software MIFARE Ntag42XDna */

#if defined (NXPBUILD__PHAL_MFNTAG42XDNA_SW)
    #define NXPBUILD__PHAL_MFNTAG42XDNA                     /**< Generic AL MIFARE Prime Ntag42XDna definition */
#endif

/* AL NTAG X DNA components */
#define NXPBUILD__PHAL_NTAGXDNA_SW                          /**< Software NTAG X DNA */

#if defined (NXPBUILD__PHAL_NTAGXDNA_SW)
    #define NXPBUILD__PHAL_NTAGXDNA                         /**< Generic AL MIFARE Prime Ntag42XDna definition */
#endif

/* AL MIFARE PRIME NTAG 413 components */
#define NXPBUILD__PHAL_MFPRIMENTAG_SW                       /**< Software MIFARE Prime NTAG */

#if defined (NXPBUILD__PHAL_MFPRIMENTAG_SW)
    #define NXPBUILD__PHAL_MFPRIMENTAG                      /**< Generic AL MIFARE Prime NTAG definition */
#endif

/* AL Virtual Card Architecture components */
#define NXPBUILD__PHAL_VCA_SW                               /**< Software Virtual Card Architecture */

#if defined (NXPBUILD__PHAL_VCA_SW)
    #define NXPBUILD__PHAL_VCA                              /**< Generic AL Virtual Card Architecture definition */
#endif

/* AL ICode components */
#define NXPBUILD__PHAL_ICODE_SW                             /**< Software AL for ICode */

#if defined (NXPBUILD__PHAL_ICODE_SW)
    #define NXPBUILD__PHAL_ICODE                            /**< Generic AL ICode definition */
#endif

/* AL ISO 18000P3M3 components */
#define NXPBUILD__PHAL_I18000P3M3_SW                        /**< Software AL I18000p3m3 */

#if defined (NXPBUILD__PHAL_I18000P3M3_SW)
#define NXPBUILD__PHAL_I18000P3M3                           /**< Generic AL I18000p3m3 definition */
#endif

/* AL P40 PrivateCommands components */


/* AL P40 PublicCommand components */





/* Device Layer components --------------------------------------------------------------------------------------------------- */
/* DL FPGA Box components */


/* DL ISO3 components */
#ifdef NXPBUILD__PHHAL_HW_ISO3

#endif

/* DL Amplifier components */


/* DL ThermoStream components */


/* DL Oscilloscope components */
#ifdef NXPBUILD__PHHAL_HW_ISO3
#endif


/* DL Spectrum Analyzer components */


/* DL PowerSupply components */


/* DL Master Amplifier Oscilloscope components */
#ifdef NXPBUILD__PHHAL_HW_ISO3
#endif



/* DL Stepper components */





/* Common components --------------------------------------------------------------------------------------------------------- */
/* CID Manager components */
#define NXPBUILD__PH_CIDMANAGER_SW                          /**< Software CID Manager */
#define NXPBUILD__PH_CIDMANAGER_RD710                       /**< Rd710 CID Manager */

#if defined (NXPBUILD__PH_CIDMANAGER_SW) || \
    defined (NXPBUILD__PH_CIDMANAGER_RD710)
    #define NXPBUILD__PH_CIDMANAGER                         /**< Generic CID Manager definition */
#endif

/* Crypto Sym components */
#define NXPBUILD__PH_CRYPTOSYM_SW                           /**< Software CryptoSym */
#define NXPBUILD__PH_CRYPTOSYM_STUB                         /**< Stub CryptoSym */
#define NXPBUILD__PH_CRYPTOSYM_MBEDTLS                      /**< mBedTLS CryptoSym */
#define NXPBUILD__PH_CRYPTOASYM_STUB                        /**< Stub Crypto ASym */

#if defined (NXPBUILD__PH_CRYPTOSYM_SW) || \
    defined (NXPBUILD__PH_CRYPTOSYM_MBEDTLS) || \
    defined (NXPBUILD__PH_CRYPTOSYM_STUB)
    #define NXPBUILD__PH_CRYPTOSYM                          /**< Generic CryptoSym definition */
#endif

/* Crypto ASym components */
#define NXPBUILD__PH_CRYPTOASYM_MBEDTLS                     /**< Software Crypto ASym using mBedTLS library. */
#define NXPBUILD__PH_CRYPTOASYM_STUB                        /**< Stub Crypto ASym */
#define NXPBUILD__PH_CRYPTOASYM_ECC                         /**< Crypto ASym for ECC */
#define NXPBUILD__PH_CRYPTOASYM_HASH                        /**< Crypto ASym for Hash */

#if defined (NXPBUILD__PH_CRYPTOASYM_MBEDTLS) || \
    defined (NXPBUILD__PH_CRYPTOASYM_STUB) || \
    defined (NXPBUILD__PH_CRYPTOASYM_ECC) || \
    defined (NXPBUILD__PH_CRYPTOASYM_HASH)
    #define NXPBUILD__PH_CRYPTOASYM                         /**< Generic Crypto ASym definition */
#endif

/* CryptoRng components */
#define NXPBUILD__PH_CRYPTORNG_SW                           /**< Software CryptoRng */
#define NXPBUILD__PH_CRYPTORNG_MBEDTLS                      /**< mBedTLs CryptoRng */
#define NXPBUILD__PH_CRYPTORNG_STUB                         /**< Stub CryptoRng */

#if defined (NXPBUILD__PH_CRYPTORNG_SW) || \
    defined (NXPBUILD__PH_CRYPTORNG_MBEDTLS) || \
    defined (NXPBUILD__PH_CRYPTORNG_STUB)
    #define NXPBUILD__PH_CRYPTORNG                          /**< Generic CryptoRng definition */
#endif

/* KeyStore components */
#define NXPBUILD__PH_KEYSTORE_SW                            /**< Software KeyStore */
#define NXPBUILD__PH_KEYSTORE_ASYM                          /**< ASymmetric Software KeyStore */
#define NXPBUILD__PH_KEYSTORE_RC632                         /**< RC632 KeyStore */
#define NXPBUILD__PH_KEYSTORE_RC663                         /**< RC663 KeyStore */
#define NXPBUILD__PH_KEYSTORE_RD710                         /**< Rd710 KeyStore */

#if defined (NXPBUILD__PH_KEYSTORE_SW) || \
    defined (NXPBUILD__PH_KEYSTORE_ASYM) || \
    defined (NXPBUILD__PH_KEYSTORE_RC663) || \
    defined (NXPBUILD__PH_KEYSTORE_RC632) || \
    defined (NXPBUILD__PH_KEYSTORE_RD710)
    #define NXPBUILD__PH_KEYSTORE                           /**< Generic KeyStore definition */
#endif

/* TMIUtils component */
#define NXPBUILD__PH_TMIUTILS 


/* Log component */
#define NXPBUILD__PH_LOG 


/** @}
* end of ph_NxpBuild
*/


#endif /* PH_NXPBUILD_H */
