/*
 * Copyright 2013, 2016 - 2018, 2020, 2023, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Type definitions for Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PH_TYPEDEFS_H
#define PH_TYPEDEFS_H

#ifdef linux
#include <sys/types.h>
#endif

/** \defgroup ph_Typedefs Type Definitions
* \brief Contains definitions for types defined within NxpRdLib
* @{
*/

#ifndef _unaligned_defined
#define _unaligned_defined
#ifdef _WIN64
#define UNALIGNED __unaligned
#else
#define UNALIGNED
#endif
#endif

#ifndef _socket_defined
#define _socket_defined

#ifdef _WIN64
    typedef unsigned __int64 SOCKET_T;
#else
    typedef unsigned long SOCKET_T;
#endif
#endif

/** \name Unsigned Types */
/** @{ */
#ifndef __uint8_t_defined
#define __uint8_t_defined
/** \brief 8 bit unsigned integer */
typedef unsigned char uint8_t;
#endif

#ifndef __uint16_t_defined
#define __uint16_t_defined
/** \brief 16 bit unsigned integer */
typedef unsigned short uint16_t;
#endif

#ifndef __uint32_t_defined
#define __uint32_t_defined
/** \brief 32 bit unsigned integer */
typedef unsigned int uint32_t;
#endif

#ifndef __uint64_t_defined
#define __uint64_t_defined
/** \brief 64 bit unsigned integer */
#ifdef _WIN32
typedef unsigned long long uint64_t;
#else
typedef unsigned long uint64_t;
#endif
#endif
/** @} */

/** \name Signed Types */
/** @{ */
#ifndef __int8_t_defined
#define __int8_t_defined
/** \brief 8 bit signed integer */
typedef signed char int8_t;
#endif

#ifndef __int16_t_defined
#define __int16_t_defined
/** \brief 16 bit signed integer */
typedef short int16_t;
#endif

#ifndef __int32_t_defined
#define __int32_t_defined
/** \brief 32 bit signed integer */
typedef int int32_t;
#endif

#ifndef __int64_t_defined
#define __int64_t_defined
/** \brief 64 bit signed integer */
#ifdef _WIN32
typedef long long int64_t;
#else
typedef long int64_t;
#endif
#endif
/** @} */

/** \name Floating-Point Types */
/** @{ */
#ifndef __float32_t_defined
#define __float32_t_defined
/** \brief 32 bit floating point */
typedef float float32_t;
#endif
/** @} */

/** \name Double-Precision Floating Point Types */
/** @{ */
#ifndef __float64_t_defined
#define __float64_t_defined
/** \brief 64 bit floating point */
typedef double float64_t;
#endif
/** @} */

/** \name Boolean Types */
/** @{ */
#ifndef __BOOL_DEFINED
#define __BOOL_DEFINED
#ifdef __CX51__     /* If Keil 8051 */
typedef bit bool;
#else
#define bool unsigned char;
#endif
#ifndef true
#define true 1
#endif
#ifndef false
#define false 0
#endif
#endif
/** @} */

/** \name Other Types */
/** @{ */

/**
 * \brief phcsBfl_Status_t is a signed short value, using the positive range.
 *
 * High byte: Category (group) Identifier.\n
 * Low byte : Error Specifier.
 */
typedef uint16_t phStatus_t;

#ifndef NULL
#define NULL 0
#endif

/**
 * The below code line is added to suppress the error thrown by yvals.h file which is internal to Microsoft libraries.
 * The un-definition of macro is to suppress compilation errors when Visual Studio 2015 or higher is used.
 * This issue is not observed in Visual Studio 2010 or lower.
 */
#if _MSC_VER > 1600
#undef _NOEXCEPT
#endif

/** @} */

/**
 * end of ph_Typedefs group
 * @}
 */

#endif /* PH_TYPEDEFS_H */
