﻿/*
 * Copyright 2020, 2023 - 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

using System;

namespace NxpRdLibNet
{
    /// <summary>
    /// Class to list the different type of MIFARE Products supported by NXP Reader Library.
    /// </summary>
    public class MIFARE_Products
    {
        /// <summary> Get the string label for MIFARE Ultralight product. </summary>
        public const string ULTRALIGHT = "Ultralight";

        /// <summary> Get the string label for MIFARE Ultralight C product. </summary>
        public const string ULTRALIGHT_C = "Ultralight C";

        /// <summary> Get the string label for MIFARE Ultralight EV1 product. </summary>
        public const string ULTRALIGHT_EV1 = "Ultralight EV1";

        /// <summary> Get the string label for MIFARE Ultralight AES product. </summary>
        public const string ULTRALIGHT_AES = "Ultralight AES";

        /// <summary> Get the string label for MIFARE Classic product. </summary>
        public const string CLASSIC = "Classic";

        /// <summary> Get the string label for MIFARE Classic EV1 product. </summary>
        public const string CLASSIC_EV1 = "Classic EV1";

        /// <summary> Get the string label for MIFARE PLUS S product. </summary>
        public const string PLUS_S = "PLUS S";

        /// <summary> Get the string label for MIFARE PLUS X product. </summary>
        public const string PLUS_X = "PLUS X";

        /// <summary> Get the string label for MIFARE PLUS SE product. </summary>
        public const string PLUS_SE = "PLUS SE";

        /// <summary> Get the string label for MIFARE PLUS EV1 product. </summary>
        public const string PLUS_EV1 = "PLUS EV1";

        /// <summary> Get the string label for MIFARE PLUS EV2 product. </summary>
        public const string PLUS_EV2 = "PLUS EV2";

        /// <summary> Get the string label for MIFARE DESFire product. </summary>
        public const string DESFIRE = "DESFire";

        /// <summary> Get the string label for MIFARE DESFireEV1 product. </summary>
        public const string DESFIRE_EV1 = "DESFire EV1";

        /// <summary> Get the string label for MIFARE DESFire EV2 product. </summary>
        public const string DESFIRE_EV2 = "DESFire EV2";

        /// <summary> Get the string label for MIFARE DESFire EV3 product. </summary>
        public const string DESFIRE_EV3 = "DESFire EV3";

        /// <summary> Get the string label for MIFARE DESFire Light product. </summary>
        public const string DESFIRE_LIGHT = "DESFire Light";

        /// <summary> Get the string label for MIFARE DUOX product. </summary>
        public const string DUOX = "MIFARE DUOX";
    }

    /// <summary>
    /// Class to list the different type of NTAG Products supported by NXP Reader Library.
    /// </summary>
    public class NTAG_Products
    {
        /// <summary> Get the string label for NTAG I2C product. </summary>
        public const string NTAG_I2C = "NTAG I2C";

        /// <summary> Get the string label for NTAG 210 product. </summary>
        public const string NTAG210 = "NTAG 210";

        /// <summary> Get the string label for NTAG 210u product. </summary>
        public const string NTAG210_MICRO = "NTAG 210u";

        /// <summary> Get the string label for NTAG 212 product. </summary>
        public const string NTAG212 = "NTAG 212";

        /// <summary> Get the string label for NTAG 213 product. </summary>
        public const string NTAG213 = "NTAG 213";

        /// <summary> Get the string label for NTAG 213 TagTamper product. </summary>
        public const string NTAG213_TT = "NTAG 213 TagTamper";

        /// <summary> Get the string label for NTAG 215 product. </summary>
        public const string NTAG215 = "NTAG 215";

        /// <summary> Get the string label for NTAG 216 product. </summary>
        public const string NTAG216 = "NTAG 216";

        /// <summary> Get the string label for NTAG 223 DNA product. </summary>
        public const string NTAG223_DNA = "NTAG 223 DNA";

        /// <summary> Get the string label for NTAG 223 DNA Status Detect product. </summary>
        public const string NTAG223_DNA_SD = "NTAG 223 DNA Status Detect";

        /// <summary> Get the string label for NTAG 224 DNA product. </summary>
        public const string NTAG224_DNA = "NTAG 224 DNA";

        /// <summary> Get the string label for NTAG 224 DNA Status Detect product. </summary>
        public const string NTAG224_DNA_SD = "NTAG 224 DNA Status Detect";

        /// <summary> Get the string label for NTAG 413 product. </summary>
        public const string NTAG_413 = "NTAG 413";

        /// <summary> Get the string label for NTAG 424 product. </summary>
        public const string NTAG_424_DNA = "NTAG 424 DNA";

        /// <summary> Get the string label for NTAG 424 TagTamper product. </summary>
        public const string NTAG_424_DNA_TT = "NTAG 424 DNA TagTamper";

        /// <summary> Get the string label for NTAG X DNA product. </summary>
        public const string NTAG_X_DNA = "NTAG X DNA";

        /// <summary> Get the string label for NTAG Switch product. </summary>
        public const string NTAG_SWITCH = "NTAG Switch";

        /// <summary> Get the string label for NTAG Link product. </summary>
        public const string NTAG_LINK = "NTAG Link";

        /// <summary> Get the string label for NTAG Boost product. </summary>
        public const string NTAG_BOOST = "NTAG Boost";
    }

    [AttributeUsage ( AttributeTargets.Class | AttributeTargets.Constructor | AttributeTargets.Enum | AttributeTargets.Field |
        AttributeTargets.GenericParameter | AttributeTargets.Method | AttributeTargets.Property | AttributeTargets.Struct |
        AttributeTargets.Struct, AllowMultiple = true )]
    public class NxpRdLibAttribute : Attribute
    {
        private string _Product;
        public string Product
        {
            get { return _Product; }
            set { _Product = value; }
        }

        private string _OtherInfo;
        public string OtherInfo
        {
            get { return _OtherInfo; }
            set { _OtherInfo = value; }
        }

        public string _Message;
        public string Message
        {
            get { return _Message; }
            set { _Message = value; }
        }

        public NxpRdLibAttribute ( params string[] Product )
        {
            this.Product = string.Join ( ", ", Product );
            this.OtherInfo = OtherInfo;
        }
    }
}
