/*
 * Decompiled with CFR 0.152.
 */
package com.mobileknowledge.library.utils;

import java.io.UnsupportedEncodingException;
import java.util.regex.Pattern;

public class Utils {
    public static String byteArrayToHex(byte[] data) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            String bs = Integer.toHexString(data[i] & 0xFF).toUpperCase();
            if (bs.length() == 1) {
                sb.append(0);
            }
            sb.append(bs);
        }
        return sb.toString().toUpperCase();
    }

    public static String byteArrayToHex(byte[] data, byte length, byte offset) {
        StringBuilder sb = new StringBuilder();
        for (int i = offset; i < data.length && i < length; ++i) {
            String bs = Integer.toHexString(data[i] & 0xFF).toUpperCase();
            if (bs.length() == 1) {
                sb.append(0);
            }
            sb.append(bs);
        }
        return sb.toString().toUpperCase();
    }

    public static byte[] hexToByteArray(String s) {
        Pattern p = Pattern.compile("([a-fA-F0-9]{2}[ ]*)*");
        boolean valid = p.matcher(s).matches();
        if (!valid) {
            throw new IllegalArgumentException("not a valid string representation of a byte array :" + s);
        }
        String hex = s.replaceAll(" ", "");
        byte[] tab = new byte[hex.length() / 2];
        for (int i = 0; i < tab.length; ++i) {
            tab[i] = (byte)Integer.parseInt(hex.substring(2 * i, 2 * i + 2), 16);
        }
        return tab;
    }

    public static byte[] hexToByteArray(String s, byte length, byte offset) {
        Pattern p = Pattern.compile("([a-fA-F0-9]{2}[ ]*)*");
        boolean valid = p.matcher(s).matches();
        if (!valid) {
            throw new IllegalArgumentException("not a valid string representation of a byte array :" + s);
        }
        String hex = s.replaceAll(" ", "");
        int sLength = hex.length() / 2;
        if (sLength + offset > length) {
            throw new IllegalArgumentException("invalid length of the byte array :" + s);
        }
        byte[] tab = new byte[length];
        for (int i = 0; i < sLength && i + offset < length; ++i) {
            tab[i - offset + (length - sLength)] = (byte)Integer.parseInt(hex.substring(2 * i, 2 * i + 2), 16);
        }
        return tab;
    }

    public static byte[] byteArrayToAscii(String s) {
        return s.getBytes();
    }

    public static String toAsciiString(byte[] buf) throws UnsupportedEncodingException {
        String ascii = null;
        if (buf != null) {
            ascii = new String(buf, "US-ASCII");
            char[] charArray = ascii.toCharArray();
            for (int i = 0; i < charArray.length; ++i) {
                if (charArray[i] != '\u0000') continue;
                charArray[i] = 32;
            }
            ascii = new String(charArray);
        }
        return ascii;
    }

    public static int byteArrayToInt(byte[] b) {
        if (b.length == 1) {
            return b[0] & 0xFF;
        }
        if (b.length == 2) {
            return ((b[0] & 0xFF) << 8) + (b[1] & 0xFF);
        }
        if (b.length == 3) {
            return ((b[0] & 0xFF) << 16) + ((b[1] & 0xFF) << 8) + (b[2] & 0xFF);
        }
        if (b.length == 4) {
            return (b[0] << 24) + ((b[1] & 0xFF) << 16) + ((b[2] & 0xFF) << 8) + (b[3] & 0xFF);
        }
        throw new IndexOutOfBoundsException();
    }

    public static byte[] intToByteArray(int value) {
        byte[] result = new byte[4];
        result[3] = (byte)(value & 0xFF);
        result[2] = (byte)(value >> 8 & 0xFF);
        result[1] = (byte)(value >> 16 & 0xFF);
        result[0] = (byte)(value >> 24 & 0xFF);
        return result;
    }

    public static byte[] shortToByteArray(short value) {
        byte[] result = new byte[2];
        result[1] = (byte)(value & 0xFF);
        result[0] = (byte)(value >> 8 & 0xFF);
        return result;
    }

    public static short byteArrayToShort(byte[] b) {
        if (b.length == 1) {
            return (short)(b[0] & 0xFF);
        }
        if (b.length == 2) {
            return (short)(((b[0] & 0xFF) << 8) + (b[1] & 0xFF));
        }
        throw new IndexOutOfBoundsException();
    }

    public static byte[] byteToByteArray(byte value) {
        byte[] result = new byte[]{(byte)(value & 0xFF)};
        return result;
    }

    public static byte byteArrayToByte(byte[] b) {
        if (b.length == 1) {
            return (byte)(b[0] & 0xFF);
        }
        throw new IndexOutOfBoundsException();
    }

    public static byte[] concat(byte[] b1, byte[] b2) {
        if (b1 == null) {
            return b2;
        }
        if (b2 == null) {
            return b1;
        }
        byte[] result = new byte[b1.length + b2.length];
        System.arraycopy(b1, 0, result, 0, b1.length);
        System.arraycopy(b2, 0, result, b1.length, b2.length);
        return result;
    }

    public static byte[] concat(byte[] b1, byte[] b2, byte[] b3) {
        if (b1 == null) {
            return Utils.concat(b2, b3);
        }
        if (b2 == null) {
            return Utils.concat(b1, b3);
        }
        if (b3 == null) {
            return Utils.concat(b1, b2);
        }
        byte[] result = new byte[b1.length + b2.length + b3.length];
        System.arraycopy(b1, 0, result, 0, b1.length);
        System.arraycopy(b2, 0, result, b1.length, b2.length);
        System.arraycopy(b3, 0, result, b1.length + b2.length, b3.length);
        return result;
    }

    public static byte[] concat(byte[] b1, byte[] b2, byte[] b3, byte[] b4) {
        if (b1 == null) {
            return Utils.concat(b2, b3, b4);
        }
        if (b2 == null) {
            return Utils.concat(b1, b3, b4);
        }
        if (b3 == null) {
            return Utils.concat(b1, b2, b4);
        }
        if (b4 == null) {
            return Utils.concat(b1, b2, b3);
        }
        byte[] result = new byte[b1.length + b2.length + b3.length + b4.length];
        System.arraycopy(b1, 0, result, 0, b1.length);
        System.arraycopy(b2, 0, result, b1.length, b2.length);
        System.arraycopy(b3, 0, result, b1.length + b2.length, b3.length);
        System.arraycopy(b4, 0, result, b1.length + b2.length + b3.length, b4.length);
        return result;
    }

    public static byte[] concat(byte[] b1, byte[] b2, byte[] b3, byte[] b4, byte[] b5) {
        if (b1 == null) {
            return Utils.concat(b2, b3, b4, b5);
        }
        if (b2 == null) {
            return Utils.concat(b1, b3, b4, b5);
        }
        if (b3 == null) {
            return Utils.concat(b1, b2, b4, b5);
        }
        if (b4 == null) {
            return Utils.concat(b1, b2, b3, b5);
        }
        if (b5 == null) {
            return Utils.concat(b1, b2, b3, b4);
        }
        byte[] result = new byte[b1.length + b2.length + b3.length + b4.length + b5.length];
        System.arraycopy(b1, 0, result, 0, b1.length);
        System.arraycopy(b2, 0, result, b1.length, b2.length);
        System.arraycopy(b3, 0, result, b1.length + b2.length, b3.length);
        System.arraycopy(b4, 0, result, b1.length + b2.length + b3.length, b4.length);
        System.arraycopy(b5, 0, result, b1.length + b2.length + b3.length + b4.length, b5.length);
        return result;
    }

    public static byte[] concat(byte[] b1, byte[] b2, byte[] b3, byte[] b4, byte[] b5, byte[] b6) {
        if (b1 == null) {
            return Utils.concat(b2, b3, b4, b5, b6);
        }
        if (b2 == null) {
            return Utils.concat(b1, b3, b4, b5, b6);
        }
        if (b3 == null) {
            return Utils.concat(b1, b2, b4, b5, b6);
        }
        if (b4 == null) {
            return Utils.concat(b1, b2, b3, b5, b6);
        }
        if (b5 == null) {
            return Utils.concat(b1, b2, b3, b4, b6);
        }
        if (b6 == null) {
            return Utils.concat(b1, b2, b3, b4, b5);
        }
        byte[] result = new byte[b1.length + b2.length + b3.length + b4.length + b5.length + b6.length];
        System.arraycopy(b1, 0, result, 0, b1.length);
        System.arraycopy(b2, 0, result, b1.length, b2.length);
        System.arraycopy(b3, 0, result, b1.length + b2.length, b3.length);
        System.arraycopy(b4, 0, result, b1.length + b2.length + b3.length, b4.length);
        System.arraycopy(b5, 0, result, b1.length + b2.length + b3.length + b4.length, b5.length);
        System.arraycopy(b6, 0, result, b1.length + b2.length + b3.length + b4.length + b5.length, b6.length);
        return result;
    }

    public static boolean compareByteArrays(byte[] array1, int array1offset, byte[] array2, int array2offset, int len) {
        int j;
        int i = array1offset;
        for (j = array2offset; j < len; ++j) {
            if (array1[i] != array2[j]) {
                return false;
            }
            ++i;
        }
        return i - array1offset == len && j - array2offset == len;
    }

    public static byte[] extract(byte[] buffer, int length, int offset) {
        byte[] result = new byte[length];
        System.arraycopy(buffer, offset, result, 0, length);
        return result;
    }

    public static byte[] insert(byte[] buffer, byte[] toInsert, int pos) {
        byte[] result = new byte[buffer.length + toInsert.length];
        System.arraycopy(buffer, 0, result, 0, pos);
        System.arraycopy(toInsert, 0, result, pos, toInsert.length);
        System.arraycopy(buffer, pos, result, pos + toInsert.length, buffer.length - pos);
        return result;
    }

    public static byte[] xor(byte[] b1, byte[] b2) {
        byte[] result = new byte[b1.length];
        for (int i = 0; i < b1.length; ++i) {
            result[i] = (byte)(b1[i] ^ b2[i]);
        }
        return result;
    }

    public static byte[] adjustByteArray(byte[] data, byte pos, byte value) {
        byte[] result = new byte[data.length];
        System.arraycopy(data, 0, result, 0, data.length);
        result[pos] = value;
        return result;
    }

    public static byte[] adjustByteArray(byte[] data, byte pos, byte[] value) {
        byte[] result = new byte[data.length];
        System.arraycopy(data, 0, result, 0, data.length);
        System.arraycopy(value, 0, result, pos, value.length);
        return result;
    }

    public static byte[] trimLeadingBytes(byte[] inputBytes, int amountOfBytesToTrim) {
        byte[] outputBytes = new byte[inputBytes.length - amountOfBytesToTrim];
        System.arraycopy(inputBytes, amountOfBytesToTrim, outputBytes, 0, inputBytes.length - amountOfBytesToTrim);
        return outputBytes;
    }

    public static byte[] trimLeadingZeros(byte[] inputBytes) {
        int i = 0;
        for (i = 0; i < inputBytes.length && inputBytes[i] == 0; ++i) {
        }
        if (i == inputBytes.length) {
            return inputBytes;
        }
        byte[] outputBytes = new byte[inputBytes.length - i];
        System.arraycopy(inputBytes, i, outputBytes, 0, outputBytes.length);
        return outputBytes;
    }

    public static byte[] appendLeadingZeros(byte[] inputBytes, byte length, byte offset) {
        if (inputBytes.length + offset > length) {
            throw new IllegalArgumentException("Invalid length or offset value");
        }
        byte[] outputBytes = new byte[length];
        System.arraycopy(inputBytes, 0, outputBytes, outputBytes.length - inputBytes.length - offset, inputBytes.length);
        return outputBytes;
    }
}

