/* File: sched.h,  Author: B.Kuhn, Licence: LGPL */
/* definitions for the sched_setscheduler() system call */

#ifndef SCHED_H
#define SCHED_H

#include <asm/unistd.h>
#include <errno.h>

#define SCHED_OTHER     0
#define SCHED_FIFO      1
#define SCHED_RR        2

struct sched_param {
  int sched_priority;
};

static inline _syscall3(int, sched_setscheduler,
                        pid_t, pid,
                        int, policy,
                        const struct sched_param*, p)

#endif

