//------------------------------------------------------------------------------
// File name:	T1024RDB_TOP
// Project:		T1024RDB board
// Author:		Miceteck
// Revision:	V1.0
// Data:		2014.08
//------------------------------------------------------------------------------

`timescale 1ns/100ps

`define	CHIPID1		5'h00
`define	CHIPID2		5'h01
`define	HWVER			5'h02
`define	SWVER			5'h03

`define	RSTCON1		5'h10
`define 	RSTCON2		5'h11
`define 	INTSR			5'h12
`define	FLHCSR		5'h13
`define	FANCSR		5'h14
`define	LEDCSR		5'h15
`define 	SDSR		5'h16
`define	MISCCSR		5'h17
`define	BOOTOR		5'h18
`define	BOOTCFG1		5'h19
`define	BOOTCFG2		5'h1a

module t1024rdb (
	//input
	//input clock
	cpld_refclk,
	ifc_clk,
	//ifc
	ifc_a27_31,
	ifc_cs0_n,
	ifc_cs1_n,
	ifc_cs2_n,
	boot_flash_sel,
	nor_rb_n,
	nand_rb_n,
	//power control
	v3v3_pgood,
	pwr_good,
	sdhc_vs,
	evt_pwr_en,
	evt_brd_iso,
	gpio_cke_iso,
	//reset
	pwr_rst_n,
	reset_req_n,
	cop_sreset_n,
	cop_hreset_n,
	cop_trst_n,
	//status
	pex_prs_n,
	tdmr_prs_n,
	vdd_sd_sense,
	test_sel_n,
	//interrupt
	therm_fault_n,
	therm_alert_n,
	rtc_int_n,
	xgt1_int_n,
	xgt2_int_n,
	tdmr1_int_n,
	tdmr2_int_n,
	
	//output
	//cfg
	ifc_ad8_15,
	ifc_a16,
	ifc_a17,
	ifc_cle,
	ifc_wp_n,
	ifc_te,
	ifc_avd,
	ifc_a18,
	ifc_a19,
	ifc_a21,
	//ifc
	nor_cs_n,
	nand_cs_n,
	ifc_rb0_n,
	ifc_rb1_n,
	//power control
	iopwr_en,
	iopwr_en_n,
	ddrpwr_en,
	ddrpwr_en_n,
	vdd_en,
	vdd_en_n,
	vcore_en,
	sensevdd_en_n,
	evt_pwr_ok,
	cke_iso_en,
	evdd_sel,
	//reset
	poreset_n,
	jtag_trst_n,
	ddr_rst_n,
	nor_rst_n,
	ec1_rst_n,
	ec2_rst_n,
	xgt1_rst_n,
	xgt2_rst_n,
	pex_sel_n,
	eth_refclk_sel,
	sd_refclk_sel,
	pex_rst_n,
	mpex1_rst_n,
	mpex2_rst_n,
	tdmr_rst_n,
	//LED
	led_status,
	//misc control
	sysclk_oe,
	difsysclk_oe_n,
	pexclk_oe_n,
	cpld_int_n,
	fan_pwm,
	tdmr_slp_n,
	//inout
	//ifc
	ifc_ad0_7,
	ifc_we_n,		//ifc input + cfg output
	ifc_oe_n,		//ifc input + cfg output
	cfg_vbank,
	//hreset
	hreset_n
);

// I/O declarations
input		cpld_refclk;
input		ifc_clk;
input[4:0]	ifc_a27_31;
input		ifc_cs0_n;
input		ifc_cs1_n;
input		ifc_cs2_n;
input		boot_flash_sel;
input		nor_rb_n;
input		nand_rb_n;
input		v3v3_pgood;
input		pwr_good;
input		sdhc_vs;
input		evt_pwr_en;
input		evt_brd_iso;
input		gpio_cke_iso;
input		pwr_rst_n;
input		reset_req_n;
input		cop_sreset_n;
input		cop_hreset_n;
input		cop_trst_n;
input		pex_prs_n;
input		tdmr_prs_n;
input		vdd_sd_sense;
input		test_sel_n;
input		therm_fault_n;
input		therm_alert_n;
input		rtc_int_n;
input		xgt1_int_n;
input		xgt2_int_n;
input		tdmr1_int_n;
input		tdmr2_int_n;
inout[0:7]	ifc_ad8_15;
output		ifc_a16;
output		ifc_a17;
output		ifc_cle;
output		ifc_wp_n;
output		ifc_te;
output		ifc_avd;
output		ifc_a18;
output		ifc_a19;
output		ifc_a21;
output		nor_cs_n;
output		nand_cs_n;
output		ifc_rb0_n;
output		ifc_rb1_n;
output		iopwr_en;
output		iopwr_en_n;
output		ddrpwr_en;
output		ddrpwr_en_n;
output		vdd_en;
output		vdd_en_n;
output		vcore_en;
output		sensevdd_en_n;
output		evt_pwr_ok;
output		cke_iso_en;
output		evdd_sel;
output		poreset_n;
output		jtag_trst_n;
output		ddr_rst_n;
output		nor_rst_n;
output		ec1_rst_n;
output		ec2_rst_n;
output		xgt1_rst_n;
output		xgt2_rst_n;
output		pex_sel_n;
output		eth_refclk_sel;
output		sd_refclk_sel;
output		pex_rst_n;
output		mpex1_rst_n;
output		mpex2_rst_n;
output		tdmr_rst_n;
output		led_status;
output		sysclk_oe;
output		difsysclk_oe_n;
output		pexclk_oe_n;
output		cpld_int_n;
output		fan_pwm;
output		tdmr_slp_n;
inout[0:7]	ifc_ad0_7;
inout		ifc_we_n;
inout		ifc_oe_n;
inout[0:2]	cfg_vbank;
inout		hreset_n;

// Internal signal declarations
wire		pon_rst_n;
wire		cpu_rst_n;
wire 		pex_sel_n_tmp;
reg			cpld_cs;
reg			cpld_oe;
reg			cpld_we;

reg[9:0]	tier_cnt;
reg			tier_cnt_int;
reg[0:3]	tier;
reg[9:0]	vcore_en_cnt;
reg[19:0]	pwr_ok_cnt;
reg[19:0]	pwr_gd_cnt;

reg[1:0]	req_rst_old;
reg			req_rst;
reg[7:0]	req_rst_cnt;
reg			req_rst_r;

reg			sw_rst_r;
reg[7:0]	sw_rst_cnt;
reg			sw_rst_rr;

reg[2:0]	ddr_rst_cnt;

reg			rst_hold_f;
reg[31:0]	rst_hold_cnt;
reg			ddr_rst_r;
reg			ec1_rst_r;
reg			ec2_rst_r;
reg			xgt1_rst_r;
reg			xgt2_rst_r;
reg			pex_rst_r;
reg			mpex1_rst_r;
reg			mpex2_rst_r;
reg			tdmr_rst_r;

reg			vbank_override_r;
reg[0:2]	vbank_sel_r;

reg[3:0]	fan_cnt;
reg[3:0]	fan_pwm_r;
reg[3:0]	pwm_cnt;
reg			fan_out;
reg			led_sts_r;

reg			sleep_en_r;
reg[0:1]	req_md_r;

reg			pcie_25G_override_r;
reg			pci_25G_sel_r;
reg			pci_25G_sel_dip;
reg			boot_override_r;
reg[0:8]	rcw_src_r;
reg[0:1]	svr_r;
reg[0:2]	eng_use_r;

reg			cfg_eng_use0;

reg[0:7] 	ifc_dout,rcw_config_word;
wire		JTAG_status_bit;
wire		Nor_Nand_flag;
reg			req_cop_trst;
reg[1:0]	req_cop_trst_old;
reg			req_cop_trst_r;
reg[0:19]	req_cop_trst_cnt;

reg[1:0]	cpld_oe_edge,cpld_we_edge;
wire		cpld_oe_rise_plus,cpld_we_rise_plus;
reg[1:0] 	sw_rst_r_edge;
wire		sw_rst_r_edge_plus;

reg[1:0] 	rst_hold_f_f_edge;
wire		rst_hold_f_f_edge_plus;

reg[9:0] 	pwr_rst_cnt;

// Parameters
parameter	HW_VERSION = 8'd3;
parameter	SW_VERSION = 8'd7;  // RST_HOLD_TIME delay is enlarged
parameter	RST_HOLD_TIME = 32'd16384;

//--------------------------------------------------------------------------
// Module code
//reset

assign	pon_rst_n = (v3v3_pgood & pwr_gd_cnt[19])? (pwr_ok_cnt[19]? pwr_rst_n : 1'b1) : pwr_rst_n;
assign	cpu_rst_n = pon_rst_n & ((tier[0] & tier[3])? cop_hreset_n : 1'b1);


always @(posedge ifc_clk  or  negedge pon_rst_n)
		if (!pon_rst_n)		cpld_we_edge <= 2'b11;
		else				cpld_we_edge <= { cpld_we_edge[0], ifc_we_n};
assign cpld_we_rise_plus = (cpld_we_edge == 2'b10) ? 1'b1 : 1'b0;
		

always @(posedge ifc_clk)
begin
	if(!pon_rst_n)
	begin
		cpld_cs <= 0;
		cpld_oe <= 0;
		cpld_we <= 0;
	end
	else
	begin
		cpld_cs <= ~ifc_cs2_n;
		cpld_oe <= ~ifc_cs2_n & ~ifc_oe_n;
		cpld_we <= ~ifc_cs2_n & cpld_we_rise_plus;
	end
end


always @(posedge ifc_clk or negedge pon_rst_n or posedge rst_hold_f)
begin
	if(!pon_rst_n )
	begin
		sw_rst_r <= 0;
		ddr_rst_r <= 0;
		ec1_rst_r <= 0;
		ec2_rst_r <= 0;
		xgt1_rst_r <= 0;
		xgt2_rst_r <= 0;		
		tdmr_rst_r <= 0;
		pex_rst_r <= 0;
		mpex1_rst_r <= 0;
		mpex2_rst_r <= 0;
		vbank_override_r <= 0;
		vbank_sel_r <= 3'b000;
		fan_pwm_r <= 4'b1111;
		led_sts_r <= 0;
		sleep_en_r <= 0;
		req_md_r <= 2'b11;
		pcie_25G_override_r <= 0;
		boot_override_r <= 0;
		rcw_src_r <= 9'b000000000;
		svr_r <= 2'b00;
		eng_use_r <= 3'b000;
	end
	else if(rst_hold_f)
		begin
			sw_rst_r <= 0;

		end 
	else
	begin
		if(cpld_cs & cpld_we)
		begin
			case(ifc_a27_31)
				`RSTCON1:	begin
								sw_rst_r <= ifc_ad0_7[0];
								ddr_rst_r <= ifc_ad0_7[1];
								ec1_rst_r <= ifc_ad0_7[2];
								ec2_rst_r <= ifc_ad0_7[3];
								xgt1_rst_r <= ifc_ad0_7[6];
								xgt2_rst_r <= ifc_ad0_7[7];
								//rst_hold_f <= 1;
								//rst_hold_cnt <= RST_HOLD_TIME;
							end
				`RSTCON2:	begin
								tdmr_rst_r <= ifc_ad0_7[4];
								pex_rst_r <= ifc_ad0_7[5];
								mpex1_rst_r <= ifc_ad0_7[6];
								mpex2_rst_r <= ifc_ad0_7[7];
								//rst_hold_f <= 1;
								//rst_hold_cnt <= RST_HOLD_TIME;
							end
				`FLHCSR:	begin
								vbank_override_r <= ifc_ad0_7[1];
								vbank_sel_r[0:2] <= ifc_ad0_7[5:7];
							end
				`FANCSR:	begin
								fan_pwm_r[3:0] <= ifc_ad0_7[4:7];
							end
				`LEDCSR:	begin
								led_sts_r <= ifc_ad0_7[0];
							end
				`MISCCSR:	begin
								pci_25G_sel_r <= ifc_ad0_7[0];
								sleep_en_r <= ifc_ad0_7[1];
								req_md_r[0:1] <= ifc_ad0_7[2:3];
							end
				`BOOTOR:	begin
								pcie_25G_override_r <= ifc_ad0_7[6]; 
								boot_override_r <= ifc_ad0_7[7];
							end
				`BOOTCFG1:	begin
								rcw_src_r[0:7] <= ifc_ad0_7[0:7];
							end
				`BOOTCFG2:	begin
								rcw_src_r[8] <= ifc_ad0_7[0];
								svr_r[0:1] <= ifc_ad0_7[2:3];
								eng_use_r[0:2] <= ifc_ad0_7[5:7];
							end
				default:	begin
							end
			endcase
		end
		else if(cpld_cs & cpld_oe)
		begin
			case(ifc_a27_31)
				`CHIPID1:	ifc_dout[0:7] <= 8'h55;
				`CHIPID2:	ifc_dout[0:7] <= 8'haa;
				`HWVER:		ifc_dout[0:7] <= HW_VERSION;
				`SWVER:		ifc_dout[0:7] <= SW_VERSION;
				`RSTCON1:	begin
								ifc_dout[0] <= sw_rst_r;
								ifc_dout[1] <= ddr_rst_r;
								ifc_dout[2] <= ec1_rst_r;
								ifc_dout[3] <= ec2_rst_r;
								ifc_dout[4:5] <= 2'b00;
								ifc_dout[6] <= xgt1_rst_r;
								ifc_dout[7] <= xgt2_rst_r;
							end
				`RSTCON2:	begin
								ifc_dout[0:3] <= 4'b0000;
								ifc_dout[4] <= tdmr_rst_r;
								ifc_dout[5] <= pex_rst_r;
								ifc_dout[6] <= mpex1_rst_r;
								ifc_dout[7] <= mpex2_rst_r;
							end
				`INTSR:	begin
								ifc_dout[0] <= ~therm_alert_n;
								ifc_dout[1] <= ~rtc_int_n;
								ifc_dout[2] <= ~xgt1_int_n;    //10G INT
								ifc_dout[3] <= ~xgt2_int_n;	   //2.5G INT
								ifc_dout[4:5] <= 2'b00;
								ifc_dout[6] <= ~tdmr1_int_n;
								ifc_dout[7] <= ~tdmr2_int_n;
							end
				`FLHCSR:	begin
								ifc_dout[0] <= boot_flash_sel;
								ifc_dout[1] <= vbank_override_r;
								ifc_dout[2:4] <= cfg_vbank[0:2];
								ifc_dout[5:7] <= vbank_sel_r[0:2];
							end
				`FANCSR:	begin
								ifc_dout[0:3] <= 4'b0000;
								ifc_dout[4:7] <= fan_pwm_r;
							end
				`LEDCSR:	begin
								ifc_dout[0] <= led_sts_r;
								ifc_dout[1:7] <= 7'b0000000;
							end
				`SDSR:	begin
								ifc_dout[0:6] <= 7'b0000000;
								ifc_dout[7] <= ~vdd_sd_sense;
							end
				`MISCCSR:	begin
								ifc_dout[0] <= pci_25G_sel_r;
								ifc_dout[1] <= sleep_en_r;
								ifc_dout[2:3] <= req_md_r[0:1];
								ifc_dout[4] <= ~tdmr_prs_n;
								ifc_dout[5] <= ~pex_prs_n;
								ifc_dout[6] <= 1'b0;
								ifc_dout[7] <= test_sel_n;
							end
				`BOOTOR:	begin
								ifc_dout[0:5] <= 7'b000000;
								ifc_dout[6] <= pcie_25G_override_r;
								ifc_dout[7] <= boot_override_r;
							end
				`BOOTCFG1:	begin
								ifc_dout[0:7] <= rcw_src_r[0:7];
							end
				`BOOTCFG2:	begin
								ifc_dout[0] <= rcw_src_r[8];
								ifc_dout[1] <= 0;
								ifc_dout[2:3] <= svr_r[0:1];
								ifc_dout[4] <= 0;
								ifc_dout[5:7] <= eng_use_r[0:2];
							end
				default:	ifc_dout <= 8'h00;
			endcase
		end
		else
			begin
			ifc_dout <= 8'hzz;
				if(rst_hold_f_f_edge_plus)
				begin
						ddr_rst_r <= 0;
						ec1_rst_r <= 0;
						ec2_rst_r <= 0;
						xgt1_rst_r <= 0;
						xgt2_rst_r <= 0;
						pex_rst_r <= 0;
						mpex1_rst_r <= 0;
						mpex2_rst_r <= 0;
	
				end
			end
	end
end

always @(posedge cpld_refclk)
begin
	if(!v3v3_pgood)
		fan_cnt <= 4'b0000;
	else
		fan_cnt <= fan_cnt + 1;
end

always @(posedge fan_cnt[3])
begin
	if(!v3v3_pgood)
		pwm_cnt <= 4'b0000;
	else
	begin
		pwm_cnt <= pwm_cnt + 1;
		if(pwm_cnt < fan_pwm_r)
			fan_out <= 1;
		else
			fan_out <= 0;
	end
end

always @(posedge cpld_refclk)
begin
	if(!pon_rst_n)
	begin
		req_rst <= 1;
		req_rst_old[1:0] <= 2'b00;
	end
	else
	begin
		req_rst_old[1] <= req_rst_old[0];
		req_rst_old[0] <= reset_req_n;
		if(req_rst_old[1:0] == 2'b10)
			req_rst <= 0;
		else
			req_rst <= 1;
	end
end

always @(posedge cpld_refclk)
begin
	if(!pon_rst_n)
	begin
		req_rst_r <= 1;
		req_rst_cnt <= 8'd0;
	end
	else
	begin
		if(!req_rst)
			req_rst_r <= 0;
		if(!req_rst_r)
		begin
			if(req_rst_cnt >= 8'd160)
			begin
				req_rst_r <= 1;
				req_rst_cnt <= 8'd0;
			end
			else
				req_rst_cnt <= req_rst_cnt + 1;
		end
	end
end	
	
always @(posedge cpld_refclk  or  negedge pwr_rst_n)
		if (!pwr_rst_n)		sw_rst_r_edge <= 2'b11;
		else				sw_rst_r_edge <= {sw_rst_r_edge[0], sw_rst_r};
		
assign sw_rst_r_edge_plus = (sw_rst_r_edge == 2'b01) ? 1'b1 : 1'b0;

always @(posedge cpld_refclk or negedge pwr_rst_n)
begin
	if(!pwr_rst_n)
		begin
			rst_hold_f   <=0;
			rst_hold_cnt <=32'd0;
		end
	else
		begin 
			if(sw_rst_r_edge_plus)
				begin
					rst_hold_f <= 1;
					rst_hold_cnt <= RST_HOLD_TIME;
				end
			else
				
				if(rst_hold_f)
				begin
						if(rst_hold_cnt==32'd0)
							rst_hold_f <=0;
						else
							rst_hold_cnt <=rst_hold_cnt-1;
				end
				
		end
end
always @(posedge ifc_clk  or  negedge pwr_rst_n)
		if (!pwr_rst_n)		rst_hold_f_f_edge <= 2'b11;
		else				rst_hold_f_f_edge <= {rst_hold_f_f_edge[0], rst_hold_f};
assign rst_hold_f_f_edge_plus = (rst_hold_f_f_edge == 2'b10) ? 1'b1 : 1'b0;



always @(posedge cpld_refclk)
begin
	if(!v3v3_pgood)
	begin
		tier_cnt <= 10'd0;
		tier_cnt_int <= 0;
	end
	else
	begin
		if(tier_cnt >= 10'd10)
		begin
			tier_cnt <= 10'd0;
			tier_cnt_int <= ~tier_cnt_int;
		end
		else
			tier_cnt <= tier_cnt + 1;
	end
end

always @(posedge tier_cnt_int)
begin
	if(!v3v3_pgood)
		tier[0:3] <= 4'b1111;
	else
	begin
		tier[3] <= tier[2];
		tier[2] <= tier[1];
		tier[1] <= tier[0];
		tier[0] <= evt_pwr_en;
	end
end

always @(posedge cpld_refclk)
begin
	if(!v3v3_pgood)
		vcore_en_cnt <= 10'd0;
	else
	begin
		if(vcore_en_cnt > 10'h180)
			vcore_en_cnt <= 10'h3ff;
		else
			vcore_en_cnt <= vcore_en_cnt + 1;
	end
end

always @(posedge cpld_refclk)
begin
	if(!hreset_n)
		ddr_rst_cnt <= 3'd0;
	else
	begin
		if(ddr_rst_cnt >= 3'b010)
			ddr_rst_cnt <= 3'b111;
		else
			ddr_rst_cnt <= ddr_rst_cnt + 1;
	end
end

always @(posedge cpld_refclk)
begin
	if(!v3v3_pgood)
		pwr_gd_cnt <= 20'd0;
	else
	begin
		if(pwr_gd_cnt > 20'h08000)
			pwr_gd_cnt <= 20'hfffff;
		else
			pwr_gd_cnt <= pwr_gd_cnt + 1;
	end
end

always @(posedge cpld_refclk)
begin
	if(!v3v3_pgood)
		pwr_ok_cnt <= 20'hfffff;
	else
	begin
		if(tier[0:3] == 4'b1100)
			pwr_ok_cnt <= 20'h00000;
		else
		begin
			if(pwr_ok_cnt >= 20'h08000)
				pwr_ok_cnt <= 20'hfffff;
			else
				pwr_ok_cnt <= pwr_ok_cnt + 1;
		end
	end
end

always @(posedge cpld_refclk)
begin
	if(!cpu_rst_n || rst_hold_f||( hreset_n && (!req_rst_r) && req_cop_trst_r ))
		cfg_eng_use0 <= ifc_we_n;
end

always @(posedge cpld_refclk)
begin
	if(!pwr_rst_n)
		rcw_config_word <= ifc_ad8_15[0:7];
end

always @(posedge cpld_refclk)
begin
	if(!v3v3_pgood || pwr_rst_n)
		pwr_rst_cnt <=10'd0;
	else if(~pwr_rst_n && pwr_rst_cnt <=10'd512)
		pwr_rst_cnt <= pwr_rst_cnt +1;
end
always @(posedge cpld_refclk)
begin
	if(pwr_rst_cnt == 512)
		pci_25G_sel_dip <= ifc_oe_n;//ifc_wp_n;
end

// PCIE & 2.5G selection bit


always @(posedge cpld_refclk)
begin
	if(!pon_rst_n || rst_hold_f)
	begin
		req_cop_trst <= 1;
		req_cop_trst_old <= 2'b00;
	end
	else
	begin
		req_cop_trst_old[1] <= req_cop_trst_old[0];
		req_cop_trst_old[0] <= cop_trst_n;
		if(req_cop_trst_old == 2'b01)
			req_cop_trst <= 0;
		else
			req_cop_trst <= 1;
	end
end

always @(posedge cpld_refclk)
begin
	if(!pon_rst_n || rst_hold_f)
	begin
		req_cop_trst_r <= 1;
		req_cop_trst_cnt <= 20'd0;
	end
	else
	begin
		if(!req_cop_trst)
			req_cop_trst_r <= 0;
		if(!req_cop_trst_r)
		begin
			if(req_cop_trst_cnt >= 20'd131072)
			begin
				req_cop_trst_r <= 1;
				req_cop_trst_cnt <= 20'd0;
			end
			else
				req_cop_trst_cnt <= req_cop_trst_cnt + 1;
		end
	end
end	

//cfg
assign	ifc_ad8_15[0:7] = (cpu_rst_n & (~rst_hold_f) &  ((req_md_r == 2'b11)? req_rst_r : 1'b1))? 8'bz : (boot_override_r? rcw_src_r[0:7] : 8'bz);
assign	ifc_cle = (cpu_rst_n & (~rst_hold_f) & ((req_md_r == 2'b11)? req_rst_r : 1'b1))? 1'bz : (boot_override_r? rcw_src_r[8] : 1'bz);
assign	ifc_a16 = (cpu_rst_n & (~rst_hold_f) & ((req_md_r == 2'b11)? req_rst_r : 1'b1))? 1'bz : (boot_override_r? svr_r[0] : 1'bz);
assign	ifc_a17 = (cpu_rst_n & (~rst_hold_f) & ((req_md_r == 2'b11)? req_rst_r : 1'b1))? 1'bz : (boot_override_r? svr_r[1] : 1'bz);
assign	ifc_we_n = (cpu_rst_n & (~rst_hold_f) & ((req_md_r == 2'b11)? req_rst_r : 1'b1))? 1'bz : (boot_override_r? eng_use_r[0] : 1'bz);
assign	ifc_oe_n = (cpu_rst_n & (~rst_hold_f) & ((req_md_r == 2'b11)? req_rst_r : 1'b1))? 1'bz : (boot_override_r? eng_use_r[1] : 1'bz);
assign	ifc_wp_n = (cpu_rst_n & (~rst_hold_f) & ((req_md_r == 2'b11)? req_rst_r : 1'b1))? 1'bz : (boot_override_r? eng_use_r[2] : 1'bz);
assign	Nor_Nand_flag  = (rcw_src_r[0:7] == 8'b00010011) ? 1'b0:1'b1;

assign	pex_sel_n_tmp = pcie_25G_override_r? pci_25G_sel_r : pci_25G_sel_dip;
assign	pex_sel_n = pex_sel_n_tmp;
assign	eth_refclk_sel = pex_sel_n_tmp;
assign	sd_refclk_sel = pex_sel_n_tmp;
assign	boot_sel  = boot_override_r? Nor_Nand_flag : boot_flash_sel;

assign	cfg_vbank[0:2] = vbank_override_r ? vbank_sel_r[0:2] : 3'bz;
assign	ifc_te  = 1'bz;
assign	ifc_avd = 1'bz;
assign	ifc_a18 = 1'bz;
assign	ifc_a19 = 1'bz;
assign	ifc_a21 = 1'bz;
//ifc
assign	ifc_ad0_7[0:7] = cpld_oe? ifc_dout[0:7] : 8'hzz;
assign	nor_cs_n  = (~boot_sel)? ifc_cs0_n : ifc_cs1_n;
assign	nand_cs_n = (~boot_sel)? ifc_cs1_n : ifc_cs0_n;
assign	ifc_rb0_n = (~boot_sel)? nor_rb_n : nand_rb_n;
assign	ifc_rb1_n = (~boot_sel)? nand_rb_n : nor_rb_n;
//power control
assign	vcore_en   = v3v3_pgood & vcore_en_cnt[9];
assign	iopwr_en   = tier[1];
assign	iopwr_en_n = ~tier[1];
assign	vdd_en     = tier[2];
assign	vdd_en_n   = ~tier[2];
assign	ddrpwr_en  = tier[3];
assign	ddrpwr_en_n   = ~tier[3];
assign	sensevdd_en_n = ~(tier[0] & tier[3]);
assign	evt_pwr_ok    = tier[0] & tier[3] & pwr_ok_cnt[19];
//assign	cke_iso_en = sleep_en_r? gpio_cke_iso : 1'b0;
assign	cke_iso_en = ~evt_brd_iso;
assign	evdd_sel   = sdhc_vs;
//reset
assign  JTAG_status_bit = (rcw_config_word == 8'b01001101) ? 1'b1 : 1'b0;

assign	poreset_n = JTAG_status_bit ? pon_rst_n : req_cop_trst_r ? (~rst_hold_f) & cpu_rst_n & ((req_md_r == 2'b11)? req_rst_r : 1'b1): cpu_rst_n;
assign  hreset_n = JTAG_status_bit ? cpu_rst_n :  ((req_md_r == 2'b01)? req_rst_r : 1'b1)? 1'bz : 1'b0;
assign	jtag_trst_n = pon_rst_n & cop_trst_n ;

assign	ddr_rst_n = (pon_rst_n & ~ddr_rst_r & ddr_rst_cnt[2])? 1'bz : 1'b0;
assign	nor_rst_n = pon_rst_n;
assign	ec1_rst_n = cpu_rst_n & ~ec1_rst_r;
assign	ec2_rst_n = cpu_rst_n & ~ec2_rst_r;
assign	xgt1_rst_n = cpu_rst_n & ~xgt1_rst_r;
assign	xgt2_rst_n = cpu_rst_n & ~xgt2_rst_r;
assign	tdmr_rst_n = cpu_rst_n & ~tdmr_rst_r;
assign	pex_rst_n = pon_rst_n & ~pex_rst_r & tier[3];
assign	mpex1_rst_n = pon_rst_n & ~mpex1_rst_r;
assign	mpex2_rst_n = pon_rst_n & ~mpex2_rst_r;
//LED
assign	led_status = ~led_sts_r;
//misc control
assign	sysclk_oe = cfg_eng_use0;
assign	difsysclk_oe_n = cfg_eng_use0? 1'bz : 1'b0;
assign	pexclk_oe_n = evt_brd_iso? 1'b0 : 1'bz;
assign	tdmr_slp_n = tier[0] & tier[3];
assign	cpld_int_n = therm_alert_n & rtc_int_n & xgt1_int_n & xgt2_int_n & tdmr1_int_n & tdmr2_int_n;
assign	fan_pwm = fan_out;

endmodule
