/******************************************************************************
*
*       COPYRIGHT (c) 2003 MOTOROLA INC.
*       ALL RIGHTS RESERVED
*
* Filename:     core.S
* Author:       Mark Jonas
* Revision:     1.0
*
* History:      2003-May-30: First release.
*
* Description:  Supplies functions to access various features of the core.
*
* Notes:        So far only read access to the MBAR register and read and
*               write access to the Timebase registers is implemented.
*
******************************************************************************/

.global readMBAR
.global readTBx
.global writeTBx

.text

/*--------------------------------------------------------------------------
   Function    : uint32 readMBAR (void)
   Description : Return contents of MBAR register.
   Parameter(s): none
   Returns     : MBAR
  --------------------------------------------------------------------------*/
readMBAR:
	mfspr	r3,311		// SPR311 is MBAR mirror register
	blr
	
/*--------------------------------------------------------------------------
   Function    : uint64 readTBx (void)
   Description : Return contents of Timebase registers (TBU and TBL).
   Parameter(s): none
   Returns     : TBx
  --------------------------------------------------------------------------*/
readTBx:
	mftbu r3		// get TBU
	mftb r4			// get TBL
	mftbu r5		// get TBU once again
	cmpw r5,r3		// see if 'old' = 'new'
	bne readTBx		// loop
	blr

/*--------------------------------------------------------------------------
   Function    : void writeTBx (uint32 tbu, uint32 tbl)
   Description : Write Timebase registers (TBU and TBL).
   Parameter(s): tbu - value to write to TBU
                 tbl - value to write to TBL
   Returns     : nothing
  --------------------------------------------------------------------------*/
writeTBx:
	li r5,0
	mttbl r5		// force TBL to zero
	mttbu r3		// set TBU
	mttbl r4		// set TBL
	blr

.end