/******************************************************************************
*
*       COPYRIGHT (c) 2003 MOTOROLA INC.
*       ALL RIGHTS RESERVED
*
* Filename:     mpc5200.h
* Author:       Mark Jonas
* Revision:     1.0
*
* History:      2003-May-30: First release.
*
* Description:  Header file describing the offset to the MPC5200 peripherals
*               relative to MBAR.
*
* Notes:        
*
******************************************************************************/

#ifndef __MPC5200_H
#define __MPC5200_H
 
#define MBAR_MM         0x0000
#define MBAR_SDRAM      0x0100
#define MBAR_CDM        0x0200
#define MBAR_CSC        0x0300
#define MBAR_SCTMR      0x0400
#define MBAR_ICTL       0x0500
#define MBAR_GPT        0x0600
#define MBAR_SLT        0x0700
#define MBAR_RTC        0x0800
#define MBAR_CAN        0x0900
#define MBAR_GPS        0x0B00
#define MBAR_GPW        0x0C00
#define MBAR_PCI        0x0D00
#define MBAR_SPI        0x0F00
#define MBAR_USB        0x1000
#define MBAR_BDMA       0x1200
#define MBAR_BDLC       0x1300
#define MBAR_IR         0x1400
#define MBAR_XLARB      0x1F00
#define MBAR_PSC1       0x2000
#define MBAR_PSC2       0x2200
#define MBAR_PSC3       0x2400
#define MBAR_PSC4       0x2600
#define MBAR_PSC5       0x2800
#define MBAR_PSC6       0x2C00
#define MBAR_IRDA       0x2C00
#define MBAR_ETH        0x3000
#define MBAR_BPCI       0x3800
#define MBAR_ATA        0x3A00
#define MBAR_BLPC       0x3C00
#define MBAR_I2C        0x3D00
#define MBAR_SRAM       0x8000

#endif /* __MPC5200_H */
