/******************************************************************************
*
*       COPYRIGHT (c) 2003 MOTOROLA INC.
*       ALL RIGHTS RESERVED
*
* Filename:     xlarb.h
* Author:       Mark Jonas
* Revision:     1.0
*
* History:      2003-May-30: First release.
*
* Description:  Header file describing the registers in the MPC5200 XLB
*               Arbiter module (XLARB).
*
* Notes:        
*
******************************************************************************/

#ifndef __XLARB_H
#define __XLARB_H

typedef struct xlarb_register_set {
	volatile uint32 reserved0;		/* MBAR_XLARB + 0x00 */
	volatile uint32 reserved1;		/* MBAR_XLARB + 0x04 */
	volatile uint32 reserved2;		/* MBAR_XLARB + 0x08 */
	volatile uint32 reserved3;		/* MBAR_XLARB + 0x0c */
	volatile uint32 reserved4;		/* MBAR_XLARB + 0x10 */
	volatile uint32 reserved5;		/* MBAR_XLARB + 0x14 */
	volatile uint32 reserved6;		/* MBAR_XLARB + 0x18 */
	volatile uint32 reserved7;		/* MBAR_XLARB + 0x1c */
	volatile uint32 reserved8;		/* MBAR_XLARB + 0x20 */
	volatile uint32 reserved9;		/* MBAR_XLARB + 0x24 */
	volatile uint32 reserved10;		/* MBAR_XLARB + 0x28 */
	volatile uint32 reserved11;		/* MBAR_XLARB + 0x2c */
	volatile uint32 reserved12;		/* MBAR_XLARB + 0x30 */
	volatile uint32 reserved13;		/* MBAR_XLARB + 0x34 */
	volatile uint32 reserved14;		/* MBAR_XLARB + 0x38 */
	volatile uint32 reserved15;		/* MBAR_XLARB + 0x3c */

	volatile uint32 config;			/* MBAR_XLARB + 0x40 */
	volatile uint32 version;		/* MBAR_XLARB + 0x44 */
	volatile uint32 status;			/* MBAR_XLARB + 0x48 */
	volatile uint32 int_enable;		/* MBAR_XLARB + 0x4c */
	volatile uint32 add_capture;		/* MBAR_XLARB + 0x50 */
	volatile uint32 bus_sig_capture;	/* MBAR_XLARB + 0x54 */
	volatile uint32 add_time_out;		/* MBAR_XLARB + 0x58 */
	volatile uint32 data_time_out;		/* MBAR_XLARB + 0x5c */
	volatile uint32 bus_time_out;		/* MBAR_XLARB + 0x60 */
	volatile uint32 priority_enable;	/* MBAR_XLARB + 0x64 */
	volatile uint32 priority;		/* MBAR_XLARB + 0x68 */
	volatile uint32 arb_base_addr2;		/* MBAR_XLARB + 0x6c */
	volatile uint32 snoop_window;		/* MBAR_XLARB + 0x70 */

	volatile uint32 reserved16;		/* MBAR_XLARB + 0x74 */
	volatile uint32 reserved17;		/* MBAR_XLARB + 0x78 */
	volatile uint32 reserved18;		/* MBAR_XLARB + 0x7c */

	volatile uint32 control;		/* MBAR_XLARB + 0x80 */
	volatile uint32 init_total_count;	/* MBAR_XLARB + 0x84 */
	volatile uint32 int_total_count;	/* MBAR_XLARB + 0x88 */

	volatile uint32 reserved19;		/* MBAR_XLARB + 0x8c */

	volatile uint32 lower_address;		/* MBAR_XLARB + 0x90 */
	volatile uint32 higher_address;		/* MBAR_XLARB + 0x94 */
	volatile uint32 int_window_count;	/* MBAR_XLARB + 0x98 */
	volatile uint32 window_ter_count;	/* MBAR_XLARB + 0x9c */
} xlarb_regs;

#endif /* __XLARB_H */
