/******************************************************************************
*
*       COPYRIGHT (c) 2003 MOTOROLA INC.
*       ALL RIGHTS RESERVED
*
* Filename:     init.h
* Author:       Mark Jonas
* Revision:     1.0
*
* History:      2003-May-30: First release.
*
* Description:  Header file for init.S. Contains configuration of the MPC5200
*               IceCube+ board.
*
* Notes:        
*
******************************************************************************/

#include "reg_defs.h"

// Do we want to use the MMU's address translation ability?
#define MMU_ON		1

// Instruction and data caches on or off?
// MMU must be switched on if data chache is used or access to the internal
// peripherals will fail.
#define ICACHE_ON	1
#define DCACHE_ON	1

// SDRAM SDR @ 132 MHz on IceCube+
#define	DDR	0
#define EMODE	0
#define MODE	0x008D
#define CONTROL	0x514F0000
#define CONFIG1	0xC2233A00
#define CONFIG2	0x88B70004
#define	TAP_DEL	0x08

// RAM starts at 0x00000000 and is 64 MBytes.
#define RAM_START	0x00000000
#define RAM_SIZE	0x19

// Flash starts at 0xFF800000 and ends at 0xFFFFFFFF (8 MBytes).
#define FLASH_START	0xFF800000
#define FLASH_STOP	0xFFFFFFFF

#define BOOT_LOW_ADDR	0x00000000
#define BOOT_HIGH_ADDR	0xFFF00000

// Where should I put the stack? Upper and lower address bits
// This number should be 16-byte aligned (PPC ABI) or 8-byte aligned (PPC EABI)
#define STACK_LOC	0x00070000

// If we're using the MMU we need to set up the BAT registers. Since we don't
// have a nice operating system handling page table entries and the like for
// us, the BATs provide the easiest translation mechanism. The user must define
// the BAT mappings here. For unused BATs, specify the BAT as INVALID and
// having NO_ACCESS as shown for BATs 3 to 7 below.

// Address mapping for the IceCube+ board:
// - RAM starts at address 0x00000000 and is 64 MB in size.
// - Flash starts at address 0xFF800000 and is 8 MB in size.
// - Internal peripheral address space is 64 kB in size. Its start address is
//   read from MBAR shadow register (SPR 311).
#define PRAM_BASE	RAM_START
#define PROM_BASE	FLASH_START
#define PMBAR		0x80000000
#define VRAM_BASE	PRAM_BASE
#define VROM_BASE	PROM_BASE
#define VMBAR		PMBAR

#define IBAT0L_VAL (PRAM_BASE | BAT_READ_WRITE)
#define IBAT0U_VAL (VRAM_BASE | BAT_BL_64M | BAT_VALID_SUPERVISOR | BAT_VALID_USER)
#define DBAT0L_VAL IBAT0L_VAL
#define DBAT0U_VAL IBAT0U_VAL

#define IBAT1L_VAL (PROM_BASE | BAT_READ_WRITE)
#define IBAT1U_VAL (VROM_BASE | BAT_BL_8M | BAT_VALID_SUPERVISOR | BAT_VALID_USER)
#define DBAT1L_VAL (PROM_BASE | BAT_CACHE_INHIBITED | BAT_READ_WRITE)
#define DBAT1U_VAL (VROM_BASE | BAT_BL_8M | BAT_VALID_SUPERVISOR | BAT_VALID_USER)

#define IBAT2L_VAL (PMBAR | BAT_CACHE_INHIBITED | BAT_READ_WRITE)
#define IBAT2U_VAL (VMBAR | BAT_BL_128K | BAT_VALID_SUPERVISOR | BAT_VALID_USER)
#define DBAT2L_VAL IBAT2L_VAL
#define DBAT2U_VAL IBAT2U_VAL

#define IBAT3L_VAL (BAT_NO_ACCESS)
#define IBAT3U_VAL (BAT_INVALID)
#define DBAT3L_VAL (BAT_NO_ACCESS)
#define DBAT3U_VAL (BAT_INVALID)

#define IBAT4L_VAL (BAT_NO_ACCESS)
#define IBAT4U_VAL (BAT_INVALID)
#define DBAT4L_VAL (BAT_NO_ACCESS)
#define DBAT4U_VAL (BAT_INVALID)

#define IBAT5L_VAL (BAT_NO_ACCESS)
#define IBAT5U_VAL (BAT_INVALID)
#define DBAT5L_VAL (BAT_NO_ACCESS)
#define DBAT5U_VAL (BAT_INVALID)

#define IBAT6L_VAL (BAT_NO_ACCESS)
#define IBAT6U_VAL (BAT_INVALID)
#define DBAT6L_VAL (BAT_NO_ACCESS)
#define DBAT6U_VAL (BAT_INVALID)

#define IBAT7L_VAL (BAT_NO_ACCESS)
#define IBAT7U_VAL (BAT_INVALID)
#define DBAT7L_VAL (BAT_NO_ACCESS)
#define DBAT7U_VAL (BAT_INVALID)
