/******************************************************************************
*
*       COPYRIGHT (c) 2003 MOTOROLA INC.
*       ALL RIGHTS RESERVED
*
* Filename:     regdefs.h
* Author:       Mark Jonas
* Revision:     1.0
*
* History:      2003-May-30: First release.
*
* Description:  Register definitions for init.S.
*
* Notes:        
*
******************************************************************************/

// Peripheral registers
#define IPBI_CS0_START		0x0004
#define IPBI_CS0_STOP		0x0008
#define IPBI_SDRAM_CONF0	0x0034
#define IPBI_SDRAM_CONF1	0x0038
#define IPBI_CTRL		0x0054
#define IPBI_CTRL_CSBOOT	0x02000000
#define IPBI_CTRL_CS0		0x00010000
#define IPBI_CTRL_WSE		0x00000001

#define SDRAM_MODE		0x0100
#define SDRAM_CTRL		0x0104
#define SDRAM_CONF1		0x0108
#define SDRAM_CONF2		0x010C

#define CDM_PORSTCFG		0x0204

#define LPC_CS_CTRL		0x0318
#define LPC_CS_CTRL_EBEE	0x8000
#define LPC_CS_CTRL_ME		0x0100

// Core registers
#define hid0 1008
#define srr1 27
#define srr0 26
#define ibat0u 528
#define ibat0l 529
#define ibat1u 530
#define ibat1l 531
#define ibat2u 532
#define ibat2l 533
#define ibat3u 534
#define ibat3l 535
#define dbat0u 536
#define dbat0l 537
#define dbat1u 538
#define dbat1l 539
#define dbat2u 540
#define dbat2l 541
#define dbat3u 542
#define dbat3l 543
#define ibat4u 560
#define ibat4l 561
#define ibat5u 562
#define ibat5l 563
#define ibat6u 564
#define ibat6l 565
#define ibat7u 566
#define ibat7l 567
#define dbat4u 568
#define dbat4l 569
#define dbat5u 570
#define dbat5l 571
#define dbat6u 572
#define dbat6l 573
#define dbat7u 574
#define dbat7l 575
#define mbar 311

// General BAT defines for bit settings to compose BAT regs

// The BL field is part of the Upper Bat Register
#define BAT_BL_128K	0x00000000
#define BAT_BL_256K	0x00000004
#define BAT_BL_512K	0x0000000C
#define BAT_BL_1M	0x0000001C
#define BAT_BL_2M	0x0000003C
#define BAT_BL_4M	0x0000007C
#define BAT_BL_8M	0x000000FC
#define BAT_BL_16M	0x000001FC
#define BAT_BL_32M	0x000003FC
#define BAT_BL_64M	0x000007FC
#define BAT_BL_128M	0x00000FFC
#define BAT_BL_256M	0x00001FFC

// Supervisor/user valid mode definitions - Upper BAT
#define BAT_VALID_SUPERVISOR 0x00000002
#define BAT_VALID_USER 0x00000001
#define BAT_INVALID 0x00000000

// WIMG bit settings - Lower BAT
#define BAT_WRITE_THROUGH 0x00000040
#define BAT_CACHE_INHIBITED 0x00000020
#define BAT_COHERENT 0x00000010
#define BAT_GUARDED 0x00000008

// Protection bits - Lower BAT
#define BAT_NO_ACCESS 0x00000000
#define BAT_READ_ONLY 0x00000001
#define BAT_READ_WRITE 0x00000002
